﻿#Requires AutoHotkey v2.0

;Make a file in the script's folder called lefthanded.txt if you do want left handed keybinds


;Each Monitor's Center Coordinates (Relative to the primary monitor), change these as needed
mon1x := -540
mon1y := 720
mon2x := 960
mon2y := 540
mon3x := 2880
mon3y := 540
mon4x := 1830
mon4y := 1440

;reload this script with hotkey Alt+Shift+R to apply changes
!+r::Reload

;open powershell on ctrl+alt+t
^!t::Run "C:\Windows\system32\WindowsPowerShell\v1.0\powershell.exe"

;make ctrl+k ctrl+e (quick chat switching on teams and opens search on browser like ctrl k does)
^k::^e


;Move Windows between monitors:
Numpad0 & NumpadSub::MoveWindowToMonitor(mon1x,mon1y)
Numpad0 & NumpadAdd::MoveWindowToMonitor(mon2x,mon2y)
Numpad0 & NumpadEnter::MoveWindowToMonitor(mon3x,mon3y)
Numpad0 & NumpadDot::MoveWindowToMonitor(mon4x,mon4y)

;Move focus between montiors:
NumpadSub::ActivateMonitor1
NumpadAdd::ActivateMonitor2
NumpadEnter::ActivateMonitor3
NumpadDot::ActivateMonitor4

;Snap Windows to sides of screen:
numpad4::SnapLeft()
numpad2::SnapDown()
numpad8::SnapUp()
numpad6::SnapRight()
numpad7::SnapUpLeft()
numpad1::SnapDownLeft()
numpad3::SnapDownRight()
numpad9::SnapUpRight()
numpad5::Maximize()



;Left Handed Keybinds!
#HotIf (FileExist("lefthanded.txt"))
Pause::Escape
AppsKey::RWin
>!\::!Tab
>+!|::!+Tab
^AppsKey::^z
^/::^x
^.::^c
^,::^v
^'::^a
^o::^t
^;::^s
^[::^w
!+Enter::Run "C:\Windows\system32\WindowsPowerShell\v1.0\powershell.exe"
>!]::!f4
^\::^Tab
^+\::^+Tab
;Move Windows between monitors:
>!>+M::MoveWindowToMonitor(mon4x,mon4y)
>!>+,::MoveWindowToMonitor(mon1x,mon1y)
>!>+.::MoveWindowToMonitor(mon2x,mon2y)
>!>+/::MoveWindowToMonitor(mon3x,mon3y)
;Move focus between montiors:
!,::ActivateMonitor1
!.::ActivateMonitor2
!/::ActivateMonitor3
!m::ActivateMonitor4
#HotIf


;Functions:

ActivateMonitor4(){
ActivateWindowOnAnotherMonitor(1)
DllCall("SetCursorPos", "int", mon4x, "int", mon4y)
}
ActivateMonitor1(){
ActivateWindowOnAnotherMonitor(4)
DllCall("SetCursorPos", "int", mon1x, "int", mon1y)
}
ActivateMonitor2(){
ActivateWindowOnAnotherMonitor(2)
DllCall("SetCursorPos", "int", mon2x, "int", mon2y)
}
ActivateMonitor3(){
ActivateWindowOnAnotherMonitor(3)
DllCall("SetCursorPos", "int", mon3x, "int", mon3y)
}


CenterWindow(WinTitle)
{
WinGetPos &X, &Y, &W, &H, "A" ; xcoord ycoord width height activewindow
WinRestore "A"
WinRestore "A"
WinMove X, Y, 512, 512, "A"
Sleep 50
}

Maximize(){
WinRestore "A"
WinMaximize "A"
}

SnapLeft(){
CenterWindow("A")
Sleep 50
Send "#{Left}"
}   

SnapRight(){
CenterWindow("A")
Sleep 50
Send "#{Right}"
}

SnapUp(){
CenterWindow("A")
Send "#{Up}"
Sleep 50
Send "#{Up}"
}

SnapDown(){
SnapUp()
Sleep 500
WinGetPos &X, &Y, &W, &H, "A" ; xcoord ycoord width height activewindow
Y := Y+H
WinMove X, Y, W, H, "A"
}

SnapDownTest(){
WinGetPos &X, &Y, &W, &H, "A" ; xcoord ycoord width height activewindow
Y := Y+H
WinMove X, Y, W, H, "A"
}
   
SnapDownLeft(){
SnapLeft()
Sleep 50
Send "#{Down}"
}
SnapUpLeft(){
SnapLeft()
Sleep 50
Send "#{Up}"
}  

SnapDownRight(){
SnapRight()
Sleep 50
Send "#{Down}"
}
SnapUpRight(){
SnapRight()
Sleep 50
Send "#{Up}"
}  

MoveWindowToMonitor(xcoord, ycoord){
WinRestore "A"
WinMove xcoord, ycoord, 512, 512, "A"
DllCall("SetCursorPos", "int", xcoord, "int", ycoord)
Sleep 50 
WinMaximize "A"
}

ActivateWindowOnAnotherMonitor(MonitorToSwitchTo)
{ 
    if MonitorToSwitchTo > MonitorGetCount()                        ; if monitor to check exceeds amount of actual monitors
        return                                                      ; exit

    exceptions := '(Shell_TrayWnd|Shell_SecondaryTrayWnd|WorkerW)'  ; uses classname. both taskbars and desktop

    ids := WinGetList(,,, 'Program Manager')                        ; store an array of all the window ids in an array called ids, except desktop

    for id in ids                                                   ; loop through windows
    {
        if InStr(exceptions, WinGetClass(id))                       ; if window class is part of the exceptions
            continue                                                ; skip

        thisMonitor := MonitorFromWindow(id)                        ; find out which monitor this window is on

        if thisMonitor = MonitorToSwitchTo                          ; if window is found on monitor the hotkey requested
        {

            if not WinActive(id)                                    ; if window is not active
                WinActivate(id)                                     ; activate found window

            break                                                   ; done
        }
    }
}


MonitorFromWindow(id := 'A')
{
    try monFromWin := DllCall('MonitorFromWindow', 'Ptr', WinGetID(id), 'UInt', 2)  ; get monitor handle number window is on
    catch {                                                                         ; if it fails because of something weird active like alt-tab menu,
        return MonitorGetPrimary()                                                  ; return primary monitor number as a fallback
    }
    return ConvertHandleToNumber(monFromWin)                                        ; convert handle to monitor number and return it
}


ConvertHandleToNumber(handle)
{
    monCallback   := CallbackCreate(__EnumMonitors, 'Fast', 4)                      ; fast-mode, 4 parameters
    monHandleList := ''                                                             ; initialize monitor handle number list

    if EnumerateDisplays(monCallback)                                               ; enumerates all monitors
    {
        loop parse, monHandleList, '`n'                                             ; loop list of monitor handle numbers
            if A_LoopField = handle                                                 ; if the handle number matches the monitor the mouse is on
                return A_Index                                                      ; set monFromMouse to monitor number
    }

    __EnumMonitors(hMonitor, hDevCon, pRect, args) {                                ; callback function for enumeration DLL
        monHandleList .= hMonitor '`n'                                              ; add monitor handle number to list
        return true                                                                 ; continues enumeration
    }
}

EnumerateDisplays(callback) => DllCall('EnumDisplayMonitors', 'Ptr', 0, 'Ptr', 0, 'Ptr', callback, 'UInt', 0)