/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.CustomGuis;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<qs, qs> textureLocations = null;
    private NbtTagValue nbtName = null;
    private bif[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private MatchProfession[] professions = null;
    private EnumVariant[] variants = null;
    private bay[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final bay[] COLORS_INVALID = new bay[0];
    private static final qs ANVIL_GUI_TEXTURE = new qs("textures/gui/container/anvil.png");
    private static final qs BEACON_GUI_TEXTURE = new qs("textures/gui/container/beacon.png");
    private static final qs BREWING_STAND_GUI_TEXTURE = new qs("textures/gui/container/brewing_stand.png");
    private static final qs CHEST_GUI_TEXTURE = new qs("textures/gui/container/generic_54.png");
    private static final qs CRAFTING_TABLE_GUI_TEXTURE = new qs("textures/gui/container/crafting_table.png");
    private static final qs HORSE_GUI_TEXTURE = new qs("textures/gui/container/horse.png");
    private static final qs DISPENSER_GUI_TEXTURE = new qs("textures/gui/container/dispenser.png");
    private static final qs ENCHANTMENT_TABLE_GUI_TEXTURE = new qs("textures/gui/container/enchanting_table.png");
    private static final qs FURNACE_GUI_TEXTURE = new qs("textures/gui/container/furnace.png");
    private static final qs HOPPER_GUI_TEXTURE = new qs("textures/gui/container/hopper.png");
    private static final qs INVENTORY_GUI_TEXTURE = new qs("textures/gui/container/inventory.png");
    private static final qs SHULKER_BOX_GUI_TEXTURE = new qs("textures/gui/container/shulker_box.png");
    private static final qs VILLAGER_GUI_TEXTURE = new qs("textures/gui/container/villager2.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations(props, "texture", this.container, "textures/gui/", this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListInt(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        Enum[] vars = CustomGuiProperties.getContainerVariants(this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), vars, "variants", VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors(props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static bay[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize(str, " ");
        bay[] cols = new bay[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            bay col = CustomGuiProperties.parseEnumDyeColor(token);
            if (col == null) {
                CustomGuiProperties.warn("Invalid color: " + token);
                return COLORS_INVALID;
            }
            cols[i] = col;
        }
        return cols;
    }

    private static bay parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        bay[] colors = bay.values();
        for (int i = 0; i < colors.length; ++i) {
            bay enumDyeColor = colors[i];
            if (enumDyeColor.m().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.b().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static qs parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        String tex = TextureUtils.fixResourcePath(str = str.trim(), basePath);
        if (!tex.endsWith(".png")) {
            tex = tex + ".png";
        }
        return new qs(basePath + "/" + tex);
    }

    private static Map<qs, qs> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<qs, qs> map = new HashMap<qs, qs>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            qs locKey = CustomGuiProperties.getGuiTextureLocation(container);
            qs locVal = CustomGuiProperties.parseTextureLocation(propVal, basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix(pathRel, "/", ".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            qs locKey = new qs(path);
            qs locVal = CustomGuiProperties.parseTextureLocation(val, basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static qs getGuiTextureLocation(EnumContainer container) {
        switch (container) {
            case ANVIL: {
                return ANVIL_GUI_TEXTURE;
            }
            case BEACON: {
                return BEACON_GUI_TEXTURE;
            }
            case BREWING_STAND: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case CHEST: {
                return CHEST_GUI_TEXTURE;
            }
            case CRAFTING: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case CREATIVE: {
                return null;
            }
            case DISPENSER: {
                return DISPENSER_GUI_TEXTURE;
            }
            case ENCHANTMENT: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case FURNACE: {
                return FURNACE_GUI_TEXTURE;
            }
            case HOPPER: {
                return HOPPER_GUI_TEXTURE;
            }
            case HORSE: {
                return HORSE_GUI_TEXTURE;
            }
            case INVENTORY: {
                return INVENTORY_GUI_TEXTURE;
            }
            case SHULKER_BOX: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case VILLAGER: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn("No base path found: " + path);
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn("No container found: " + path);
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn("No texture found: " + path);
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn("Invalid professions or careers: " + path);
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn("Invalid variants: " + path);
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn("Invalid colors: " + path);
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }

    private boolean matchesGeneral(EnumContainer ec, ev pos, bhl blockAccess) {
        bif biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome(biome = blockAccess.c(pos), this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.p());
    }

    public boolean matchesPos(EnumContainer ec, ev pos, bhl blockAccess, czt screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName(screen))) {
            return false;
        }
        switch (ec) {
            case BEACON: {
                return this.matchesBeacon(pos, blockAccess);
            }
            case CHEST: {
                return this.matchesChest(pos, blockAccess);
            }
            case DISPENSER: {
                return this.matchesDispenser(pos, blockAccess);
            }
            case SHULKER_BOX: {
                return this.matchesShulker(pos, blockAccess);
            }
        }
        return true;
    }

    public static String getName(czt screen) {
        jm itc = screen.getTitle();
        if (itc == null) {
            return null;
        }
        return itc.d();
    }

    private boolean matchesBeacon(ev pos, bhl blockAccess) {
        int l2;
        btn te = blockAccess.d(pos);
        if (!(te instanceof btj)) {
            return false;
        }
        btj teb = (btj)te;
        return this.levels == null || this.levels.isInRange(l2 = teb.h());
    }

    private boolean matchesChest(ev pos, bhl blockAccess) {
        btn te = blockAccess.d(pos);
        if (te instanceof btr) {
            btr tec = (btr)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof btz) {
            btz teec = (btz)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(btr tec, ev pos, bhl blockAccess) {
        bvk blockState = blockAccess.e_(pos);
        bwd chestType = blockState.b((bwn)bnb.b) ? (bwd)blockState.c((bwn)bnb.b) : bwd.a;
        boolean isLarge = chestType == bwd.a;
        boolean isTrapped = tec instanceof bur;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(btz teec, ev pos, bhl blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(ev pos, bhl blockAccess) {
        EnumVariant var;
        btn te = blockAccess.d(pos);
        if (!(te instanceof btw)) {
            return false;
        }
        btw ted = (btw)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(btw ted) {
        if (ted instanceof btx) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(ev pos, bhl blockAccess) {
        bay col;
        btn te = blockAccess.d(pos);
        if (!(te instanceof bui)) {
            return false;
        }
        bui tesb = (bui)te;
        return this.colors == null || Config.equalsOne(col = tesb.t(), this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, aii entity, bhl blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.bN(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.bC())) {
            return false;
        }
        switch (ec) {
            case VILLAGER: {
                return this.matchesVillager(entity, blockAccess);
            }
            case HORSE: {
                return this.matchesHorse(entity, blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(aii entity, bhl blockAccess) {
        int level;
        avm vd;
        avo vp;
        if (!(entity instanceof avl)) {
            return false;
        }
        avl entityVillager = (avl)entity;
        return this.professions == null || MatchProfession.matchesOne(vp = (vd = entityVillager.eh()).b(), level = vd.c(), this.professions);
    }

    private boolean matchesHorse(aii entity, bhl blockAccess) {
        arw el;
        bay col;
        EnumVariant var;
        if (!(entity instanceof art)) {
            return false;
        }
        art ah = (art)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof arw) || Config.equalsOne(col = (el = (arw)ah).eE(), this.colors);
    }

    private EnumVariant getHorseVariant(art entity) {
        if (entity instanceof arv) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof aru) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof arx) {
            return EnumVariant.MULE;
        }
        if (entity instanceof arw) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public qs getTextureLocation(qs loc) {
        qs locNew = this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + (Object)((Object)this.container) + ", textures: " + this.textureLocations;
    }

    private static enum EnumVariant {
        HORSE,
        DONKEY,
        MULE,
        LLAMA,
        DISPENSER,
        DROPPER;

    }

    public static enum EnumContainer {
        ANVIL,
        BEACON,
        BREWING_STAND,
        CHEST,
        CRAFTING,
        DISPENSER,
        ENCHANTMENT,
        FURNACE,
        HOPPER,
        HORSE,
        VILLAGER,
        SHULKER_BOX,
        CREATIVE,
        INVENTORY;

    }
}

