/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.optifine.DynamicLight;
import net.optifine.DynamicLightsMap;
import net.optifine.config.ConnectedParser;
import net.optifine.config.EntityTypeNameLocator;
import net.optifine.config.IObjectLocator;
import net.optifine.config.ItemLocator;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.util.PropertiesOrdered;

public class DynamicLights {
    private static DynamicLightsMap mapDynamicLights = new DynamicLightsMap();
    private static Map<String, Integer> mapEntityLightLevels = new HashMap<String, Integer>();
    private static Map<bbw, Integer> mapItemLightLevels = new HashMap<bbw, Integer>();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static final qh<bcb> PARAMETER_ITEM_STACK = (qh)Reflector.EntityItem_ITEM.getValue();
    private static boolean initialized;

    public static void entityAdded(aii entityIn, dko renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(aii entityIn, dko renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLight dynamicLight = mapDynamicLights.remove(entityIn.T());
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(dko renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        if (!initialized) {
            DynamicLights.initialize();
        }
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLights.updateMapDynamicLights(renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i = 0; i < dynamicLights.size(); ++i) {
                DynamicLight dynamicLight = dynamicLights.get(i);
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void initialize() {
        initialized = true;
        mapEntityLightLevels.clear();
        mapItemLightLevels.clear();
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i = 0; i < modIds.length; ++i) {
            String modId = modIds[i];
            try {
                qs loc = new qs(modId, "optifine/dynamic_lights.properties");
                InputStream in = Config.getResourceStream(loc);
                DynamicLights.loadModConfiguration(in, loc.toString(), modId);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (mapEntityLightLevels.size() > 0) {
            Config.dbg("DynamicLights entities: " + mapEntityLightLevels.size());
        }
        if (mapItemLightLevels.size() > 0) {
            Config.dbg("DynamicLights items: " + mapItemLightLevels.size());
        }
    }

    private static void loadModConfiguration(InputStream in, String path, String modId) {
        if (in == null) {
            return;
        }
        try {
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg("DynamicLights: Parsing " + path);
            ConnectedParser cp = new ConnectedParser("DynamicLights");
            DynamicLights.loadModLightLevels(props.getProperty("entities"), mapEntityLightLevels, new EntityTypeNameLocator(), cp, path, modId);
            DynamicLights.loadModLightLevels(props.getProperty("items"), mapItemLightLevels, new ItemLocator(), cp, path, modId);
        }
        catch (IOException e2) {
            Config.warn("DynamicLights: Error reading " + path);
        }
    }

    private static <T> void loadModLightLevels(String prop, Map<T, Integer> mapLightLevels, IObjectLocator<T> ol, ConnectedParser cp, String path, String modId) {
        if (prop == null) {
            return;
        }
        String[] parts = Config.tokenize(prop, " ");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            String[] tokens = Config.tokenize(part, ":");
            if (tokens.length != 2) {
                cp.warn("Invalid entry: " + part + ", in:" + path);
                continue;
            }
            String name = tokens[0];
            String light = tokens[1];
            String nameFull = modId + ":" + name;
            qs loc = new qs(nameFull);
            T obj = ol.getObject(loc);
            if (obj == null) {
                cp.warn("Object not found: " + nameFull);
                continue;
            }
            int lightLevel = cp.parseInt(light, -1);
            if (lightLevel < 0 || lightLevel > 15) {
                cp.warn("Invalid light level: " + part);
                continue;
            }
            mapLightLevels.put(obj, new Integer(lightLevel));
        }
    }

    private static void updateMapDynamicLights(dko renderGlobal) {
        dhn world = renderGlobal.getWorld();
        if (world == null) {
            return;
        }
        Iterable entities = world.b();
        for (aii entity : entities) {
            DynamicLight dynamicLight;
            int key;
            int lightLevel = DynamicLights.getLightLevel(entity);
            if (lightLevel > 0) {
                key = entity.T();
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = entity.T();
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(ev pos, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(pos);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(aii entity, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(entity);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(ev pos) {
        double lightLevelMax = 0.0;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i = 0; i < dynamicLights.size(); ++i) {
                double dist;
                double light;
                double lightLevel;
                double dz;
                double dy;
                DynamicLight dynamicLight = dynamicLights.get(i);
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)pos.o() - px;
                double distSq = dx * dx + (dy = (double)pos.p() - py) * dy + (dz = (double)pos.q() - pz) * dz;
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit(lightLevelMax, 0.0, 15.0);
        return lightPlayer;
    }

    public static int getLightLevel(bcb itemStack) {
        Integer level;
        bae itemBlock;
        bmm block;
        if (itemStack == null) {
            return 0;
        }
        bbw item = itemStack.b();
        if (item instanceof bae && (block = (itemBlock = (bae)item).e()) != null) {
            return block.a(block.o());
        }
        if (item == bcc.kz) {
            return bmn.B.a(bmn.B.o());
        }
        if (item == bcc.mh || item == bcc.mp) {
            return 10;
        }
        if (item == bcc.la) {
            return 8;
        }
        if (item == bcc.of) {
            return 8;
        }
        if (item == bcc.mq) {
            return 8;
        }
        if (item == bcc.nV) {
            return bmn.ek.a(bmn.ek.o()) / 2;
        }
        if (!mapItemLightLevels.isEmpty() && (level = mapItemLightLevels.get(item)) != null) {
            return level;
        }
        return 0;
    }

    public static int getLightLevel(aii entity) {
        atw entityCreeper;
        String typeName;
        Integer level;
        avy player;
        if (entity == Config.getMinecraft().T() && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity instanceof avy && (player = (avy)entity).t()) {
            return 0;
        }
        if (entity.bb()) {
            return 15;
        }
        if (!mapEntityLightLevels.isEmpty() && (level = mapEntityLightLevels.get(typeName = EntityTypeNameLocator.getEntityTypeName(entity))) != null) {
            return level;
        }
        if (entity instanceof awd) {
            return 15;
        }
        if (entity instanceof atq) {
            return 15;
        }
        if (entity instanceof atu) {
            atu entityBlaze = (atu)entity;
            if (entityBlaze.l()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof auj) {
            auj emc = (auj)entity;
            if ((double)emc.c > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof atw && (double)(entityCreeper = (atw)entity).v(0.0f) > 0.001) {
            return 15;
        }
        if (entity instanceof air) {
            player = (air)entity;
            bcb stackMain = player.cQ();
            int levelMain = DynamicLights.getLightLevel(stackMain);
            bcb stackOff = player.cR();
            int levelOff = DynamicLights.getLightLevel(stackOff);
            bcb stackHead = player.b(ain.f);
            int levelHead = DynamicLights.getLightLevel(stackHead);
            int levelHandMax = Math.max(levelMain, levelOff);
            return Math.max(levelHandMax, levelHead);
        }
        if (entity instanceof atp) {
            atp entityItem = (atp)entity;
            bcb itemStack = DynamicLights.getItemStack(entityItem);
            return DynamicLights.getLightLevel(itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(dko renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i = 0; i < dynamicLights.size(); ++i) {
                DynamicLight dynamicLight = dynamicLights.get(i);
                dynamicLight.updateLitChunks(renderGlobal);
            }
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            return mapDynamicLights.size();
        }
    }

    public static bcb getItemStack(atp entityItem) {
        bcb itemstack = (bcb)entityItem.W().a(PARAMETER_ITEM_STACK);
        return itemstack;
    }
}

