/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.mojang.blaze3d.platform.GLX;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import net.optifine.util.PropertiesOrdered;

public class EmissiveTextures {
    private static String suffixEmissive = null;
    private static String suffixEmissivePng = null;
    private static boolean active = false;
    private static boolean render = false;
    private static boolean hasEmissive = false;
    private static boolean renderEmissive = false;
    private static duk textureManager = Config.getTextureManager();
    private static float lightMapX;
    private static float lightMapY;
    private static final String SUFFIX_PNG = ".png";
    private static final qs LOCATION_EMPTY;

    public static boolean isActive() {
        return active;
    }

    public static String getSuffixEmissive() {
        return suffixEmissive;
    }

    public static void beginRender() {
        render = true;
        hasEmissive = false;
    }

    public static dul getEmissiveTexture(dul texture, Map<qs, dul> mapTextures) {
        dul textureEmissive;
        if (!render) {
            return texture;
        }
        if (!(texture instanceof duf)) {
            return texture;
        }
        duf simpleTexture = (duf)texture;
        qs locationEmissive = simpleTexture.locationEmissive;
        if (!renderEmissive) {
            if (locationEmissive != null) {
                hasEmissive = true;
            }
            return texture;
        }
        if (locationEmissive == null) {
            locationEmissive = LOCATION_EMPTY;
        }
        if ((textureEmissive = mapTextures.get(locationEmissive)) == null) {
            textureEmissive = new duf(locationEmissive);
            textureManager.a(locationEmissive, textureEmissive);
        }
        return textureEmissive;
    }

    public static boolean hasEmissive() {
        return hasEmissive;
    }

    public static void beginRenderEmissive() {
        lightMapX = GLX.lastBrightnessX;
        lightMapY = GLX.lastBrightnessY;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)240.0f, (float)lightMapY);
        renderEmissive = true;
    }

    public static void endRenderEmissive() {
        renderEmissive = false;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lightMapX, (float)lightMapY);
    }

    public static void endRender() {
        render = false;
        hasEmissive = false;
    }

    public static void update() {
        active = false;
        suffixEmissive = null;
        suffixEmissivePng = null;
        if (!Config.isEmissiveTextures()) {
            return;
        }
        try {
            String fileName = "optifine/emissive.properties";
            qs loc = new qs(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            EmissiveTextures.dbg("Loading " + fileName);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            suffixEmissive = props.getProperty("suffix.emissive");
            if (suffixEmissive != null) {
                suffixEmissivePng = suffixEmissive + SUFFIX_PNG;
            }
            active = suffixEmissive != null;
        }
        catch (FileNotFoundException e2) {
            return;
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    public static void updateIcons(dui textureMap, Set<qs> locations) {
        if (!active) {
            return;
        }
        for (qs loc : locations) {
            EmissiveTextures.checkEmissive(textureMap, loc);
        }
    }

    private static void checkEmissive(dui textureMap, qs locSprite) {
        String suffixEm = EmissiveTextures.getSuffixEmissive();
        if (suffixEm == null) {
            return;
        }
        if (locSprite.a().endsWith(suffixEm)) {
            return;
        }
        qs locSpriteEm = new qs(locSprite.b(), locSprite.a() + suffixEm);
        qs locPngEm = textureMap.b(locSpriteEm);
        if (!Config.hasResource(locPngEm)) {
            return;
        }
        duj sprite = textureMap.registerSprite(locSprite);
        duj spriteEmissive = textureMap.registerSprite(locSpriteEm);
        spriteEmissive.isSpriteEmissive = true;
        sprite.spriteEmissive = spriteEmissive;
    }

    private static void dbg(String str) {
        Config.dbg("EmissiveTextures: " + str);
    }

    private static void warn(String str) {
        Config.warn("EmissiveTextures: " + str);
    }

    public static boolean isEmissive(qs loc) {
        if (suffixEmissivePng == null) {
            return false;
        }
        return loc.a().endsWith(suffixEmissivePng);
    }

    public static void loadTexture(qs loc, duf tex) {
        if (loc == null || tex == null) {
            return;
        }
        tex.isEmissive = false;
        tex.locationEmissive = null;
        if (suffixEmissivePng == null) {
            return;
        }
        String path = loc.a();
        if (!path.endsWith(SUFFIX_PNG)) {
            return;
        }
        if (path.endsWith(suffixEmissivePng)) {
            tex.isEmissive = true;
            return;
        }
        String pathEmPng = path.substring(0, path.length() - SUFFIX_PNG.length()) + suffixEmissivePng;
        qs locEmPng = new qs(loc.b(), pathEmPng);
        if (!Config.hasResource(locEmPng)) {
            return;
        }
        tex.locationEmissive = locEmPng;
    }

    static {
        LOCATION_EMPTY = new qs("optifine/ctm/default/empty.png");
    }
}

