/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class Lang {
    private static final Splitter splitter = Splitter.on((char)'=').limit(2);
    private static final Pattern pattern = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");

    public static void resourcesReloaded() {
        Map localeProperties = dvf.getLocaleProperties();
        ArrayList<String> listFiles = new ArrayList<String>();
        String PREFIX = "optifine/lang/";
        String EN_US = "en_us";
        String SUFFIX = ".lang";
        listFiles.add(PREFIX + EN_US + SUFFIX);
        if (!Config.getGameSettings().aL.equals(EN_US)) {
            listFiles.add(PREFIX + Config.getGameSettings().aL + SUFFIX);
        }
        String[] files = listFiles.toArray(new String[listFiles.size()]);
        Lang.loadResources((wh)Config.getDefaultResourcePack(), files, localeProperties);
        wh[] resourcePacks = Config.getResourcePacks();
        for (int i = 0; i < resourcePacks.length; ++i) {
            wh rp = resourcePacks[i];
            Lang.loadResources(rp, files, localeProperties);
        }
    }

    private static void loadResources(wh rp, String[] files, Map localeProperties) {
        try {
            for (int i = 0; i < files.length; ++i) {
                InputStream in;
                String file = files[i];
                qs loc = new qs(file);
                if (!rp.b(wi.a, loc) || (in = rp.a(wi.a, loc)) == null) continue;
                Lang.loadLocaleData(in, localeProperties);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void loadLocaleData(InputStream is2, Map localeProperties) throws IOException {
        for (String line : IOUtils.readLines((InputStream)is2, (Charset)Charsets.UTF_8)) {
            String[] parts;
            if (line.isEmpty() || line.charAt(0) == '#' || (parts = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)line), String.class)) == null || parts.length != 2) continue;
            String key = parts[0];
            String value = pattern.matcher(parts[1]).replaceAll("%$1s");
            localeProperties.put(key, value);
        }
    }

    public static String get(String key) {
        return dvf.a((String)key, (Object[])new Object[0]);
    }

    public static String get(String key, String def2) {
        String str = dvf.a((String)key, (Object[])new Object[0]);
        if (str == null || str.equals(key)) {
            return def2;
        }
        return str;
    }

    public static String getOn() {
        return dvf.a((String)"options.on", (Object[])new Object[0]);
    }

    public static String getOff() {
        return dvf.a((String)"options.off", (Object[])new Object[0]);
    }

    public static String getFast() {
        return dvf.a((String)"options.graphics.fast", (Object[])new Object[0]);
    }

    public static String getFancy() {
        return dvf.a((String)"options.graphics.fancy", (Object[])new Object[0]);
    }

    public static String getDefault() {
        return dvf.a((String)"generator.default", (Object[])new Object[0]);
    }
}

