/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import net.optifine.IRandomEntity;
import net.optifine.RandomEntities;
import net.optifine.RandomEntity;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.util.MathUtils;

public class RandomEntityRule {
    private String pathProps = null;
    private qs baseResLoc = null;
    private int index;
    private int[] textures = null;
    private qs[] resourceLocations = null;
    private int[] weights = null;
    private bif[] biomes = null;
    private RangeListInt heights = null;
    private NbtTagValue nbtName = null;
    public int[] sumWeights = null;
    public int sumAllWeights = 1;
    private MatchProfession[] professions = null;
    private bay[] collarColors = null;

    public RandomEntityRule(String pathProps, qs baseResLoc, int index, int[] textures, int[] weights, bif[] biomes, RangeListInt heights, NbtTagValue nbtName, MatchProfession[] professions, bay[] collarColors) {
        this.pathProps = pathProps;
        this.baseResLoc = baseResLoc;
        this.index = index;
        this.textures = textures;
        this.weights = weights;
        this.biomes = biomes;
        this.heights = heights;
        this.nbtName = nbtName;
        this.professions = professions;
        this.collarColors = collarColors;
    }

    public boolean isValid(String path) {
        if (this.textures == null || this.textures.length == 0) {
            Config.warn("Invalid skins for rule: " + this.index);
            return false;
        }
        if (this.resourceLocations != null) {
            return true;
        }
        this.resourceLocations = new qs[this.textures.length];
        boolean optifine = this.pathProps.startsWith("optifine/mob/");
        qs locOf = RandomEntities.getLocationRandom(this.baseResLoc, optifine);
        if (locOf == null) {
            Config.warn("Invalid path: " + this.baseResLoc.a());
            return false;
        }
        for (int i = 0; i < this.resourceLocations.length; ++i) {
            int index = this.textures[i];
            if (index <= 1) {
                this.resourceLocations[i] = this.baseResLoc;
                continue;
            }
            qs locNew = RandomEntities.getLocationIndexed(locOf, index);
            if (locNew == null) {
                Config.warn("Invalid path: " + this.baseResLoc.a());
                return false;
            }
            if (!Config.hasResource(locNew)) {
                Config.warn("Texture not found: " + locNew.a());
                return false;
            }
            this.resourceLocations[i] = locNew;
        }
        if (this.weights != null) {
            if (this.weights.length > this.resourceLocations.length) {
                Config.warn("More weights defined than skins, trimming weights: " + path);
                int[] weights2 = new int[this.resourceLocations.length];
                System.arraycopy(this.weights, 0, weights2, 0, weights2.length);
                this.weights = weights2;
            }
            if (this.weights.length < this.resourceLocations.length) {
                Config.warn("Less weights defined than skins, expanding weights: " + path);
                int[] weights2 = new int[this.resourceLocations.length];
                System.arraycopy(this.weights, 0, weights2, 0, this.weights.length);
                int avgWeight = MathUtils.getAverage(this.weights);
                for (int i = this.weights.length; i < weights2.length; ++i) {
                    weights2[i] = avgWeight;
                }
                this.weights = weights2;
            }
            this.sumWeights = new int[this.weights.length];
            int sum = 0;
            for (int i = 0; i < this.weights.length; ++i) {
                if (this.weights[i] < 0) {
                    Config.warn("Invalid weight: " + this.weights[i]);
                    return false;
                }
                this.sumWeights[i] = sum += this.weights[i];
            }
            this.sumAllWeights = sum;
            if (this.sumAllWeights <= 0) {
                Config.warn("Invalid sum of all weights: " + sum);
                this.sumAllWeights = 1;
            }
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            Config.warn("Invalid professions or careers: " + path);
            return false;
        }
        if (this.collarColors == ConnectedParser.DYE_COLORS_INVALID) {
            Config.warn("Invalid collar colors: " + path);
            return false;
        }
        return true;
    }

    public boolean matches(IRandomEntity randomEntity) {
        int level;
        avl entityVillager;
        avm vd;
        avo vp;
        RandomEntity rme;
        aii entity;
        String name;
        ev pos;
        if (this.biomes != null && !Matches.biome(randomEntity.getSpawnBiome(), this.biomes)) {
            return false;
        }
        if (this.heights != null && (pos = randomEntity.getSpawnPosition()) != null && !this.heights.isInRange(pos.p())) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = randomEntity.getName())) {
            return false;
        }
        if (this.professions != null && randomEntity instanceof RandomEntity && (entity = (rme = (RandomEntity)randomEntity).getEntity()) instanceof avl && !MatchProfession.matchesOne(vp = (vd = (entityVillager = (avl)entity).eh()).b(), level = vd.c(), this.professions)) {
            return false;
        }
        if (this.collarColors != null && randomEntity instanceof RandomEntity) {
            bay col;
            rme = (RandomEntity)randomEntity;
            entity = rme.getEntity();
            if (entity instanceof arr) {
                arr entityWolf = (arr)entity;
                if (!entityWolf.dV()) {
                    return false;
                }
                col = entityWolf.eh();
                return Config.equalsOne(col, this.collarColors);
            }
            if (entity instanceof aqt) {
                aqt entityCat = (aqt)entity;
                if (!entityCat.dV()) {
                    return false;
                }
                col = entityCat.ei();
                return Config.equalsOne(col, this.collarColors);
            }
        }
        return true;
    }

    public qs getTextureLocation(qs loc, int randomId) {
        if (this.resourceLocations == null || this.resourceLocations.length == 0) {
            return loc;
        }
        int index = 0;
        if (this.weights == null) {
            index = randomId % this.resourceLocations.length;
        } else {
            int randWeight = randomId % this.sumAllWeights;
            for (int i = 0; i < this.sumWeights.length; ++i) {
                if (this.sumWeights[i] <= randWeight) continue;
                index = i;
                break;
            }
        }
        return this.resourceLocations[index];
    }
}

