/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

public class MatchProfession {
    private avo profession;
    private int[] levels;

    public MatchProfession(avo profession) {
        this(profession, null);
    }

    public MatchProfession(avo profession, int level) {
        this(profession, new int[]{level});
    }

    public MatchProfession(avo profession, int[] levels) {
        this.profession = profession;
        this.levels = levels;
    }

    public boolean matches(avo prof, int lev) {
        if (this.profession != prof) {
            return false;
        }
        return this.levels == null || Config.equalsOne(lev, this.levels);
    }

    private boolean hasLevel(int lev) {
        if (this.levels == null) {
            return false;
        }
        return Config.equalsOne(lev, this.levels);
    }

    public boolean addLevel(int lev) {
        if (this.levels == null) {
            this.levels = new int[]{lev};
            return true;
        }
        if (this.hasLevel(lev)) {
            return false;
        }
        this.levels = Config.addIntToArray(this.levels, lev);
        return true;
    }

    public avo getProfession() {
        return this.profession;
    }

    public int[] getLevels() {
        return this.levels;
    }

    public static boolean matchesOne(avo prof, int level, MatchProfession[] mps) {
        if (mps == null) {
            return false;
        }
        for (int i = 0; i < mps.length; ++i) {
            MatchProfession mp = mps[i];
            if (!mp.matches(prof, level)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.levels == null) {
            return "" + this.profession;
        }
        return "" + this.profession + ":" + Config.arrayToString(this.levels);
    }
}

