/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.optifine.model.ModelUtils;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;
    private static final Random RANDOM = new Random(0L);

    public static dvx makeModelCube(String spriteName, int tintIndex) {
        duj sprite = Config.getMinecraft().L().a(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static dvx makeModelCube(duj sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        fa[] facings = fa.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            fa facing = facings[i];
            ArrayList<dlh> quads = new ArrayList<dlh>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        dls itemOverrideList = dls.a;
        dwf bakedModel = new dwf(generalQuads, faceQuads, true, true, sprite, dlu.a, itemOverrideList);
        return bakedModel;
    }

    public static dvx joinModelsCube(dvx modelBase, dvx modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.a(null, null, RANDOM));
        generalQuads.addAll(modelAdd.a(null, null, RANDOM));
        fa[] facings = fa.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            fa facing = facings[i];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.a(null, facing, RANDOM));
            quads.addAll(modelAdd.a(null, facing, RANDOM));
            faceQuads.put(facing, quads);
        }
        boolean ao = modelBase.a();
        boolean builtIn = modelBase.c();
        duj sprite = modelBase.d();
        dlu transforms = modelBase.e();
        dls itemOverrideList = modelBase.f();
        dwf bakedModel = new dwf(generalQuads, faceQuads, ao, builtIn, sprite, transforms, itemOverrideList);
        return bakedModel;
    }

    public static dlh makeBakedQuad(fa facing, duj sprite, int tintIndex) {
        b posFrom = new b(0.0f, 0.0f, 0.0f);
        b posTo = new b(16.0f, 16.0f, 16.0f);
        dll uv = new dll(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        dlj face = new dlj(facing, tintIndex, "#" + facing.m(), uv);
        dvy modelRotation = dvy.a;
        dlk partRotation = null;
        boolean shade = true;
        dlp faceBakery = new dlp();
        dlh quad = faceBakery.a(posFrom, posTo, face, sprite, facing, (dwd)modelRotation, partRotation, shade);
        return quad;
    }

    public static dvx makeModel(String modelName, String spriteOldName, String spriteNewName) {
        dui textureMap = Config.getMinecraft().L();
        duj spriteOld = textureMap.getSpriteSafe(spriteOldName);
        duj spriteNew = textureMap.getSpriteSafe(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static dvx makeModel(String modelName, duj spriteOld, duj spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        dwb modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        dwc mrl = new dwc(modelName, "");
        dvx model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        dvx modelNew = ModelUtils.duplicateModel(model);
        fa[] faces = fa.n;
        for (int i = 0; i < faces.length; ++i) {
            fa face = faces[i];
            List quads = modelNew.a(null, face, RANDOM);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a(null, null, RANDOM);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<dlh> quads, duj spriteOld, duj spriteNew) {
        ArrayList<dlh> quadsNew = new ArrayList<dlh>();
        for (dlh quad : quads) {
            if (quad.a() == spriteOld) {
                quad = new dlo(quad, spriteNew);
            }
            quadsNew.add(quad);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(b pos) {
        pos.a(BlockModelUtils.snapVertexCoord(pos.a()), BlockModelUtils.snapVertexCoord(pos.b()), BlockModelUtils.snapVertexCoord(pos.c()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static crs getOffsetBoundingBox(crs aabb, bmm.b offsetType, ev pos) {
        int x = pos.o();
        int z = pos.q();
        long k = (long)(x * 3129871) ^ (long)z * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double dx = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == bmm.b.c) {
            dy = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.d(dx, dy, dz);
    }
}

