/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.util.inventory;

import de.siphalor.mousewheelie.client.InteractionManager;
import de.siphalor.mousewheelie.client.util.ISlot;
import de.siphalor.mousewheelie.client.util.inventory.SortMode;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_481;
import org.apache.commons.lang3.ArrayUtils;

public class InventorySorter {
    private class_1703 container;
    private List<class_1735> inventorySlots;
    private class_1799[] stacks;

    public InventorySorter(class_1703 container, class_1735 originSlot) {
        this.container = container;
        this.collectSlots(originSlot);
        this.stacks = (class_1799[])this.inventorySlots.stream().map(slot -> slot.method_7677().method_7972()).toArray(class_1799[]::new);
    }

    private void collectSlots(class_1735 originSlot) {
        class_1263 inventory = originSlot.field_7871;
        this.inventorySlots = this.container.field_7761.stream().filter(slot -> slot.field_7871 == inventory && slot.method_7680(class_1799.field_8037)).collect(Collectors.toList());
        if (inventory instanceof class_1661) {
            int originInvSlot;
            if (((class_1661)inventory).field_7546.field_7503.field_7477 && class_310.method_1551().field_1755 instanceof class_481) {
                this.inventorySlots = Collections.emptyList();
            }
            boolean originInHotbar = (originInvSlot = ((ISlot)originSlot).mouseWheelie_getInvSlot()) >= 0 && originInvSlot < 9;
            int offHandInvSlot = inventory.method_5439() - 1;
            boolean originOffHand = originInvSlot == offHandInvSlot;
            this.inventorySlots = this.inventorySlots.stream().filter(slot -> {
                int invSlot = ((ISlot)slot).mouseWheelie_getInvSlot();
                return (invSlot >= 0 && invSlot < 9) == originInHotbar && invSlot == offHandInvSlot == originOffHand;
            }).collect(Collectors.toList());
        }
    }

    private void combineStacks() {
        ArrayDeque<InteractionManager.ClickEvent> clickEvents = new ArrayDeque<InteractionManager.ClickEvent>();
        for (int i = this.stacks.length - 1; i >= 0; --i) {
            int stackSize;
            class_1799 stack = this.stacks[i];
            if (stack.method_7960() || (stackSize = stack.method_7947()) >= stack.method_7909().method_7882()) continue;
            clickEvents.add(new InteractionManager.ClickEvent(this.container.field_7763, this.inventorySlots.get((int)i).field_7874, 0, class_1713.field_7790));
            for (int j = 0; j < i; ++j) {
                class_1799 targetStack = this.stacks[j];
                if (targetStack.method_7960() || targetStack.method_7947() >= targetStack.method_7909().method_7882() || stack.method_7909() != targetStack.method_7909() || !class_1799.method_7975((class_1799)stack, (class_1799)targetStack)) continue;
                int delta = targetStack.method_7909().method_7882() - targetStack.method_7947();
                delta = Math.min(delta, stackSize);
                targetStack.method_7939(targetStack.method_7947() + delta);
                clickEvents.add(new InteractionManager.ClickEvent(this.container.field_7763, this.inventorySlots.get((int)j).field_7874, 0, class_1713.field_7790));
                if ((stackSize -= delta) <= 0) break;
            }
            if (clickEvents.size() <= 1) {
                clickEvents.clear();
                continue;
            }
            InteractionManager.interactionEventQueue.addAll(clickEvents);
            InteractionManager.triggerSend();
            clickEvents.clear();
            if (stackSize > 0) {
                InteractionManager.pushClickEvent(this.container.field_7763, this.inventorySlots.get((int)i).field_7874, 0, class_1713.field_7790);
                stack.method_7939(stackSize);
                continue;
            }
            this.stacks[i] = class_1799.field_8037;
        }
    }

    public void sort(SortMode sortMode) {
        int i;
        this.combineStacks();
        int slotCount = this.stacks.length;
        Object[] sortIds = (Integer[])IntStream.range(0, slotCount).boxed().toArray(Integer[]::new);
        sortMode.init((Integer[])sortIds, this.stacks);
        Arrays.sort(sortIds, sortMode);
        BitSet doneSlashEmpty = new BitSet(slotCount * 2);
        for (i = 0; i < slotCount; ++i) {
            if (!this.stacks[i].method_7960()) continue;
            doneSlashEmpty.set(slotCount + i);
        }
        block1: for (i = 0; i < slotCount; ++i) {
            if (doneSlashEmpty.get(i) || doneSlashEmpty.get(sortIds[i])) continue;
            if (doneSlashEmpty.get(slotCount + i)) {
                doneSlashEmpty.set(slotCount + sortIds[i]);
            }
            if (i == sortIds[i]) {
                doneSlashEmpty.set(i);
                continue;
            }
            InteractionManager.pushClickEvent(this.container.field_7763, this.inventorySlots.get((int)sortIds[i].intValue()).field_7874, 0, class_1713.field_7790);
            doneSlashEmpty.clear(slotCount + sortIds[i]);
            int id = i;
            while (!doneSlashEmpty.get(id)) {
                InteractionManager.pushClickEvent(this.container.field_7763, this.inventorySlots.get((int)id).field_7874, 0, class_1713.field_7790);
                doneSlashEmpty.set(id);
                if (doneSlashEmpty.get(slotCount + id)) {
                    doneSlashEmpty.set(slotCount + id);
                    continue block1;
                }
                id = ArrayUtils.indexOf((Object[])sortIds, (Object)id);
            }
        }
    }
}

