/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.util.inventory;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;

public abstract class SortMode
implements Comparator<Integer> {
    public static final SortMode ALPHABET = new SortMode(){
        String[] strings;
        class_1799[] stacks;

        @Override
        public void init(Integer[] sortIds, class_1799[] stacks) {
            this.stacks = stacks;
            this.strings = (String[])Arrays.stream(sortIds).map(id -> {
                class_1799 itemStack = stacks[id];
                if (itemStack.method_7960()) {
                    return "";
                }
                return class_1074.method_4662((String)itemStack.method_7922(), (Object[])new Object[0]);
            }).toArray(String[]::new);
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            if (this.strings[o1].equals("")) {
                if (this.strings[o2].equals("")) {
                    return 0;
                }
                return 1;
            }
            if (this.strings[o2].equals("")) {
                return -1;
            }
            int comp = this.strings[o1].compareToIgnoreCase(this.strings[o2]);
            if (comp == 0) {
                return Integer.compare(this.stacks[o2].method_7947(), this.stacks[o1].method_7947());
            }
            return comp;
        }
    };
    public static final SortMode QUANTITY = new SortMode(){
        HashMap<class_1792, HashMap<class_2487, Integer>> itemToAmountMap = new HashMap();
        class_1799[] stacks;

        @Override
        void init(Integer[] sortIds, class_1799[] stacks) {
            this.stacks = stacks;
            for (class_1799 stack : stacks) {
                if (stack.method_7960()) continue;
                if (!this.itemToAmountMap.containsKey(stack.method_7909())) {
                    HashMap<class_2487, Integer> newMap = new HashMap<class_2487, Integer>();
                    newMap.put(stack.method_7948(), stack.method_7947());
                    this.itemToAmountMap.put(stack.method_7909(), newMap);
                    continue;
                }
                HashMap<class_2487, Integer> itemMap = this.itemToAmountMap.get(stack.method_7909());
                if (!itemMap.containsKey(stack.method_7948())) {
                    itemMap.put(stack.method_7969(), stack.method_7947());
                    continue;
                }
                itemMap.replace(stack.method_7969(), itemMap.get(stack.method_7969()) + stack.method_7947());
            }
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            class_1799 stack = this.stacks[o1];
            class_1799 stack2 = this.stacks[o2];
            if (stack.method_7960()) {
                return stack2.method_7960() ? 0 : 1;
            }
            if (stack2.method_7960()) {
                return -1;
            }
            Integer a = this.itemToAmountMap.get(stack.method_7909()).get(stack.method_7969());
            Integer a2 = this.itemToAmountMap.get(stack2.method_7909()).get(stack2.method_7969());
            return Integer.compare(a2, a);
        }
    };
    public static final SortMode RAW_ID = new SortMode(){
        Integer[] rawIds;

        @Override
        void init(Integer[] sortIds, class_1799[] stacks) {
            this.rawIds = (Integer[])Arrays.stream(stacks).map(stack -> stack.method_7960() ? Integer.MAX_VALUE : class_2378.field_11142.method_10249((Object)stack.method_7909())).toArray(Integer[]::new);
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return Integer.compare(this.rawIds[o1], this.rawIds[o2]);
        }
    };

    void init(Integer[] sortIds, class_1799[] stacks) {
    }

    public static enum Predefined {
        ALPHABET(ALPHABET),
        QUANTITY(QUANTITY),
        RAW_ID(RAW_ID),
        NONE(null);

        public SortMode sortMode;

        private Predefined(SortMode sortMode) {
            this.sortMode = sortMode;
        }
    }
}

