/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.mod;

import com.chocohead.mm.api.ClassTinkerers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import me.modmuss50.optifabric.patcher.ASMUtils;
import me.modmuss50.optifabric.patcher.ClassCache;
import net.fabricmc.loader.api.FabricLoader;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.MethodNode;

public class OptifineInjector {
    ClassCache classCache;
    public final Consumer<ClassNode> transformer = target -> {
        ClassNode source = this.getSourceClassNode((ClassNode)target);
        target.methods = source.methods;
        target.fields = source.fields;
        target.interfaces = source.interfaces;
        target.superName = source.superName;
        for (MethodNode methodNode2 : target.methods) {
            for (AbstractInsnNode insnNode : methodNode2.instructions.toArray()) {
                if (!(insnNode instanceof FrameNode)) continue;
                FrameNode frameNode = (FrameNode)insnNode;
                if (frameNode.local != null) continue;
                throw new IllegalStateException("Null locals in " + frameNode.type + " frame @ " + source.name + "#" + methodNode2.name + methodNode2.desc);
            }
        }
        if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
            target.access = OptifineInjector.modAccess(target.access);
            target.methods.forEach(methodNode -> {
                methodNode.access = OptifineInjector.modAccess(methodNode.access);
            });
            target.fields.forEach(fieldNode -> {
                fieldNode.access = OptifineInjector.modAccess(fieldNode.access);
            });
        }
    };

    public OptifineInjector(ClassCache classCache) {
        this.classCache = classCache;
    }

    public void setup() throws IOException {
        this.classCache.getClasses().forEach(s -> ClassTinkerers.addTransformation((String)s.replaceAll("/", ".").substring(0, s.length() - 6), this.transformer));
    }

    private static int modAccess(int access) {
        if ((access & 7) != 2) {
            return access & 0xFFFFFFF8 | 1;
        }
        return access;
    }

    private ClassNode getSourceClassNode(ClassNode classNode) {
        String name = classNode.name.replaceAll("\\.", "/") + ".class";
        byte[] bytes = this.classCache.getAndRemove(name);
        return ASMUtils.readClassFromBytes(bytes);
    }

    public String toString(InputStream inputStream, Charset charset) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        return stringBuilder.toString();
    }
}

