/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.ClassWriter;
import org.spongepowered.asm.lib.tree.ClassNode;

public class ASMUtils {
    public static ClassNode readClassFromBytes(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 8);
        return classNode;
    }

    public static byte[] writeClassToBytes(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static ClassNode asClassNode(JarEntry entry, JarFile jarFile) throws IOException {
        InputStream is = jarFile.getInputStream(entry);
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        return ASMUtils.readClassFromBytes(bytes);
    }

    public static boolean isSynthetic(int flags) {
        return (flags & 0x1000) != 0;
    }
}

