/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.modmuss50.optifabric.patcher.ClassCache;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.zeroturnaround.zip.ZipUtil;

public class PatchSplitter {
    public static ClassCache generateClassCache(File inputFile, File classCacheOutput, byte[] inputHash) throws IOException {
        boolean extractClasses = Boolean.parseBoolean(System.getProperty("optifabric.extract", "false"));
        File classesDir = new File(classCacheOutput.getParent(), "classes");
        if (extractClasses) {
            classesDir.mkdir();
        }
        ClassCache classCache = new ClassCache(inputHash);
        try (JarFile jarFile = new JarFile(inputFile);){
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry entry = entrys.nextElement();
                if (!entry.getName().startsWith("net/minecraft/") && !entry.getName().startsWith("com/mojang/") || !entry.getName().endsWith(".class")) continue;
                InputStream inputStream = jarFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    String name = entry.getName();
                    byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                    classCache.addClass(name, bytes);
                    if (!extractClasses) continue;
                    File classFile = new File(classesDir, entry.getName());
                    FileUtils.writeByteArrayToFile((File)classFile, (byte[])bytes);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        ZipUtil.removeEntries((File)inputFile, (String[])((String[])classCache.getClasses().stream().toArray(String[]::new)));
        System.out.println("Found " + classCache.getClasses().size() + " patched classes");
        classCache.save(classCacheOutput);
        return classCache;
    }
}

