/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.util.GLBufferedImage;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;

public class LiveGLBufferedImage
extends GLBufferedImage {
    private int scale = 1;

    public LiveGLBufferedImage(int width, int height, int imageType) {
        super(512, 512, imageType);
        this.scale = 512 / width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() {
        if (this.index == 0) {
            this.index = GLShim.glGenTextures();
        }
        this.buffer.clear();
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.put(this.bytes);
        }
        this.buffer.position(0).limit(this.bytes.length);
        GLShim.glBindTexture(3553, this.index);
        GLShim.glTexParameteri(3553, 10241, 9728);
        GLShim.glTexParameteri(3553, 10240, 9728);
        GLShim.glTexParameteri(3553, 10242, 33071);
        GLShim.glTexParameteri(3553, 10243, 33071);
        if (GLUtils.openGL14Enabled) {
            GLShim.glTexParameteri(3553, 33169, 1);
        }
        GLShim.glPixelStorei(3314, 0);
        GLShim.glPixelStorei(3316, 0);
        GLShim.glPixelStorei(3315, 0);
        GLShim.glTexImage2D(3553, 0, 6408, this.getWidth(), this.getHeight(), 0, 6408, 32821, this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRGB(int x, int y, int color24) {
        int alpha = color24 >> 24 & 0xFF;
        byte r = (byte)((color24 >> 0 & 0xFF) * alpha / 255);
        byte g = (byte)((color24 >> 8 & 0xFF) * alpha / 255);
        byte b = (byte)((color24 >> 16 & 0xFF) * alpha / 255);
        Object object = this.bufferLock;
        synchronized (object) {
            for (int t = 0; t < this.scale; ++t) {
                for (int s = 0; s < this.scale; ++s) {
                    int index = (x * this.scale + t + (y * this.scale + s) * this.getWidth()) * 4;
                    this.bytes[index] = -1;
                    this.bytes[index + 1] = r;
                    this.bytes[index + 2] = g;
                    this.bytes[index + 3] = b;
                }
            }
        }
    }

    @Override
    public void moveX(int offset) {
        super.moveX(offset * this.scale);
    }

    @Override
    public void moveY(int offset) {
        super.moveY(offset * this.scale);
    }
}

