/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2369;
import net.minecraft.class_2372;
import net.minecraft.class_2418;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.optifine.model.BlockModelUtils;
import net.optifine.util.PropertiesOrdered;

public class BetterGrass {
    private static boolean betterGrass = true;
    private static boolean betterGrassPath = true;
    private static boolean betterMycelium = true;
    private static boolean betterPodzol = true;
    private static boolean betterGrassSnow = true;
    private static boolean betterMyceliumSnow = true;
    private static boolean betterPodzolSnow = true;
    private static boolean grassMultilayer = false;
    private static class_1058 spriteGrass = null;
    private static class_1058 spriteGrassSide = null;
    private static class_1058 spriteGrassPath = null;
    private static class_1058 spriteGrassPathSide = null;
    private static class_1058 spriteMycelium = null;
    private static class_1058 spritePodzol = null;
    private static class_1058 spriteSnow = null;
    private static boolean spritesLoaded = false;
    private static class_1087 modelCubeGrass = null;
    private static class_1087 modelGrassPath = null;
    private static class_1087 modelCubeGrassPath = null;
    private static class_1087 modelCubeMycelium = null;
    private static class_1087 modelCubePodzol = null;
    private static class_1087 modelCubeSnow = null;
    private static boolean modelsLoaded = false;
    private static final String TEXTURE_GRASS_DEFAULT = "block/grass_block_top";
    private static final String TEXTURE_GRASS_SIDE_DEFAULT = "block/grass_block_side";
    private static final String TEXTURE_GRASS_PATH_DEFAULT = "block/grass_path_top";
    private static final String TEXTURE_GRASS_PATH_SIDE_DEFAULT = "block/grass_path_side";
    private static final String TEXTURE_MYCELIUM_DEFAULT = "block/mycelium_top";
    private static final String TEXTURE_PODZOL_DEFAULT = "block/podzol_top";
    private static final String TEXTURE_SNOW_DEFAULT = "block/snow";
    private static final Random RANDOM = new Random(0L);

    public static void updateIcons(class_1059 textureMap) {
        spritesLoaded = false;
        modelsLoaded = false;
        BetterGrass.loadProperties(textureMap);
    }

    public static void update() {
        if (!spritesLoaded) {
            return;
        }
        modelCubeGrass = BlockModelUtils.makeModelCube(spriteGrass, 0);
        if (grassMultilayer) {
            class_1087 modelCubeGrassSide = BlockModelUtils.makeModelCube(spriteGrassSide, -1);
            modelCubeGrass = BlockModelUtils.joinModelsCube(modelCubeGrassSide, modelCubeGrass);
        }
        modelGrassPath = BlockModelUtils.makeModel("grass_path", spriteGrassPathSide, spriteGrassPath);
        modelCubeGrassPath = BlockModelUtils.makeModelCube(spriteGrassPath, -1);
        modelCubeMycelium = BlockModelUtils.makeModelCube(spriteMycelium, -1);
        modelCubePodzol = BlockModelUtils.makeModelCube(spritePodzol, 0);
        modelCubeSnow = BlockModelUtils.makeModelCube(spriteSnow, -1);
        modelsLoaded = true;
    }

    private static void loadProperties(class_1059 textureMap) {
        betterGrass = true;
        betterGrassPath = true;
        betterMycelium = true;
        betterPodzol = true;
        betterGrassSnow = true;
        betterMyceliumSnow = true;
        betterPodzolSnow = true;
        spriteGrass = textureMap.registerSprite(new class_2960(TEXTURE_GRASS_DEFAULT));
        spriteGrassSide = textureMap.registerSprite(new class_2960(TEXTURE_GRASS_SIDE_DEFAULT));
        spriteGrassPath = textureMap.registerSprite(new class_2960(TEXTURE_GRASS_PATH_DEFAULT));
        spriteGrassPathSide = textureMap.registerSprite(new class_2960(TEXTURE_GRASS_PATH_SIDE_DEFAULT));
        spriteMycelium = textureMap.registerSprite(new class_2960(TEXTURE_MYCELIUM_DEFAULT));
        spritePodzol = textureMap.registerSprite(new class_2960(TEXTURE_PODZOL_DEFAULT));
        spriteSnow = textureMap.registerSprite(new class_2960(TEXTURE_SNOW_DEFAULT));
        spritesLoaded = true;
        String name = "optifine/bettergrass.properties";
        try {
            class_2960 locFile = new class_2960(name);
            if (!Config.hasResource(locFile)) {
                return;
            }
            InputStream in = Config.getResourceStream(locFile);
            if (in == null) {
                return;
            }
            boolean defaultConfig = Config.isFromDefaultResourcePack(locFile);
            if (defaultConfig) {
                Config.dbg("BetterGrass: Parsing default configuration " + name);
            } else {
                Config.dbg("BetterGrass: Parsing configuration " + name);
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            betterGrass = BetterGrass.getBoolean(props, "grass", true);
            betterGrassPath = BetterGrass.getBoolean(props, "grass_path", true);
            betterMycelium = BetterGrass.getBoolean(props, "mycelium", true);
            betterPodzol = BetterGrass.getBoolean(props, "podzol", true);
            betterGrassSnow = BetterGrass.getBoolean(props, "grass.snow", true);
            betterMyceliumSnow = BetterGrass.getBoolean(props, "mycelium.snow", true);
            betterPodzolSnow = BetterGrass.getBoolean(props, "podzol.snow", true);
            grassMultilayer = BetterGrass.getBoolean(props, "grass.multilayer", false);
            spriteGrass = BetterGrass.registerSprite(props, "texture.grass", TEXTURE_GRASS_DEFAULT, textureMap);
            spriteGrassSide = BetterGrass.registerSprite(props, "texture.grass_side", TEXTURE_GRASS_SIDE_DEFAULT, textureMap);
            spriteGrassPath = BetterGrass.registerSprite(props, "texture.grass_path", TEXTURE_GRASS_PATH_DEFAULT, textureMap);
            spriteGrassPathSide = BetterGrass.registerSprite(props, "texture.grass_path_side", TEXTURE_GRASS_PATH_SIDE_DEFAULT, textureMap);
            spriteMycelium = BetterGrass.registerSprite(props, "texture.mycelium", TEXTURE_MYCELIUM_DEFAULT, textureMap);
            spritePodzol = BetterGrass.registerSprite(props, "texture.podzol", TEXTURE_PODZOL_DEFAULT, textureMap);
            spriteSnow = BetterGrass.registerSprite(props, "texture.snow", TEXTURE_SNOW_DEFAULT, textureMap);
        }
        catch (IOException e) {
            Config.warn("Error reading: " + name + ", " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private static class_1058 registerSprite(Properties props, String key, String textureDefault, class_1059 textureMap) {
        class_2960 locPng;
        String texture = props.getProperty(key);
        if (texture == null) {
            texture = textureDefault;
        }
        if (!Config.hasResource(locPng = new class_2960("textures/" + texture + ".png"))) {
            Config.warn("BetterGrass texture not found: " + locPng);
            texture = textureDefault;
        }
        class_2960 locSprite = new class_2960(texture);
        class_1058 sprite = textureMap.registerSprite(locSprite);
        return sprite;
    }

    public static List getFaceQuads(class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, class_2350 facing, List quads) {
        if (facing == class_2350.field_11036 || facing == class_2350.field_11033) {
            return quads;
        }
        if (!modelsLoaded) {
            return quads;
        }
        class_2248 block = blockState.method_11614();
        if (block instanceof class_2418) {
            return BetterGrass.getFaceQuadsMycelium(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof class_2369) {
            return BetterGrass.getFaceQuadsGrassPath(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == class_2246.field_10520) {
            return BetterGrass.getFaceQuadsPodzol(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == class_2246.field_10566) {
            return BetterGrass.getFaceQuadsDirt(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof class_2372) {
            return BetterGrass.getFaceQuadsGrass(blockAccess, blockState, blockPos, facing, quads);
        }
        return quads;
    }

    private static List getFaceQuadsMycelium(class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, class_2350 facing, List quads) {
        boolean snowy;
        class_2248 blockUp = blockAccess.method_8320(blockPos.method_10084()).method_11614();
        boolean bl = snowy = blockUp == class_2246.field_10491 || blockUp == class_2246.field_10477;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterMyceliumSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == class_2246.field_10477) {
                    return modelCubeSnow.method_4707(blockState, facing, RANDOM);
                }
            } else if (betterMycelium && BetterGrass.getBlockAt(blockPos.method_10074(), facing, blockAccess) == class_2246.field_10402) {
                return modelCubeMycelium.method_4707(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterMyceliumSnow) {
                return modelCubeSnow.method_4707(blockState, facing, RANDOM);
            }
        } else if (betterMycelium) {
            return modelCubeMycelium.method_4707(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrassPath(class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, class_2350 facing, List quads) {
        if (!betterGrassPath) {
            return quads;
        }
        if (Config.isBetterGrassFancy()) {
            if (BetterGrass.getBlockAt(blockPos.method_10074(), facing, blockAccess) == class_2246.field_10194) {
                return modelGrassPath.method_4707(blockState, facing, RANDOM);
            }
        } else {
            return modelGrassPath.method_4707(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsPodzol(class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, class_2350 facing, List quads) {
        boolean snowy;
        class_2248 blockTop = BetterGrass.getBlockAt(blockPos, class_2350.field_11036, blockAccess);
        boolean bl = snowy = blockTop == class_2246.field_10491 || blockTop == class_2246.field_10477;
        if (Config.isBetterGrassFancy()) {
            class_2338 posSide;
            class_2680 stateSide;
            if (snowy) {
                if (betterPodzolSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == class_2246.field_10477) {
                    return modelCubeSnow.method_4707(blockState, facing, RANDOM);
                }
            } else if (betterPodzol && (stateSide = blockAccess.method_8320(posSide = blockPos.method_10074().method_10093(facing))).method_11614() == class_2246.field_10520) {
                return modelCubePodzol.method_4707(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterPodzolSnow) {
                return modelCubeSnow.method_4707(blockState, facing, RANDOM);
            }
        } else if (betterPodzol) {
            return modelCubePodzol.method_4707(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsDirt(class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, class_2350 facing, List quads) {
        class_2248 blockTop = BetterGrass.getBlockAt(blockPos, class_2350.field_11036, blockAccess);
        if (blockTop == class_2246.field_10194 && betterGrassPath && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == class_2246.field_10194) {
            return modelCubeGrassPath.method_4707(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrass(class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, class_2350 facing, List quads) {
        boolean snowy;
        class_2248 blockUp = blockAccess.method_8320(blockPos.method_10084()).method_11614();
        boolean bl = snowy = blockUp == class_2246.field_10491 || blockUp == class_2246.field_10477;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterGrassSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == class_2246.field_10477) {
                    return modelCubeSnow.method_4707(blockState, facing, RANDOM);
                }
            } else if (betterGrass && BetterGrass.getBlockAt(blockPos.method_10074(), facing, blockAccess) == class_2246.field_10219) {
                return modelCubeGrass.method_4707(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterGrassSnow) {
                return modelCubeSnow.method_4707(blockState, facing, RANDOM);
            }
        } else if (betterGrass) {
            return modelCubeGrass.method_4707(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static class_2248 getBlockAt(class_2338 blockPos, class_2350 facing, class_1920 blockAccess) {
        class_2338 pos = blockPos.method_10093(facing);
        class_2248 block = blockAccess.method_8320(pos).method_11614();
        return block;
    }

    private static boolean getBoolean(Properties props, String key, boolean def) {
        String str = props.getProperty(key);
        if (str == null) {
            return def;
        }
        return Boolean.parseBoolean(str);
    }
}

