/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1767;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2310;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2368;
import net.minecraft.class_2389;
import net.minecraft.class_2465;
import net.minecraft.class_2504;
import net.minecraft.class_2506;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_777;
import net.optifine.BetterGrass;
import net.optifine.BlockDir;
import net.optifine.ConnectedProperties;
import net.optifine.ConnectedTexturesCompact;
import net.optifine.config.Matches;
import net.optifine.model.BlockModelUtils;
import net.optifine.model.ListQuadsOverlay;
import net.optifine.reflect.Reflector;
import net.optifine.render.RenderEnv;
import net.optifine.util.BlockUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TileEntityUtils;

public class ConnectedTextures {
    private static Map[] spriteQuadMaps = null;
    private static Map[] spriteQuadFullMaps = null;
    private static Map[][] spriteQuadCompactMaps = null;
    private static ConnectedProperties[][] blockProperties = null;
    private static ConnectedProperties[][] tileProperties = null;
    private static boolean multipass = false;
    protected static final int UNKNOWN = -1;
    protected static final int Y_NEG_DOWN = 0;
    protected static final int Y_POS_UP = 1;
    protected static final int Z_NEG_NORTH = 2;
    protected static final int Z_POS_SOUTH = 3;
    protected static final int X_NEG_WEST = 4;
    protected static final int X_POS_EAST = 5;
    private static final int Y_AXIS = 0;
    private static final int Z_AXIS = 1;
    private static final int X_AXIS = 2;
    public static final class_2680 AIR_DEFAULT_STATE = class_2246.field_10124.method_9564();
    private static class_1058 emptySprite = null;
    private static final BlockDir[] SIDES_Y_NEG_DOWN = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.NORTH, BlockDir.SOUTH};
    private static final BlockDir[] SIDES_Y_POS_UP = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.SOUTH, BlockDir.NORTH};
    private static final BlockDir[] SIDES_Z_NEG_NORTH = new BlockDir[]{BlockDir.EAST, BlockDir.WEST, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_Z_POS_SOUTH = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_X_NEG_WEST = new BlockDir[]{BlockDir.NORTH, BlockDir.SOUTH, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_X_POS_EAST = new BlockDir[]{BlockDir.SOUTH, BlockDir.NORTH, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_Z_NEG_NORTH_Z_AXIS = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.UP, BlockDir.DOWN};
    private static final BlockDir[] SIDES_X_POS_EAST_X_AXIS = new BlockDir[]{BlockDir.NORTH, BlockDir.SOUTH, BlockDir.UP, BlockDir.DOWN};
    private static final BlockDir[] EDGES_Y_NEG_DOWN = new BlockDir[]{BlockDir.NORTH_EAST, BlockDir.NORTH_WEST, BlockDir.SOUTH_EAST, BlockDir.SOUTH_WEST};
    private static final BlockDir[] EDGES_Y_POS_UP = new BlockDir[]{BlockDir.SOUTH_EAST, BlockDir.SOUTH_WEST, BlockDir.NORTH_EAST, BlockDir.NORTH_WEST};
    private static final BlockDir[] EDGES_Z_NEG_NORTH = new BlockDir[]{BlockDir.DOWN_WEST, BlockDir.DOWN_EAST, BlockDir.UP_WEST, BlockDir.UP_EAST};
    private static final BlockDir[] EDGES_Z_POS_SOUTH = new BlockDir[]{BlockDir.DOWN_EAST, BlockDir.DOWN_WEST, BlockDir.UP_EAST, BlockDir.UP_WEST};
    private static final BlockDir[] EDGES_X_NEG_WEST = new BlockDir[]{BlockDir.DOWN_SOUTH, BlockDir.DOWN_NORTH, BlockDir.UP_SOUTH, BlockDir.UP_NORTH};
    private static final BlockDir[] EDGES_X_POS_EAST = new BlockDir[]{BlockDir.DOWN_NORTH, BlockDir.DOWN_SOUTH, BlockDir.UP_NORTH, BlockDir.UP_SOUTH};
    private static final BlockDir[] EDGES_Z_NEG_NORTH_Z_AXIS = new BlockDir[]{BlockDir.UP_EAST, BlockDir.UP_WEST, BlockDir.DOWN_EAST, BlockDir.DOWN_WEST};
    private static final BlockDir[] EDGES_X_POS_EAST_X_AXIS = new BlockDir[]{BlockDir.UP_SOUTH, BlockDir.UP_NORTH, BlockDir.DOWN_SOUTH, BlockDir.DOWN_NORTH};
    public static final class_1058 SPRITE_DEFAULT = new class_1058(new class_2960("default"), 0, 0);
    private static final Random RANDOM = new Random(0L);

    public static class_777[] getConnectedTexture(class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, class_777 quad, RenderEnv renderEnv) {
        class_1058 spriteIn = quad.method_3356();
        if (spriteIn == null) {
            return renderEnv.getArrayQuadsCtm(quad);
        }
        class_2248 block = blockState.method_11614();
        if (ConnectedTextures.skipConnectedTexture(blockAccess, blockState, blockPos, quad, renderEnv)) {
            quad = ConnectedTextures.getQuad(emptySprite, quad);
            return renderEnv.getArrayQuadsCtm(quad);
        }
        class_2350 side = quad.method_3358();
        class_777[] quads = ConnectedTextures.getConnectedTextureMultiPass(blockAccess, blockState, blockPos, side, quad, renderEnv);
        return quads;
    }

    private static boolean skipConnectedTexture(class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, class_777 quad, RenderEnv renderEnv) {
        class_2248 block = blockState.method_11614();
        if (block instanceof class_2389) {
            class_1767 colorNeighbour;
            class_1767 color;
            class_2350 face = quad.method_3358();
            if (face != class_2350.field_11036 && face != class_2350.field_11033) {
                return false;
            }
            if (!quad.isFaceQuad()) {
                return false;
            }
            class_2338 posNeighbour = blockPos.method_10093(quad.method_3358());
            class_2680 stateNeighbour = blockAccess.method_8320(posNeighbour);
            if (stateNeighbour.method_11614() != block) {
                return false;
            }
            class_2248 blockNeighbour = stateNeighbour.method_11614();
            if (block instanceof class_2504 && blockNeighbour instanceof class_2504 && (color = ((class_2504)block).method_10622()) != (colorNeighbour = ((class_2504)blockNeighbour).method_10622())) {
                return false;
            }
            double midX = quad.getMidX();
            if (midX < 0.4) {
                if (((Boolean)stateNeighbour.method_11654((class_2769)class_2310.field_10903)).booleanValue()) {
                    return true;
                }
            } else if (midX > 0.6) {
                if (((Boolean)stateNeighbour.method_11654((class_2769)class_2310.field_10907)).booleanValue()) {
                    return true;
                }
            } else {
                double midZ = quad.getMidZ();
                if (midZ < 0.4) {
                    if (((Boolean)stateNeighbour.method_11654((class_2769)class_2310.field_10905)).booleanValue()) {
                        return true;
                    }
                } else if (midZ > 0.6) {
                    if (((Boolean)stateNeighbour.method_11654((class_2769)class_2310.field_10904)).booleanValue()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    protected static class_777[] getQuads(class_1058 sprite, class_777 quadIn, RenderEnv renderEnv) {
        if (sprite == null) {
            return null;
        }
        if (sprite == SPRITE_DEFAULT) {
            return renderEnv.getArrayQuadsCtm(quadIn);
        }
        class_777 quad = ConnectedTextures.getQuad(sprite, quadIn);
        class_777[] quads = renderEnv.getArrayQuadsCtm(quad);
        return quads;
    }

    private static synchronized class_777 getQuad(class_1058 sprite, class_777 quadIn) {
        class_777 quad;
        if (spriteQuadMaps == null) {
            return quadIn;
        }
        int spriteIndex = sprite.getIndexInMap();
        if (spriteIndex < 0 || spriteIndex >= spriteQuadMaps.length) {
            return quadIn;
        }
        IdentityHashMap<class_777, class_777> quadMap = spriteQuadMaps[spriteIndex];
        if (quadMap == null) {
            ConnectedTextures.spriteQuadMaps[spriteIndex] = quadMap = new IdentityHashMap<class_777, class_777>(1);
        }
        if ((quad = (class_777)quadMap.get(quadIn)) == null) {
            quad = ConnectedTextures.makeSpriteQuad(quadIn, sprite);
            quadMap.put(quadIn, quad);
        }
        return quad;
    }

    private static synchronized class_777 getQuadFull(class_1058 sprite, class_777 quadIn, int tintIndex) {
        class_2350 face;
        class_777 quad;
        if (spriteQuadFullMaps == null) {
            return null;
        }
        if (sprite == null) {
            return null;
        }
        int spriteIndex = sprite.getIndexInMap();
        if (spriteIndex < 0 || spriteIndex >= spriteQuadFullMaps.length) {
            return null;
        }
        EnumMap<class_2350, class_777> quadMap = spriteQuadFullMaps[spriteIndex];
        if (quadMap == null) {
            ConnectedTextures.spriteQuadFullMaps[spriteIndex] = quadMap = new EnumMap<class_2350, class_777>(class_2350.class);
        }
        if ((quad = (class_777)quadMap.get(face = quadIn.method_3358())) == null) {
            quad = BlockModelUtils.makeBakedQuad(face, sprite, tintIndex);
            quadMap.put(face, quad);
        }
        return quad;
    }

    private static class_777 makeSpriteQuad(class_777 quad, class_1058 sprite) {
        int[] data = (int[])quad.method_3357().clone();
        class_1058 spriteFrom = quad.method_3356();
        for (int i = 0; i < 4; ++i) {
            ConnectedTextures.fixVertex(data, i, spriteFrom, sprite);
        }
        class_777 bq = new class_777(data, quad.method_3359(), quad.method_3358(), sprite);
        return bq;
    }

    private static void fixVertex(int[] data, int vertex, class_1058 spriteFrom, class_1058 spriteTo) {
        int mul = data.length / 4;
        int pos = mul * vertex;
        float u = Float.intBitsToFloat(data[pos + 4]);
        float v = Float.intBitsToFloat(data[pos + 4 + 1]);
        double su16 = spriteFrom.getSpriteU16(u);
        double sv16 = spriteFrom.getSpriteV16(v);
        data[pos + 4] = Float.floatToRawIntBits(spriteTo.method_4580(su16));
        data[pos + 4 + 1] = Float.floatToRawIntBits(spriteTo.method_4570(sv16));
    }

    private static class_777[] getConnectedTextureMultiPass(class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, class_2350 side, class_777 quad, RenderEnv renderEnv) {
        class_777[] quads = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, quad, true, 0, renderEnv);
        if (!multipass) {
            return quads;
        }
        if (quads.length == 1 && quads[0] == quad) {
            return quads;
        }
        List<class_777> listQuads = renderEnv.getListQuadsCtmMultipass(quads);
        for (int q = 0; q < listQuads.size(); ++q) {
            class_777[] newMpQuads;
            class_777 newQuad;
            class_777 mpQuad = newQuad = listQuads.get(q);
            for (int i = 0; i < 3 && (newMpQuads = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, mpQuad, false, i + 1, renderEnv)).length == 1 && newMpQuads[0] != mpQuad; ++i) {
                mpQuad = newMpQuads[0];
            }
            listQuads.set(q, mpQuad);
        }
        for (int i = 0; i < quads.length; ++i) {
            quads[i] = listQuads.get(i);
        }
        return quads;
    }

    public static class_777[] getConnectedTextureSingle(class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, class_2350 facing, class_777 quad, boolean checkBlocks, int pass, RenderEnv renderEnv) {
        int blockId;
        class_777[] newQuads;
        ConnectedProperties cp;
        int i;
        int side;
        ConnectedProperties[] cps;
        int iconId;
        class_2248 block = blockState.method_11614();
        class_1058 icon = quad.method_3356();
        if (tileProperties != null && (iconId = icon.getIndexInMap()) >= 0 && iconId < tileProperties.length && (cps = tileProperties[iconId]) != null) {
            side = ConnectedTextures.getSide(facing);
            for (i = 0; i < cps.length; ++i) {
                cp = cps[i];
                if (cp == null || !cp.matchesBlockId(blockState.getBlockId()) || (newQuads = ConnectedTextures.getConnectedTexture(cp, blockAccess, blockState, blockPos, side, quad, pass, renderEnv)) == null) continue;
                return newQuads;
            }
        }
        if (blockProperties != null && checkBlocks && (blockId = renderEnv.getBlockId()) >= 0 && blockId < blockProperties.length && (cps = blockProperties[blockId]) != null) {
            side = ConnectedTextures.getSide(facing);
            for (i = 0; i < cps.length; ++i) {
                cp = cps[i];
                if (cp == null || !cp.matchesIcon(icon) || (newQuads = ConnectedTextures.getConnectedTexture(cp, blockAccess, blockState, blockPos, side, quad, pass, renderEnv)) == null) continue;
                return newQuads;
            }
        }
        return renderEnv.getArrayQuadsCtm(quad);
    }

    public static int getSide(class_2350 facing) {
        if (facing == null) {
            return -1;
        }
        switch (facing) {
            case field_11033: {
                return 0;
            }
            case field_11036: {
                return 1;
            }
            case field_11034: {
                return 5;
            }
            case field_11039: {
                return 4;
            }
            case field_11043: {
                return 2;
            }
            case field_11035: {
                return 3;
            }
        }
        return -1;
    }

    private static class_2350 getFacing(int side) {
        switch (side) {
            case 0: {
                return class_2350.field_11033;
            }
            case 1: {
                return class_2350.field_11036;
            }
            case 5: {
                return class_2350.field_11034;
            }
            case 4: {
                return class_2350.field_11039;
            }
            case 2: {
                return class_2350.field_11043;
            }
            case 3: {
                return class_2350.field_11035;
            }
        }
        return class_2350.field_11036;
    }

    private static class_777[] getConnectedTexture(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int side, class_777 quad, int pass, RenderEnv renderEnv) {
        String name;
        class_1959 blockBiome;
        int vertAxis = 0;
        int metadata = blockState.getMetadata();
        class_2248 block = blockState.method_11614();
        if (block instanceof class_2465) {
            vertAxis = ConnectedTextures.getPillarAxis(blockState);
        }
        if (!cp.matchesBlock(blockState.getBlockId(), metadata)) {
            return null;
        }
        if (side >= 0 && cp.faces != 63) {
            int sideCheck = side;
            if (vertAxis != 0) {
                sideCheck = ConnectedTextures.fixSideByAxis(side, vertAxis);
            }
            if ((1 << sideCheck & cp.faces) == 0) {
                return null;
            }
        }
        int y = blockPos.method_10264();
        if (cp.heights != null && !cp.heights.isInRange(y)) {
            return null;
        }
        if (cp.biomes != null && !cp.matchesBiome(blockBiome = blockAccess.method_8310(blockPos))) {
            return null;
        }
        if (cp.nbtName != null && !cp.nbtName.matchesValue(name = TileEntityUtils.getTileEntityName(blockAccess, blockPos))) {
            return null;
        }
        class_1058 icon = quad.method_3356();
        switch (cp.method) {
            case 10: {
                if (pass != 0) break;
                return ConnectedTextures.getConnectedTextureCtmCompact(cp, blockAccess, blockState, blockPos, vertAxis, side, quad, metadata, renderEnv);
            }
            case 1: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureCtm(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata, renderEnv), quad, renderEnv);
            }
            case 2: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 6: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 3: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureTop(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 4: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureRandom(cp, blockAccess, blockState, blockPos, side), quad, renderEnv);
            }
            case 5: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureRepeat(cp, blockPos, side), quad, renderEnv);
            }
            case 7: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureFixed(cp), quad, renderEnv);
            }
            case 8: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureHorizontalVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 9: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureVerticalHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 11: {
                return ConnectedTextures.getConnectedTextureOverlay(cp, blockAccess, blockState, blockPos, vertAxis, side, quad, metadata, renderEnv);
            }
            case 12: {
                return ConnectedTextures.getConnectedTextureOverlayFixed(cp, quad, renderEnv);
            }
            case 13: {
                return ConnectedTextures.getConnectedTextureOverlayRandom(cp, blockAccess, blockState, blockPos, side, quad, renderEnv);
            }
            case 14: {
                return ConnectedTextures.getConnectedTextureOverlayRepeat(cp, blockPos, side, quad, renderEnv);
            }
            case 15: {
                return ConnectedTextures.getConnectedTextureOverlayCtm(cp, blockAccess, blockState, blockPos, vertAxis, side, quad, metadata, renderEnv);
            }
        }
        return null;
    }

    private static int fixSideByAxis(int side, int vertAxis) {
        switch (vertAxis) {
            case 0: {
                return side;
            }
            case 1: {
                switch (side) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return side;
            }
            case 2: {
                switch (side) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 5;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 0;
                    }
                }
                return side;
            }
        }
        return side;
    }

    private static int getPillarAxis(class_2680 blockState) {
        class_2350.class_2351 axis = (class_2350.class_2351)blockState.method_11654((class_2769)class_2465.field_11459);
        switch (axis) {
            case field_11048: {
                return 2;
            }
            case field_11051: {
                return 1;
            }
        }
        return 0;
    }

    private static class_1058 getConnectedTextureRandom(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int side) {
        if (cp.tileIcons.length == 1) {
            return cp.tileIcons[0];
        }
        int face = side / cp.symmetry * cp.symmetry;
        if (cp.linked) {
            class_2338 posDown = blockPos.method_10074();
            class_2680 bsDown = blockAccess.method_8320(posDown);
            while (bsDown.method_11614() == blockState.method_11614() && (posDown = (blockPos = posDown).method_10074()).method_10264() >= 0) {
                bsDown = blockAccess.method_8320(posDown);
            }
        }
        int rand = Config.getRandom(blockPos, face) & Integer.MAX_VALUE;
        for (int i = 0; i < cp.randomLoops; ++i) {
            rand = Config.intHash(rand);
        }
        int index = 0;
        if (cp.weights == null) {
            index = rand % cp.tileIcons.length;
        } else {
            int randWeight = rand % cp.sumAllWeights;
            int[] sumWeights = cp.sumWeights;
            for (int i = 0; i < sumWeights.length; ++i) {
                if (randWeight >= sumWeights[i]) continue;
                index = i;
                break;
            }
        }
        return cp.tileIcons[index];
    }

    private static class_1058 getConnectedTextureFixed(ConnectedProperties cp) {
        return cp.tileIcons[0];
    }

    private static class_1058 getConnectedTextureRepeat(ConnectedProperties cp, class_2338 blockPos, int side) {
        if (cp.tileIcons.length == 1) {
            return cp.tileIcons[0];
        }
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();
        int nx = 0;
        int ny = 0;
        switch (side) {
            case 0: {
                nx = x;
                ny = -z - 1;
                break;
            }
            case 1: {
                nx = x;
                ny = z;
                break;
            }
            case 2: {
                nx = -x - 1;
                ny = -y;
                break;
            }
            case 3: {
                nx = x;
                ny = -y;
                break;
            }
            case 4: {
                nx = z;
                ny = -y;
                break;
            }
            case 5: {
                nx = -z - 1;
                ny = -y;
            }
        }
        ny %= cp.height;
        if ((nx %= cp.width) < 0) {
            nx += cp.width;
        }
        if (ny < 0) {
            ny += cp.height;
        }
        int index = ny * cp.width + nx;
        return cp.tileIcons[index];
    }

    private static class_1058 getConnectedTextureCtm(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int vertAxis, int side, class_1058 icon, int metadata, RenderEnv renderEnv) {
        int index = ConnectedTextures.getConnectedTextureCtmIndex(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata, renderEnv);
        return cp.tileIcons[index];
    }

    private static synchronized class_777[] getConnectedTextureCtmCompact(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int vertAxis, int side, class_777 quad, int metadata, RenderEnv renderEnv) {
        class_1058 icon = quad.method_3356();
        int index = ConnectedTextures.getConnectedTextureCtmIndex(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata, renderEnv);
        return ConnectedTexturesCompact.getConnectedTextureCtmCompact(index, cp, side, quad, renderEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static class_777[] getConnectedTextureOverlay(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int vertAxis, int side, class_777 quad, int metadata, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        class_1058 icon = quad.method_3356();
        BlockDir[] dirSides = ConnectedTextures.getSideDirections(side, vertAxis);
        boolean[] sides = renderEnv.getBorderFlags();
        for (int i = 0; i < 4; ++i) {
            sides[i] = ConnectedTextures.isNeighbourOverlay(cp, blockAccess, blockState, dirSides[i].offset(blockPos), side, icon, metadata);
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            if (sides[0] && sides[1] && sides[2] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[8], quad, cp.tintIndex), cp.tintBlockState);
                class_777[] class_777Array = null;
                return class_777Array;
            }
            if (sides[0] && sides[1] && sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[5], quad, cp.tintIndex), cp.tintBlockState);
                class_777[] class_777Array = null;
                return class_777Array;
            }
            if (sides[0] && sides[2] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[6], quad, cp.tintIndex), cp.tintBlockState);
                class_777[] class_777Array = null;
                return class_777Array;
            }
            if (sides[1] && sides[2] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[12], quad, cp.tintIndex), cp.tintBlockState);
                class_777[] class_777Array = null;
                return class_777Array;
            }
            if (sides[0] && sides[1] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[13], quad, cp.tintIndex), cp.tintBlockState);
                class_777[] class_777Array = null;
                return class_777Array;
            }
            BlockDir[] dirEdges = ConnectedTextures.getEdgeDirections(side, vertAxis);
            boolean[] edges = renderEnv.getBorderFlags2();
            for (int i = 0; i < 4; ++i) {
                edges[i] = ConnectedTextures.isNeighbourOverlay(cp, blockAccess, blockState, dirEdges[i].offset(blockPos), side, icon, metadata);
            }
            if (sides[1] && sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[3], quad, cp.tintIndex), cp.tintBlockState);
                if (edges[3]) {
                    listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[16], quad, cp.tintIndex), cp.tintBlockState);
                }
                class_777[] i = null;
                return i;
            }
            if (sides[0] && sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[4], quad, cp.tintIndex), cp.tintBlockState);
                if (edges[2]) {
                    listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[14], quad, cp.tintIndex), cp.tintBlockState);
                }
                class_777[] i = null;
                return i;
            }
            if (sides[1] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[10], quad, cp.tintIndex), cp.tintBlockState);
                if (edges[1]) {
                    listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[2], quad, cp.tintIndex), cp.tintBlockState);
                }
                class_777[] i = null;
                return i;
            }
            if (sides[0] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[11], quad, cp.tintIndex), cp.tintBlockState);
                if (edges[0]) {
                    listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[0], quad, cp.tintIndex), cp.tintBlockState);
                }
                class_777[] i = null;
                return i;
            }
            boolean[] sidesMatch = renderEnv.getBorderFlags3();
            for (int i = 0; i < 4; ++i) {
                sidesMatch[i] = ConnectedTextures.isNeighbourMatching(cp, blockAccess, blockState, dirSides[i].offset(blockPos), side, icon, metadata);
            }
            if (sides[0]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[9], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (sides[1]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[7], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[1], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[15], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (edges[0] && (sidesMatch[1] || sidesMatch[2]) && !sides[1] && !sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[0], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (edges[1] && (sidesMatch[0] || sidesMatch[2]) && !sides[0] && !sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[2], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (edges[2] && (sidesMatch[1] || sidesMatch[3]) && !sides[1] && !sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[14], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (edges[3] && (sidesMatch[0] || sidesMatch[3]) && !sides[0] && !sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[16], quad, cp.tintIndex), cp.tintBlockState);
            }
            class_777[] class_777Array = null;
            return class_777Array;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static class_777[] getConnectedTextureOverlayFixed(ConnectedProperties cp, class_777 quad, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            class_1058 sprite = ConnectedTextures.getConnectedTextureFixed(cp);
            if (sprite != null) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(sprite, quad, cp.tintIndex), cp.tintBlockState);
            }
            class_777[] class_777Array = null;
            return class_777Array;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static class_777[] getConnectedTextureOverlayRandom(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int side, class_777 quad, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            class_1058 sprite = ConnectedTextures.getConnectedTextureRandom(cp, blockAccess, blockState, blockPos, side);
            if (sprite != null) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(sprite, quad, cp.tintIndex), cp.tintBlockState);
            }
            class_777[] class_777Array = null;
            return class_777Array;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static class_777[] getConnectedTextureOverlayRepeat(ConnectedProperties cp, class_2338 blockPos, int side, class_777 quad, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            class_1058 sprite = ConnectedTextures.getConnectedTextureRepeat(cp, blockPos, side);
            if (sprite != null) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(sprite, quad, cp.tintIndex), cp.tintBlockState);
            }
            class_777[] class_777Array = null;
            return class_777Array;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static class_777[] getConnectedTextureOverlayCtm(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int vertAxis, int side, class_777 quad, int metadata, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            class_1058 sprite = ConnectedTextures.getConnectedTextureCtm(cp, blockAccess, blockState, blockPos, vertAxis, side, quad.method_3356(), metadata, renderEnv);
            if (sprite != null) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(sprite, quad, cp.tintIndex), cp.tintBlockState);
            }
            class_777[] class_777Array = null;
            return class_777Array;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    private static BlockDir[] getSideDirections(int side, int vertAxis) {
        switch (side) {
            case 0: {
                return SIDES_Y_NEG_DOWN;
            }
            case 1: {
                return SIDES_Y_POS_UP;
            }
            case 2: {
                if (vertAxis == 1) {
                    return SIDES_Z_NEG_NORTH_Z_AXIS;
                }
                return SIDES_Z_NEG_NORTH;
            }
            case 3: {
                return SIDES_Z_POS_SOUTH;
            }
            case 4: {
                return SIDES_X_NEG_WEST;
            }
            case 5: {
                if (vertAxis == 2) {
                    return SIDES_X_POS_EAST_X_AXIS;
                }
                return SIDES_X_POS_EAST;
            }
        }
        throw new IllegalArgumentException("Unknown side: " + side);
    }

    private static BlockDir[] getEdgeDirections(int side, int vertAxis) {
        switch (side) {
            case 0: {
                return EDGES_Y_NEG_DOWN;
            }
            case 1: {
                return EDGES_Y_POS_UP;
            }
            case 2: {
                if (vertAxis == 1) {
                    return EDGES_Z_NEG_NORTH_Z_AXIS;
                }
                return EDGES_Z_NEG_NORTH;
            }
            case 3: {
                return EDGES_Z_POS_SOUTH;
            }
            case 4: {
                return EDGES_X_NEG_WEST;
            }
            case 5: {
                if (vertAxis == 2) {
                    return EDGES_X_POS_EAST_X_AXIS;
                }
                return EDGES_X_POS_EAST;
            }
        }
        throw new IllegalArgumentException("Unknown side: " + side);
    }

    protected static Map[][] getSpriteQuadCompactMaps() {
        return spriteQuadCompactMaps;
    }

    private static int getConnectedTextureCtmIndex(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int vertAxis, int side, class_1058 icon, int metadata, RenderEnv renderEnv) {
        boolean[] borders = renderEnv.getBorderFlags();
        switch (side) {
            case 0: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                if (!cp.innerSeams) break;
                class_2338 posFront = blockPos.method_10074();
                borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10067(), side, icon, metadata);
                borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10078(), side, icon, metadata);
                borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10095(), side, icon, metadata);
                borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10072(), side, icon, metadata);
                break;
            }
            case 1: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                if (!cp.innerSeams) break;
                class_2338 posFront = blockPos.method_10084();
                borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10067(), side, icon, metadata);
                borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10078(), side, icon, metadata);
                borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10072(), side, icon, metadata);
                borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10095(), side, icon, metadata);
                break;
            }
            case 2: {
                class_2338 posFront;
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                if (cp.innerSeams) {
                    posFront = blockPos.method_10095();
                    borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10078(), side, icon, metadata);
                    borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10067(), side, icon, metadata);
                    borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10074(), side, icon, metadata);
                    boolean bl = borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10084(), side, icon, metadata);
                }
                if (vertAxis != 1) break;
                ConnectedTextures.switchValues(0, 1, borders);
                ConnectedTextures.switchValues(2, 3, borders);
                break;
            }
            case 3: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                if (!cp.innerSeams) break;
                class_2338 posFront = blockPos.method_10072();
                borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10067(), side, icon, metadata);
                borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10078(), side, icon, metadata);
                borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10074(), side, icon, metadata);
                borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10084(), side, icon, metadata);
                break;
            }
            case 4: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                if (!cp.innerSeams) break;
                class_2338 posFront = blockPos.method_10067();
                borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10095(), side, icon, metadata);
                borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10072(), side, icon, metadata);
                borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10074(), side, icon, metadata);
                borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10084(), side, icon, metadata);
                break;
            }
            case 5: {
                class_2338 posFront;
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                if (cp.innerSeams) {
                    posFront = blockPos.method_10078();
                    borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10072(), side, icon, metadata);
                    borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10095(), side, icon, metadata);
                    borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10074(), side, icon, metadata);
                    boolean bl = borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.method_10084(), side, icon, metadata);
                }
                if (vertAxis != 2) break;
                ConnectedTextures.switchValues(0, 1, borders);
                ConnectedTextures.switchValues(2, 3, borders);
            }
        }
        int index = 0;
        if (borders[0] & !borders[1] & !borders[2] & !borders[3]) {
            index = 3;
        } else if (!borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 1;
        } else if (!borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 12;
        } else if (!borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 36;
        } else if (borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 2;
        } else if (!borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 24;
        } else if (borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 15;
        } else if (borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 39;
        } else if (!borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 13;
        } else if (!borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 37;
        } else if (!borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 25;
        } else if (borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 27;
        } else if (borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 38;
        } else if (borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 14;
        } else if (borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 26;
        }
        if (index == 0) {
            return index;
        }
        if (!Config.isConnectedTexturesFancy()) {
            return index;
        }
        boolean[] edges = borders;
        switch (side) {
            case 0: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078().method_10095(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067().method_10095(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078().method_10072(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067().method_10072(), side, icon, metadata);
                break;
            }
            case 1: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078().method_10072(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067().method_10072(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078().method_10095(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067().method_10095(), side, icon, metadata);
                break;
            }
            case 2: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067().method_10074(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078().method_10074(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067().method_10084(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078().method_10084(), side, icon, metadata);
                if (vertAxis != 1) break;
                ConnectedTextures.switchValues(0, 3, borders);
                ConnectedTextures.switchValues(1, 2, borders);
                break;
            }
            case 3: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078().method_10074(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067().method_10074(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078().method_10084(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067().method_10084(), side, icon, metadata);
                break;
            }
            case 4: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074().method_10072(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074().method_10095(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084().method_10072(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084().method_10095(), side, icon, metadata);
                break;
            }
            case 5: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074().method_10095(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074().method_10072(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084().method_10095(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084().method_10072(), side, icon, metadata);
                if (vertAxis != 2) break;
                ConnectedTextures.switchValues(0, 3, borders);
                ConnectedTextures.switchValues(1, 2, borders);
            }
        }
        if (index == 13 && edges[0]) {
            index = 4;
        } else if (index == 15 && edges[1]) {
            index = 5;
        } else if (index == 37 && edges[2]) {
            index = 16;
        } else if (index == 39 && edges[3]) {
            index = 17;
        } else if (index == 14 && edges[0] && edges[1]) {
            index = 7;
        } else if (index == 25 && edges[0] && edges[2]) {
            index = 6;
        } else if (index == 27 && edges[3] && edges[1]) {
            index = 19;
        } else if (index == 38 && edges[3] && edges[2]) {
            index = 18;
        } else if (index == 14 && !edges[0] && edges[1]) {
            index = 31;
        } else if (index == 25 && edges[0] && !edges[2]) {
            index = 30;
        } else if (index == 27 && !edges[3] && edges[1]) {
            index = 41;
        } else if (index == 38 && edges[3] && !edges[2]) {
            index = 40;
        } else if (index == 14 && edges[0] && !edges[1]) {
            index = 29;
        } else if (index == 25 && !edges[0] && edges[2]) {
            index = 28;
        } else if (index == 27 && edges[3] && !edges[1]) {
            index = 43;
        } else if (index == 38 && !edges[3] && edges[2]) {
            index = 42;
        } else if (index == 26 && edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 46;
        } else if (index == 26 && !edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 9;
        } else if (index == 26 && edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 21;
        } else if (index == 26 && edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 8;
        } else if (index == 26 && edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 20;
        } else if (index == 26 && edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 11;
        } else if (index == 26 && !edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 22;
        } else if (index == 26 && !edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 23;
        } else if (index == 26 && edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 10;
        } else if (index == 26 && edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 34;
        } else if (index == 26 && !edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 35;
        } else if (index == 26 && edges[0] && !edges[1] && !edges[2] && !edges[3]) {
            index = 32;
        } else if (index == 26 && !edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 33;
        } else if (index == 26 && !edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 44;
        } else if (index == 26 && !edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 45;
        }
        return index;
    }

    private static void switchValues(int ix1, int ix2, boolean[] arr) {
        boolean prev1 = arr[ix1];
        arr[ix1] = arr[ix2];
        arr[ix2] = prev1;
    }

    private static boolean isNeighbourOverlay(ConnectedProperties cp, class_1920 worldReader, class_2680 blockState, class_2338 blockPos, int side, class_1058 icon, int metadata) {
        class_1058 neighbourIcon;
        class_2680 neighbourState = worldReader.method_8320(blockPos);
        if (!ConnectedTextures.isFullCubeModel(neighbourState, (class_1922)worldReader, blockPos)) {
            return false;
        }
        if (cp.connectBlocks != null && !Matches.block(neighbourState.getBlockId(), neighbourState.getMetadata(), cp.connectBlocks)) {
            return false;
        }
        if (cp.connectTileIcons != null && !Config.isSameOne(neighbourIcon = ConnectedTextures.getNeighbourIcon(worldReader, blockState, blockPos, neighbourState, side), cp.connectTileIcons)) {
            return false;
        }
        class_2338 posNeighbourStateAbove = blockPos.method_10093(ConnectedTextures.getFacing(side));
        class_2680 neighbourStateAbove = worldReader.method_8320(posNeighbourStateAbove);
        if (neighbourStateAbove.method_11598((class_1922)worldReader, posNeighbourStateAbove)) {
            return false;
        }
        if (side == 1 && neighbourStateAbove.method_11614() == class_2246.field_10477) {
            return false;
        }
        return !ConnectedTextures.isNeighbour(cp, worldReader, blockState, blockPos, neighbourState, side, icon, metadata);
    }

    private static boolean isFullCubeModel(class_2680 state, class_1922 blockReader, class_2338 pos) {
        if (BlockUtils.isFullCube(state, blockReader, pos)) {
            return true;
        }
        class_2248 block = state.method_11614();
        if (block instanceof class_2368) {
            return true;
        }
        return block instanceof class_2506;
    }

    private static boolean isNeighbourMatching(ConnectedProperties cp, class_1920 worldReader, class_2680 blockState, class_2338 blockPos, int side, class_1058 icon, int metadata) {
        class_1058 neighbourIcon;
        class_2680 neighbourState = worldReader.method_8320(blockPos);
        if (neighbourState == AIR_DEFAULT_STATE) {
            return false;
        }
        if (cp.matchBlocks != null && !cp.matchesBlock(neighbourState.getBlockId(), neighbourState.getMetadata())) {
            return false;
        }
        if (cp.matchTileIcons != null && (neighbourIcon = ConnectedTextures.getNeighbourIcon(worldReader, blockState, blockPos, neighbourState, side)) != icon) {
            return false;
        }
        class_2338 posNeighbourAbove = blockPos.method_10093(ConnectedTextures.getFacing(side));
        class_2680 neighbourStateAbove = worldReader.method_8320(posNeighbourAbove);
        if (neighbourStateAbove.method_11598((class_1922)worldReader, posNeighbourAbove)) {
            return false;
        }
        return side != 1 || neighbourStateAbove.method_11614() != class_2246.field_10477;
    }

    private static boolean isNeighbour(ConnectedProperties cp, class_1920 worldReader, class_2680 blockState, class_2338 blockPos, int side, class_1058 icon, int metadata) {
        class_2680 neighbourState = worldReader.method_8320(blockPos);
        return ConnectedTextures.isNeighbour(cp, worldReader, blockState, blockPos, neighbourState, side, icon, metadata);
    }

    private static boolean isNeighbour(ConnectedProperties cp, class_1920 worldReader, class_2680 blockState, class_2338 blockPos, class_2680 neighbourState, int side, class_1058 icon, int metadata) {
        if (blockState == neighbourState) {
            return true;
        }
        if (cp.connect == 2) {
            if (neighbourState == null) {
                return false;
            }
            if (neighbourState == AIR_DEFAULT_STATE) {
                return false;
            }
            class_1058 neighbourIcon = ConnectedTextures.getNeighbourIcon(worldReader, blockState, blockPos, neighbourState, side);
            return neighbourIcon == icon;
        }
        if (cp.connect == 3) {
            if (neighbourState == null) {
                return false;
            }
            if (neighbourState == AIR_DEFAULT_STATE) {
                return false;
            }
            return neighbourState.method_11620() == blockState.method_11620();
        }
        if (cp.connect == 1) {
            class_2248 block = blockState.method_11614();
            class_2248 neighbourBlock = neighbourState.method_11614();
            return neighbourBlock == block;
        }
        return false;
    }

    private static class_1058 getNeighbourIcon(class_1920 worldReader, class_2680 blockState, class_2338 blockPos, class_2680 neighbourState, int side) {
        class_2350 facing;
        List quads;
        class_1087 model = class_310.method_1551().method_1541().method_3351().method_3335(neighbourState);
        if (model == null) {
            return null;
        }
        if (Reflector.ForgeBlock_getExtendedState.exists()) {
            neighbourState = (class_2680)Reflector.call(neighbourState.method_11614(), Reflector.ForgeBlock_getExtendedState, neighbourState, worldReader, blockPos);
        }
        if ((quads = model.method_4707(neighbourState, facing = ConnectedTextures.getFacing(side), RANDOM)) == null) {
            return null;
        }
        if (Config.isBetterGrass()) {
            quads = BetterGrass.getFaceQuads(worldReader, neighbourState, blockPos, facing, quads);
        }
        if (quads.size() > 0) {
            class_777 quad = (class_777)quads.get(0);
            return quad.method_3356();
        }
        List quadsGeneral = model.method_4707(neighbourState, null, RANDOM);
        if (quadsGeneral == null) {
            return null;
        }
        for (int i = 0; i < quadsGeneral.size(); ++i) {
            class_777 quad = (class_777)quadsGeneral.get(i);
            if (quad.method_3358() != facing) continue;
            return quad.method_3356();
        }
        return null;
    }

    private static class_1058 getConnectedTextureHorizontal(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int vertAxis, int side, class_1058 icon, int metadata) {
        boolean left = false;
        boolean right = false;
        block0 : switch (vertAxis) {
            case 0: {
                switch (side) {
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
                        break;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
                        break;
                    }
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                        break;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                    }
                }
                break;
            }
            case 1: {
                switch (side) {
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
                        break;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
                        break;
                    }
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                        break;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                    }
                }
                break;
            }
            case 2: {
                switch (side) {
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                        break block0;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                        break block0;
                    }
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                        break block0;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                        break block0;
                    }
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                        break block0;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                    }
                }
            }
        }
        int index = 3;
        index = left ? (right ? 1 : 2) : (right ? 0 : 3);
        return cp.tileIcons[index];
    }

    private static class_1058 getConnectedTextureVertical(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int vertAxis, int side, class_1058 icon, int metadata) {
        boolean bottom = false;
        boolean top = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                    break;
                }
                if (side == 0) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                    break;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                    break;
                }
                if (side == 2) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                    break;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10095(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                    break;
                }
                if (side == 4) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10074(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                    break;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10067(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
            }
        }
        int index = 3;
        index = bottom ? (top ? 1 : 2) : (top ? 0 : 3);
        return cp.tileIcons[index];
    }

    private static class_1058 getConnectedTextureHorizontalVertical(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int vertAxis, int side, class_1058 icon, int metadata) {
        class_1058[] tileIcons = cp.tileIcons;
        class_1058 iconH = ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconH != null && iconH != icon && iconH != tileIcons[3]) {
            return iconH;
        }
        class_1058 iconV = ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconV == tileIcons[0]) {
            return tileIcons[4];
        }
        if (iconV == tileIcons[1]) {
            return tileIcons[5];
        }
        if (iconV == tileIcons[2]) {
            return tileIcons[6];
        }
        return iconV;
    }

    private static class_1058 getConnectedTextureVerticalHorizontal(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int vertAxis, int side, class_1058 icon, int metadata) {
        class_1058[] tileIcons = cp.tileIcons;
        class_1058 iconV = ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconV != null && iconV != icon && iconV != tileIcons[3]) {
            return iconV;
        }
        class_1058 iconH = ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconH == tileIcons[0]) {
            return tileIcons[4];
        }
        if (iconH == tileIcons[1]) {
            return tileIcons[5];
        }
        if (iconH == tileIcons[2]) {
            return tileIcons[6];
        }
        return iconH;
    }

    private static class_1058 getConnectedTextureTop(ConnectedProperties cp, class_1920 blockAccess, class_2680 blockState, class_2338 blockPos, int vertAxis, int side, class_1058 icon, int metadata) {
        boolean top = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1 || side == 0) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10084(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3 || side == 2) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10072(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5 || side == 4) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.method_10078(), side, icon, metadata);
            }
        }
        if (top) {
            return cp.tileIcons[0];
        }
        return null;
    }

    public static void updateIcons(class_1059 textureMap) {
        blockProperties = null;
        tileProperties = null;
        spriteQuadMaps = null;
        spriteQuadCompactMaps = null;
        if (!Config.isConnectedTextures()) {
            return;
        }
        class_3262[] rps = Config.getResourcePacks();
        for (int i = rps.length - 1; i >= 0; --i) {
            class_3262 rp = rps[i];
            ConnectedTextures.updateIcons(textureMap, rp);
        }
        ConnectedTextures.updateIcons(textureMap, (class_3262)Config.getDefaultResourcePack());
        class_2960 locEmpty = new class_2960("optifine/ctm/default/empty");
        emptySprite = textureMap.registerSprite(locEmpty);
        spriteQuadMaps = new Map[textureMap.getCountRegisteredSprites() + 1];
        spriteQuadFullMaps = new Map[textureMap.getCountRegisteredSprites() + 1];
        spriteQuadCompactMaps = new Map[textureMap.getCountRegisteredSprites() + 1][];
        if (blockProperties.length <= 0) {
            blockProperties = null;
        }
        if (tileProperties.length <= 0) {
            tileProperties = null;
        }
    }

    private static void updateIconEmpty(class_1059 textureMap) {
    }

    public static void updateIcons(class_1059 textureMap, class_3262 rp) {
        Object[] names = ResUtils.collectFiles(rp, "optifine/ctm/", ".properties", ConnectedTextures.getDefaultCtmPaths());
        Arrays.sort(names);
        List tileList = ConnectedTextures.makePropertyList(tileProperties);
        List blockList = ConnectedTextures.makePropertyList(blockProperties);
        for (int i = 0; i < names.length; ++i) {
            Object name = names[i];
            Config.dbg("ConnectedTextures: " + (String)name);
            try {
                class_2960 locFile = new class_2960((String)name);
                InputStream in = rp.method_14405(class_3264.field_14188, locFile);
                if (in == null) {
                    Config.warn("ConnectedTextures file not found: " + (String)name);
                    continue;
                }
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                ConnectedProperties cp = new ConnectedProperties(props, (String)name);
                if (!cp.isValid((String)name)) continue;
                cp.updateIcons(textureMap);
                ConnectedTextures.addToTileList(cp, tileList);
                ConnectedTextures.addToBlockList(cp, blockList);
                continue;
            }
            catch (FileNotFoundException e) {
                Config.warn("ConnectedTextures file not found: " + (String)name);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        blockProperties = ConnectedTextures.propertyListToArray(blockList);
        tileProperties = ConnectedTextures.propertyListToArray(tileList);
        multipass = ConnectedTextures.detectMultipass();
        Config.dbg("Multipass connected textures: " + multipass);
    }

    private static List makePropertyList(ConnectedProperties[][] propsArr) {
        ArrayList<ArrayList<ConnectedProperties>> list = new ArrayList<ArrayList<ConnectedProperties>>();
        if (propsArr != null) {
            for (int i = 0; i < propsArr.length; ++i) {
                ConnectedProperties[] props = propsArr[i];
                ArrayList<ConnectedProperties> propList = null;
                if (props != null) {
                    propList = new ArrayList<ConnectedProperties>(Arrays.asList(props));
                }
                list.add(propList);
            }
        }
        return list;
    }

    private static boolean detectMultipass() {
        ConnectedProperties[] cps;
        int i;
        ArrayList<ConnectedProperties> propList = new ArrayList<ConnectedProperties>();
        for (i = 0; i < tileProperties.length; ++i) {
            cps = tileProperties[i];
            if (cps == null) continue;
            propList.addAll(Arrays.asList(cps));
        }
        for (i = 0; i < blockProperties.length; ++i) {
            cps = blockProperties[i];
            if (cps == null) continue;
            propList.addAll(Arrays.asList(cps));
        }
        ConnectedProperties[] props = propList.toArray(new ConnectedProperties[propList.size()]);
        HashSet<class_1058> matchIconSet = new HashSet<class_1058>();
        HashSet<class_1058> tileIconSet = new HashSet<class_1058>();
        for (int i2 = 0; i2 < props.length; ++i2) {
            ConnectedProperties cp = props[i2];
            if (cp.matchTileIcons != null) {
                matchIconSet.addAll(Arrays.asList(cp.matchTileIcons));
            }
            if (cp.tileIcons == null) continue;
            tileIconSet.addAll(Arrays.asList(cp.tileIcons));
        }
        matchIconSet.retainAll(tileIconSet);
        return !matchIconSet.isEmpty();
    }

    private static ConnectedProperties[][] propertyListToArray(List list) {
        ConnectedProperties[][] propArr = new ConnectedProperties[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List subList = (List)list.get(i);
            if (subList == null) continue;
            ConnectedProperties[] subArr = subList.toArray(new ConnectedProperties[subList.size()]);
            propArr[i] = subArr;
        }
        return propArr;
    }

    private static void addToTileList(ConnectedProperties cp, List tileList) {
        if (cp.matchTileIcons == null) {
            return;
        }
        for (int i = 0; i < cp.matchTileIcons.length; ++i) {
            class_1058 icon = cp.matchTileIcons[i];
            if (!(icon instanceof class_1058)) {
                Config.warn("TextureAtlasSprite is not TextureAtlasSprite: " + icon + ", name: " + icon.method_4598());
                continue;
            }
            class_1058 ts = icon;
            int tileId = ts.getIndexInMap();
            if (tileId < 0) {
                Config.warn("Invalid tile ID: " + tileId + ", icon: " + ts.method_4598());
                continue;
            }
            ConnectedTextures.addToList(cp, tileList, tileId);
        }
    }

    private static void addToBlockList(ConnectedProperties cp, List blockList) {
        if (cp.matchBlocks == null) {
            return;
        }
        for (int i = 0; i < cp.matchBlocks.length; ++i) {
            int blockId = cp.matchBlocks[i].getBlockId();
            if (blockId < 0) {
                Config.warn("Invalid block ID: " + blockId);
                continue;
            }
            ConnectedTextures.addToList(cp, blockList, blockId);
        }
    }

    private static void addToList(ConnectedProperties cp, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<ConnectedProperties> subList = (ArrayList<ConnectedProperties>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<ConnectedProperties>();
            list.set(id, subList);
        }
        subList.add(cp);
    }

    private static String[] getDefaultCtmPaths() {
        ArrayList<String> list = new ArrayList<String>();
        String defPath = "optifine/ctm/default/";
        if (Config.isFromDefaultResourcePack(new class_2960("textures/block/glass.png"))) {
            list.add(defPath + "20_glass/glass.properties");
            list.add(defPath + "20_glass/glass_pane.properties");
        }
        if (Config.isFromDefaultResourcePack(new class_2960("textures/block/bookshelf.png"))) {
            list.add(defPath + "30_bookshelf/bookshelf.properties");
        }
        if (Config.isFromDefaultResourcePack(new class_2960("textures/block/sandstone.png"))) {
            list.add(defPath + "40_sandstone/sandstone.properties");
        }
        if (Config.isFromDefaultResourcePack(new class_2960("textures/block/red_sandstone.png"))) {
            list.add(defPath + "41_red_sandstone/red_sandstone.properties");
        }
        String[] colors = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        for (int i = 0; i < colors.length; ++i) {
            String color = colors[i];
            if (!Config.isFromDefaultResourcePack(new class_2960("textures/block/" + color + "_stained_glass.png"))) continue;
            String prefix = StrUtils.fillLeft("" + i, 2, '0');
            list.add(defPath + prefix + "_glass_" + color + "/glass_" + color + ".properties");
            list.add(defPath + prefix + "_glass_" + color + "/glass_pane_" + color + ".properties");
        }
        String[] paths = list.toArray(new String[list.size()]);
        return paths;
    }
}

