/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_315;
import net.optifine.http.FileUploadThread;
import net.optifine.http.IFileUploadListener;
import net.optifine.shaders.Shaders;

public class CrashReporter {
    public static void onCrashReport(class_128 crashReport, class_129 category) {
        try {
            class_315 settings = Config.getGameSettings();
            if (settings == null) {
                return;
            }
            if (!settings.field_1847) {
                return;
            }
            Throwable cause = crashReport.method_564();
            if (cause == null) {
                return;
            }
            if (cause.getClass() == Throwable.class) {
                return;
            }
            if (cause.getClass().getName().contains(".fml.client.SplashProgress")) {
                return;
            }
            CrashReporter.extendCrashReport(category);
            String url = "http://optifine.net/crashReport";
            String reportStr = CrashReporter.makeReport(crashReport);
            byte[] content = reportStr.getBytes("ASCII");
            IFileUploadListener listener = new IFileUploadListener(){

                @Override
                public void fileUploadFinished(String url, byte[] content, Throwable exception) {
                }
            };
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("OF-Version", Config.getVersion());
            headers.put("OF-Summary", CrashReporter.makeSummary(crashReport));
            FileUploadThread fut = new FileUploadThread(url, headers, content, listener);
            fut.setPriority(10);
            fut.start();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            Config.dbg(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private static String makeReport(class_128 crashReport) {
        StringBuffer sb = new StringBuffer();
        sb.append("OptiFineVersion: " + Config.getVersion() + "\n");
        sb.append("Summary: " + CrashReporter.makeSummary(crashReport) + "\n");
        sb.append("\n");
        sb.append(crashReport.method_568());
        sb.append("\n");
        return sb.toString();
    }

    private static String makeSummary(class_128 crashReport) {
        Throwable t = crashReport.method_564();
        if (t == null) {
            return "Unknown";
        }
        StackTraceElement[] traces = t.getStackTrace();
        String firstTrace = "unknown";
        if (traces.length > 0) {
            firstTrace = traces[0].toString().trim();
        }
        String sum = t.getClass().getName() + ": " + t.getMessage() + " (" + crashReport.method_561() + ") [" + firstTrace + "]";
        return sum;
    }

    public static void extendCrashReport(class_129 cat) {
        cat.method_578("OptiFine Version", (Object)Config.getVersion());
        cat.method_578("OptiFine Build", (Object)Config.getBuild());
        if (Config.getGameSettings() != null) {
            cat.method_578("Render Distance Chunks", (Object)("" + Config.getChunkViewDistance()));
            cat.method_578("Mipmaps", (Object)("" + Config.getMipmapLevels()));
            cat.method_578("Anisotropic Filtering", (Object)("" + Config.getAnisotropicFilterLevel()));
            cat.method_578("Antialiasing", (Object)("" + Config.getAntialiasingLevel()));
            cat.method_578("Multitexture", (Object)("" + Config.isMultiTexture()));
        }
        cat.method_578("Shaders", (Object)("" + Shaders.getShaderPackName()));
        cat.method_578("OpenGlVersion", (Object)("" + Config.openGlVersion));
        cat.method_578("OpenGlRenderer", (Object)("" + Config.openGlRenderer));
        cat.method_578("OpenGlVendor", (Object)("" + Config.openGlVendor));
        cat.method_578("CpuCount", (Object)("" + Config.getAvailableProcessors()));
    }
}

