/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.shaders.BlockAliases;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;

public class CustomBlockLayers {
    private static class_1921[] renderLayers = null;
    public static boolean active = false;

    public static class_1921 getRenderLayer(class_1920 worldReader, class_2680 blockState, class_2338 blockPos) {
        if (renderLayers == null) {
            return null;
        }
        if (blockState.method_11598((class_1922)worldReader, blockPos)) {
            return null;
        }
        int id = blockState.getBlockId();
        if (id <= 0 || id >= renderLayers.length) {
            return null;
        }
        return renderLayers[id];
    }

    public static void update() {
        PropertiesOrdered propsShaders;
        renderLayers = null;
        active = false;
        ArrayList<class_1921> list = new ArrayList<class_1921>();
        String pathProps = "optifine/block.properties";
        Properties props = ResUtils.readProperties(pathProps, "CustomBlockLayers");
        if (props != null) {
            CustomBlockLayers.readLayers(pathProps, props, list);
        }
        if (Config.isShaders() && (propsShaders = BlockAliases.getBlockLayerPropertes()) != null) {
            String pathPropsShaders = "shaders/block.properties";
            CustomBlockLayers.readLayers(pathPropsShaders, propsShaders, list);
        }
        if (list.isEmpty()) {
            return;
        }
        renderLayers = list.toArray(new class_1921[list.size()]);
        active = true;
    }

    private static void readLayers(String pathProps, Properties props, List<class_1921> list) {
        Config.dbg("CustomBlockLayers: " + pathProps);
        CustomBlockLayers.readLayer("solid", class_1921.field_9178, props, list);
        CustomBlockLayers.readLayer("cutout", class_1921.field_9174, props, list);
        CustomBlockLayers.readLayer("cutout_mipped", class_1921.field_9175, props, list);
        CustomBlockLayers.readLayer("translucent", class_1921.field_9179, props, list);
    }

    private static void readLayer(String name, class_1921 layer, Properties props, List<class_1921> listLayers) {
        String key = "layer." + name;
        String val = props.getProperty(key);
        if (val == null) {
            return;
        }
        ConnectedParser cp = new ConnectedParser("CustomBlockLayers");
        MatchBlock[] mbs = cp.parseMatchBlocks(val);
        if (mbs == null) {
            return;
        }
        for (int i = 0; i < mbs.length; ++i) {
            MatchBlock mb = mbs[i];
            int blockId = mb.getBlockId();
            if (blockId <= 0) continue;
            while (listLayers.size() < blockId + 1) {
                listLayers.add(null);
            }
            if (listLayers.get(blockId) != null) {
                Config.warn("CustomBlockLayers: Block layer is already set, block: " + blockId + ", layer: " + name);
            }
            listLayers.set(blockId, layer);
        }
    }

    public static boolean isActive() {
        return active;
    }
}

