/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1495;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1500;
import net.minecraft.class_1501;
import net.minecraft.class_1646;
import net.minecraft.class_1767;
import net.minecraft.class_1941;
import net.minecraft.class_1959;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2601;
import net.minecraft.class_2608;
import net.minecraft.class_2611;
import net.minecraft.class_2627;
import net.minecraft.class_2646;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_437;
import net.optifine.CustomGuis;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<class_2960, class_2960> textureLocations = null;
    private NbtTagValue nbtName = null;
    private class_1959[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private MatchProfession[] professions = null;
    private EnumVariant[] variants = null;
    private class_1767[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final class_1767[] COLORS_INVALID = new class_1767[0];
    private static final class_2960 ANVIL_GUI_TEXTURE = new class_2960("textures/gui/container/anvil.png");
    private static final class_2960 BEACON_GUI_TEXTURE = new class_2960("textures/gui/container/beacon.png");
    private static final class_2960 BREWING_STAND_GUI_TEXTURE = new class_2960("textures/gui/container/brewing_stand.png");
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("textures/gui/container/generic_54.png");
    private static final class_2960 CRAFTING_TABLE_GUI_TEXTURE = new class_2960("textures/gui/container/crafting_table.png");
    private static final class_2960 HORSE_GUI_TEXTURE = new class_2960("textures/gui/container/horse.png");
    private static final class_2960 DISPENSER_GUI_TEXTURE = new class_2960("textures/gui/container/dispenser.png");
    private static final class_2960 ENCHANTMENT_TABLE_GUI_TEXTURE = new class_2960("textures/gui/container/enchanting_table.png");
    private static final class_2960 FURNACE_GUI_TEXTURE = new class_2960("textures/gui/container/furnace.png");
    private static final class_2960 HOPPER_GUI_TEXTURE = new class_2960("textures/gui/container/hopper.png");
    private static final class_2960 INVENTORY_GUI_TEXTURE = new class_2960("textures/gui/container/inventory.png");
    private static final class_2960 SHULKER_BOX_GUI_TEXTURE = new class_2960("textures/gui/container/shulker_box.png");
    private static final class_2960 VILLAGER_GUI_TEXTURE = new class_2960("textures/gui/container/villager2.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations(props, "texture", this.container, "textures/gui/", this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListInt(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        Enum[] vars = CustomGuiProperties.getContainerVariants(this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), vars, "variants", VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors(props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static class_1767[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize(str, " ");
        class_1767[] cols = new class_1767[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            class_1767 col = CustomGuiProperties.parseEnumDyeColor(token);
            if (col == null) {
                CustomGuiProperties.warn("Invalid color: " + token);
                return COLORS_INVALID;
            }
            cols[i] = col;
        }
        return cols;
    }

    private static class_1767 parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        class_1767[] colors = class_1767.values();
        for (int i = 0; i < colors.length; ++i) {
            class_1767 enumDyeColor = colors[i];
            if (enumDyeColor.method_15434().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.method_7792().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static class_2960 parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        String tex = TextureUtils.fixResourcePath(str = str.trim(), basePath);
        if (!tex.endsWith(".png")) {
            tex = tex + ".png";
        }
        return new class_2960(basePath + "/" + tex);
    }

    private static Map<class_2960, class_2960> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<class_2960, class_2960> map = new HashMap<class_2960, class_2960>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            class_2960 locKey = CustomGuiProperties.getGuiTextureLocation(container);
            class_2960 locVal = CustomGuiProperties.parseTextureLocation(propVal, basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix(pathRel, "/", ".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            class_2960 locKey = new class_2960(path);
            class_2960 locVal = CustomGuiProperties.parseTextureLocation(val, basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static class_2960 getGuiTextureLocation(EnumContainer container) {
        switch (container) {
            case ANVIL: {
                return ANVIL_GUI_TEXTURE;
            }
            case BEACON: {
                return BEACON_GUI_TEXTURE;
            }
            case BREWING_STAND: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case CHEST: {
                return CHEST_GUI_TEXTURE;
            }
            case CRAFTING: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case CREATIVE: {
                return null;
            }
            case DISPENSER: {
                return DISPENSER_GUI_TEXTURE;
            }
            case ENCHANTMENT: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case FURNACE: {
                return FURNACE_GUI_TEXTURE;
            }
            case HOPPER: {
                return HOPPER_GUI_TEXTURE;
            }
            case HORSE: {
                return HORSE_GUI_TEXTURE;
            }
            case INVENTORY: {
                return INVENTORY_GUI_TEXTURE;
            }
            case SHULKER_BOX: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case VILLAGER: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn("No base path found: " + path);
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn("No container found: " + path);
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn("No texture found: " + path);
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn("Invalid professions or careers: " + path);
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn("Invalid variants: " + path);
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn("Invalid colors: " + path);
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }

    private boolean matchesGeneral(EnumContainer ec, class_2338 pos, class_1941 blockAccess) {
        class_1959 biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome(biome = blockAccess.method_8310(pos), this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.method_10264());
    }

    public boolean matchesPos(EnumContainer ec, class_2338 pos, class_1941 blockAccess, class_437 screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName(screen))) {
            return false;
        }
        switch (ec) {
            case BEACON: {
                return this.matchesBeacon(pos, blockAccess);
            }
            case CHEST: {
                return this.matchesChest(pos, blockAccess);
            }
            case DISPENSER: {
                return this.matchesDispenser(pos, blockAccess);
            }
            case SHULKER_BOX: {
                return this.matchesShulker(pos, blockAccess);
            }
        }
        return true;
    }

    public static String getName(class_437 screen) {
        class_2561 itc = screen.getTitle();
        if (itc == null) {
            return null;
        }
        return itc.method_10851();
    }

    private boolean matchesBeacon(class_2338 pos, class_1941 blockAccess) {
        int l;
        class_2586 te = blockAccess.method_8321(pos);
        if (!(te instanceof class_2580)) {
            return false;
        }
        class_2580 teb = (class_2580)te;
        return this.levels == null || this.levels.isInRange(l = teb.method_10939());
    }

    private boolean matchesChest(class_2338 pos, class_1941 blockAccess) {
        class_2586 te = blockAccess.method_8321(pos);
        if (te instanceof class_2595) {
            class_2595 tec = (class_2595)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof class_2611) {
            class_2611 teec = (class_2611)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(class_2595 tec, class_2338 pos, class_1941 blockAccess) {
        class_2680 blockState = blockAccess.method_8320(pos);
        class_2745 chestType = blockState.method_11570((class_2769)class_2281.field_10770) ? (class_2745)blockState.method_11654((class_2769)class_2281.field_10770) : class_2745.field_12569;
        boolean isLarge = chestType == class_2745.field_12569;
        boolean isTrapped = tec instanceof class_2646;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(class_2611 teec, class_2338 pos, class_1941 blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(class_2338 pos, class_1941 blockAccess) {
        EnumVariant var;
        class_2586 te = blockAccess.method_8321(pos);
        if (!(te instanceof class_2601)) {
            return false;
        }
        class_2601 ted = (class_2601)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(class_2601 ted) {
        if (ted instanceof class_2608) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(class_2338 pos, class_1941 blockAccess) {
        class_1767 col;
        class_2586 te = blockAccess.method_8321(pos);
        if (!(te instanceof class_2627)) {
            return false;
        }
        class_2627 tesb = (class_2627)te;
        return this.colors == null || Config.equalsOne(col = tesb.method_11320(), this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, class_1297 entity, class_1941 blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.method_5704(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.method_5820())) {
            return false;
        }
        switch (ec) {
            case VILLAGER: {
                return this.matchesVillager(entity, blockAccess);
            }
            case HORSE: {
                return this.matchesHorse(entity, blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(class_1297 entity, class_1941 blockAccess) {
        int level;
        class_3850 vd;
        class_3852 vp;
        if (!(entity instanceof class_1646)) {
            return false;
        }
        class_1646 entityVillager = (class_1646)entity;
        return this.professions == null || MatchProfession.matchesOne(vp = (vd = entityVillager.method_7231()).method_16924(), level = vd.method_16925(), this.professions);
    }

    private boolean matchesHorse(class_1297 entity, class_1941 blockAccess) {
        class_1501 el;
        class_1767 col;
        EnumVariant var;
        if (!(entity instanceof class_1496)) {
            return false;
        }
        class_1496 ah = (class_1496)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof class_1501) || Config.equalsOne(col = (el = (class_1501)ah).method_6800(), this.colors);
    }

    private EnumVariant getHorseVariant(class_1496 entity) {
        if (entity instanceof class_1498) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof class_1495) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof class_1500) {
            return EnumVariant.MULE;
        }
        if (entity instanceof class_1501) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public class_2960 getTextureLocation(class_2960 loc) {
        class_2960 locNew = this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + (Object)((Object)this.container) + ", textures: " + this.textureLocations;
    }

    private static enum EnumVariant {
        HORSE,
        DONKEY,
        MULE,
        LLAMA,
        DISPENSER,
        DROPPER;

    }

    public static enum EnumContainer {
        ANVIL,
        BEACON,
        BREWING_STAND,
        CHEST,
        CRAFTING,
        DISPENSER,
        ENCHANTMENT,
        FURNACE,
        HOPPER,
        HORSE,
        VILLAGER,
        SHULKER_BOX,
        CREATIVE,
        INVENTORY;

    }
}

