/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_761;
import net.minecraft.class_849;
import net.minecraft.class_851;
import net.optifine.DynamicLights;

public class DynamicLight {
    private class_1297 entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<class_2338> setLitChunkPos = new HashSet<class_2338>();
    private class_2338.class_2339 blockPosMutable = new class_2338.class_2339();

    public DynamicLight(class_1297 entity) {
        this.entity = entity;
        this.offsetY = entity.method_5751();
    }

    public void update(class_761 renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.field_5987 - 0.5;
        double posY = this.entity.field_6010 - 0.5 + this.offsetY;
        double posZ = this.entity.field_6035 - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet<class_2338> setNewPos = new HashSet<class_2338>();
        if (lightLevel > 0) {
            class_2350 dirX = (class_3532.method_15357((double)posX) & 0xF) >= 8 ? class_2350.field_11034 : class_2350.field_11039;
            class_2350 dirY = (class_3532.method_15357((double)posY) & 0xF) >= 8 ? class_2350.field_11036 : class_2350.field_11033;
            class_2350 dirZ = (class_3532.method_15357((double)posZ) & 0xF) >= 8 ? class_2350.field_11035 : class_2350.field_11043;
            class_2338 chunkPos = new class_2338(posX, posY, posZ);
            class_851 chunk = renderGlobal.getRenderChunk(chunkPos);
            class_2338 chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            class_851 chunkX = renderGlobal.getRenderChunk(chunkPosX);
            class_2338 chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            class_851 chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            class_2338 chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            class_851 chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            class_2338 chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            class_851 chunkY = renderGlobal.getRenderChunk(chunkPosY);
            class_2338 chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            class_851 chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            class_2338 chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            class_851 chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            class_2338 chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            class_851 chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private class_2338 getChunkPos(class_851 renderChunk, class_2338 pos, class_2350 facing) {
        if (renderChunk != null) {
            return renderChunk.method_3676(facing);
        }
        return pos.method_10079(facing, 16);
    }

    private void updateChunkLight(class_851 renderChunk, Set<class_2338> setPrevPos, Set<class_2338> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        class_849 compiledChunk = renderChunk.method_3677();
        if (compiledChunk != null && !compiledChunk.method_3645()) {
            renderChunk.method_3654(false);
        }
        class_2338 pos = renderChunk.method_3670().method_10062();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(class_761 renderGlobal) {
        for (class_2338 posOld : this.setLitChunkPos) {
            class_851 chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public class_1297 getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

