/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.mojang.blaze3d.platform.GLX;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1049;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_1062;
import net.minecraft.class_2960;
import net.optifine.util.PropertiesOrdered;

public class EmissiveTextures {
    private static String suffixEmissive = null;
    private static String suffixEmissivePng = null;
    private static boolean active = false;
    private static boolean render = false;
    private static boolean hasEmissive = false;
    private static boolean renderEmissive = false;
    private static class_1060 textureManager = Config.getTextureManager();
    private static float lightMapX;
    private static float lightMapY;
    private static final String SUFFIX_PNG = ".png";
    private static final class_2960 LOCATION_EMPTY;

    public static boolean isActive() {
        return active;
    }

    public static String getSuffixEmissive() {
        return suffixEmissive;
    }

    public static void beginRender() {
        render = true;
        hasEmissive = false;
    }

    public static class_1062 getEmissiveTexture(class_1062 texture, Map<class_2960, class_1062> mapTextures) {
        class_1062 textureEmissive;
        if (!render) {
            return texture;
        }
        if (!(texture instanceof class_1049)) {
            return texture;
        }
        class_1049 simpleTexture = (class_1049)texture;
        class_2960 locationEmissive = simpleTexture.locationEmissive;
        if (!renderEmissive) {
            if (locationEmissive != null) {
                hasEmissive = true;
            }
            return texture;
        }
        if (locationEmissive == null) {
            locationEmissive = LOCATION_EMPTY;
        }
        if ((textureEmissive = mapTextures.get(locationEmissive)) == null) {
            textureEmissive = new class_1049(locationEmissive);
            textureManager.method_4616(locationEmissive, textureEmissive);
        }
        return textureEmissive;
    }

    public static boolean hasEmissive() {
        return hasEmissive;
    }

    public static void beginRenderEmissive() {
        lightMapX = GLX.lastBrightnessX;
        lightMapY = GLX.lastBrightnessY;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)240.0f, (float)lightMapY);
        renderEmissive = true;
    }

    public static void endRenderEmissive() {
        renderEmissive = false;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lightMapX, (float)lightMapY);
    }

    public static void endRender() {
        render = false;
        hasEmissive = false;
    }

    public static void update() {
        active = false;
        suffixEmissive = null;
        suffixEmissivePng = null;
        if (!Config.isEmissiveTextures()) {
            return;
        }
        try {
            String fileName = "optifine/emissive.properties";
            class_2960 loc = new class_2960(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            EmissiveTextures.dbg("Loading " + fileName);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            suffixEmissive = props.getProperty("suffix.emissive");
            if (suffixEmissive != null) {
                suffixEmissivePng = suffixEmissive + SUFFIX_PNG;
            }
            active = suffixEmissive != null;
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateIcons(class_1059 textureMap, Set<class_2960> locations) {
        if (!active) {
            return;
        }
        for (class_2960 loc : locations) {
            EmissiveTextures.checkEmissive(textureMap, loc);
        }
    }

    private static void checkEmissive(class_1059 textureMap, class_2960 locSprite) {
        String suffixEm = EmissiveTextures.getSuffixEmissive();
        if (suffixEm == null) {
            return;
        }
        if (locSprite.method_12832().endsWith(suffixEm)) {
            return;
        }
        class_2960 locSpriteEm = new class_2960(locSprite.method_12836(), locSprite.method_12832() + suffixEm);
        class_2960 locPngEm = textureMap.method_4603(locSpriteEm);
        if (!Config.hasResource(locPngEm)) {
            return;
        }
        class_1058 sprite = textureMap.registerSprite(locSprite);
        class_1058 spriteEmissive = textureMap.registerSprite(locSpriteEm);
        spriteEmissive.isSpriteEmissive = true;
        sprite.spriteEmissive = spriteEmissive;
    }

    private static void dbg(String str) {
        Config.dbg("EmissiveTextures: " + str);
    }

    private static void warn(String str) {
        Config.warn("EmissiveTextures: " + str);
    }

    public static boolean isEmissive(class_2960 loc) {
        if (suffixEmissivePng == null) {
            return false;
        }
        return loc.method_12832().endsWith(suffixEmissivePng);
    }

    public static void loadTexture(class_2960 loc, class_1049 tex) {
        if (loc == null || tex == null) {
            return;
        }
        tex.isEmissive = false;
        tex.locationEmissive = null;
        if (suffixEmissivePng == null) {
            return;
        }
        String path = loc.method_12832();
        if (!path.endsWith(SUFFIX_PNG)) {
            return;
        }
        if (path.endsWith(suffixEmissivePng)) {
            tex.isEmissive = true;
            return;
        }
        String pathEmPng = path.substring(0, path.length() - SUFFIX_PNG.length()) + suffixEmissivePng;
        class_2960 locEmPng = new class_2960(loc.method_12836(), pathEmPng);
        if (!Config.hasResource(locEmPng)) {
            return;
        }
        tex.locationEmissive = locEmPng;
    }

    static {
        LOCATION_EMPTY = new class_2960("optifine/ctm/default/empty.png");
    }
}

