/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.optifine.reflect.Reflector;

public class SpriteDependencies {
    private static int countDependenciesTotal;

    public static class_1058 resolveDependencies(List<class_1058> listRegisteredSprites, int ix, class_1059 textureMap) {
        class_1058 sprite = listRegisteredSprites.get(ix);
        while (SpriteDependencies.resolveOne(listRegisteredSprites, ix, sprite, textureMap)) {
            sprite = listRegisteredSprites.get(ix);
        }
        sprite.isDependencyParent = false;
        return sprite;
    }

    private static boolean resolveOne(List<class_1058> listRegisteredSprites, int ix, class_1058 sprite, class_1059 textureMap) {
        int countDep = 0;
        for (class_2960 locDep : sprite.getDependencies()) {
            Config.detail("Sprite dependency: " + sprite.method_4598() + " <- " + locDep);
            ++countDependenciesTotal;
            class_1058 spriteDep = textureMap.getRegisteredSprite(locDep);
            if (spriteDep == null) {
                spriteDep = textureMap.registerSprite(locDep);
            } else {
                int ixDep = listRegisteredSprites.indexOf(spriteDep);
                if (ixDep <= ix + countDep) continue;
                if (spriteDep.isDependencyParent) {
                    String error = "circular dependency: " + sprite.method_4598() + " -> " + spriteDep.method_4598();
                    class_2960 locSpritePng = textureMap.method_4603(sprite.method_4598());
                    Reflector.call(Reflector.ClientHooks_trackBrokenTexture, locSpritePng, error);
                    break;
                }
                listRegisteredSprites.remove(ixDep);
            }
            sprite.isDependencyParent = true;
            listRegisteredSprites.add(ix + countDep, spriteDep);
            ++countDep;
        }
        return countDep > 0;
    }

    public static void reset() {
        countDependenciesTotal = 0;
    }

    public static int getCountDependencies() {
        return countDependenciesTotal;
    }
}

