/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2348;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3852;
import net.optifine.ConnectedProperties;
import net.optifine.config.INameGetter;
import net.optifine.config.MatchBlock;
import net.optifine.config.MatchProfession;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeInt;
import net.optifine.config.RangeListInt;
import net.optifine.util.BiomeUtils;
import net.optifine.util.BlockUtils;
import net.optifine.util.EntityTypeUtils;
import net.optifine.util.ItemUtils;

public class ConnectedParser {
    private String context = null;
    public static final MatchProfession[] PROFESSIONS_INVALID = new MatchProfession[0];
    public static final class_1767[] DYE_COLORS_INVALID = new class_1767[0];
    private static Map<class_2960, class_1959> MAP_BIOMES_COMPACT = null;
    private static final INameGetter<Enum> NAME_GETTER_ENUM = new INameGetter<Enum>(){

        @Override
        public String getName(Enum en) {
            return en.name();
        }
    };
    private static final INameGetter<class_1767> NAME_GETTER_DYE_COLOR = new INameGetter<class_1767>(){

        @Override
        public String getName(class_1767 col) {
            return col.method_15434();
        }
    };

    public ConnectedParser(String context) {
        this.context = context;
    }

    public String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    public String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public MatchBlock[] parseMatchBlocks(String propMatchBlocks) {
        if (propMatchBlocks == null) {
            return null;
        }
        ArrayList<MatchBlock> list = new ArrayList<MatchBlock>();
        String[] blockStrs = Config.tokenize(propMatchBlocks, " ");
        for (int i = 0; i < blockStrs.length; ++i) {
            String blockStr = blockStrs[i];
            MatchBlock[] mbs = this.parseMatchBlock(blockStr);
            if (mbs == null) continue;
            list.addAll(Arrays.asList(mbs));
        }
        MatchBlock[] mbs = list.toArray(new MatchBlock[list.size()]);
        return mbs;
    }

    public class_2680 parseBlockState(String str, class_2680 def) {
        MatchBlock[] mbs = this.parseMatchBlock(str);
        if (mbs == null) {
            return def;
        }
        if (mbs.length != 1) {
            return def;
        }
        MatchBlock mb = mbs[0];
        int blockId = mb.getBlockId();
        class_2248 block = (class_2248)class_2378.field_11146.method_10200(blockId);
        return block.method_9564();
    }

    public MatchBlock[] parseMatchBlock(String blockStr) {
        if (blockStr == null) {
            return null;
        }
        if ((blockStr = blockStr.trim()).length() <= 0) {
            return null;
        }
        String[] parts = Config.tokenize(blockStr, ":");
        String domain = "minecraft";
        int blockIndex = 0;
        if (parts.length > 1 && this.isFullBlockName(parts)) {
            domain = parts[0];
            blockIndex = 1;
        } else {
            domain = "minecraft";
            blockIndex = 0;
        }
        String blockPart = parts[blockIndex];
        String[] params = Arrays.copyOfRange(parts, blockIndex + 1, parts.length);
        class_2248[] blocks = this.parseBlockPart(domain, blockPart);
        if (blocks == null) {
            return null;
        }
        MatchBlock[] datas = new MatchBlock[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            MatchBlock bd;
            class_2248 block = blocks[i];
            int blockId = class_2378.field_11146.method_10249((Object)block);
            int[] metadatas = null;
            if (params.length > 0 && (metadatas = this.parseBlockMetadatas(block, params)) == null) {
                return null;
            }
            datas[i] = bd = new MatchBlock(blockId, metadatas);
        }
        return datas;
    }

    public boolean isFullBlockName(String[] parts) {
        if (parts.length <= 1) {
            return false;
        }
        String part1 = parts[1];
        if (part1.length() < 1) {
            return false;
        }
        return !part1.contains("=");
    }

    public boolean startsWithDigit(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() < 1) {
            return false;
        }
        char ch = str.charAt(0);
        return Character.isDigit(ch);
    }

    public class_2248[] parseBlockPart(String domain, String blockPart) {
        String fullName = domain + ":" + blockPart;
        class_2960 fullLoc = new class_2960(fullName);
        class_2248 block = BlockUtils.getBlock(fullLoc);
        if (block == null) {
            this.warn("Block not found for name: " + fullName);
            return null;
        }
        class_2248[] blocks = new class_2248[]{block};
        return blocks;
    }

    public int[] parseBlockMetadatas(class_2248 block, String[] params) {
        if (params.length <= 0) {
            return null;
        }
        class_2680 stateDefault = block.method_9564();
        Collection properties = stateDefault.method_11569();
        HashMap<class_2769, List<Comparable>> mapPropValues = new HashMap<class_2769, List<Comparable>>();
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            if (param.length() <= 0) continue;
            String[] parts = Config.tokenize(param, "=");
            if (parts.length != 2) {
                this.warn("Invalid block property: " + param);
                return null;
            }
            String key = parts[0];
            String valStr = parts[1];
            class_2769 prop = ConnectedProperties.getProperty(key, properties);
            if (prop == null) {
                this.warn("Property not found: " + key + ", block: " + block);
                return null;
            }
            ArrayList<Comparable> list = (ArrayList<Comparable>)mapPropValues.get(key);
            if (list == null) {
                list = new ArrayList<Comparable>();
                mapPropValues.put(prop, list);
            }
            String[] vals = Config.tokenize(valStr, ",");
            for (int v = 0; v < vals.length; ++v) {
                String val = vals[v];
                Comparable propVal = ConnectedParser.parsePropertyValue(prop, val);
                if (propVal == null) {
                    this.warn("Property value not found: " + val + ", property: " + key + ", block: " + block);
                    return null;
                }
                list.add(propVal);
            }
        }
        if (mapPropValues.isEmpty()) {
            return null;
        }
        ArrayList<Integer> listMetadatas = new ArrayList<Integer>();
        int metaCount = BlockUtils.getMetadataCount(block);
        for (int md = 0; md < metaCount; ++md) {
            try {
                class_2680 bs = BlockUtils.getBlockState(block, md);
                if (!this.matchState(bs, mapPropValues)) continue;
                listMetadatas.add(md);
                continue;
            }
            catch (IllegalArgumentException bs) {
                // empty catch block
            }
        }
        if (listMetadatas.size() == metaCount) {
            return null;
        }
        int[] metadatas = new int[listMetadatas.size()];
        for (int i = 0; i < metadatas.length; ++i) {
            metadatas[i] = (Integer)listMetadatas.get(i);
        }
        return metadatas;
    }

    public static Comparable parsePropertyValue(class_2769 prop, String valStr) {
        Class valueClass = prop.method_11902();
        Comparable valueObj = ConnectedParser.parseValue(valStr, valueClass);
        if (valueObj == null) {
            Collection propertyValues = prop.method_11898();
            valueObj = ConnectedParser.getPropertyValue(valStr, propertyValues);
        }
        return valueObj;
    }

    public static Comparable getPropertyValue(String value, Collection propertyValues) {
        for (Comparable obj : propertyValues) {
            if (!ConnectedParser.getValueName(obj).equals(value)) continue;
            return obj;
        }
        return null;
    }

    private static Object getValueName(Comparable obj) {
        if (obj instanceof class_3542) {
            class_3542 iss = (class_3542)obj;
            return iss.method_15434();
        }
        return obj.toString();
    }

    public static Comparable parseValue(String str, Class cls) {
        if (cls == String.class) {
            return str;
        }
        if (cls == Boolean.class) {
            return Boolean.valueOf(str);
        }
        if (cls == Float.class) {
            return Float.valueOf(str);
        }
        if (cls == Double.class) {
            return Double.valueOf(str);
        }
        if (cls == Integer.class) {
            return Integer.valueOf(str);
        }
        if (cls == Long.class) {
            return Long.valueOf(str);
        }
        return null;
    }

    public boolean matchState(class_2680 bs, Map<class_2769, List<Comparable>> mapPropValues) {
        Set<class_2769> keys = mapPropValues.keySet();
        for (class_2769 prop : keys) {
            List<Comparable> vals = mapPropValues.get(prop);
            Comparable bsVal = bs.method_11654(prop);
            if (bsVal == null) {
                return false;
            }
            if (vals.contains(bsVal)) continue;
            return false;
        }
        return true;
    }

    public class_1959[] parseBiomes(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        boolean negative = false;
        if (str.startsWith("!")) {
            negative = true;
            str = str.substring(1);
        }
        String[] biomeNames = Config.tokenize(str, " ");
        ArrayList list = new ArrayList();
        for (int i = 0; i < biomeNames.length; ++i) {
            String biomeName = biomeNames[i];
            class_1959 biome = this.findBiome(biomeName);
            if (biome == null) {
                this.warn("Biome not found: " + biomeName);
                continue;
            }
            list.add(biome);
        }
        if (negative) {
            ArrayList listAllBiomes = Lists.newArrayList((Iterator)class_2378.field_11153.iterator());
            listAllBiomes.removeAll(list);
            list = listAllBiomes;
        }
        class_1959[] biomeArr = list.toArray(new class_1959[list.size()]);
        return biomeArr;
    }

    public class_1959 findBiome(String biomeName) {
        class_2960 biomeLoc = new class_2960(biomeName = biomeName.toLowerCase());
        class_1959 biome = BiomeUtils.getBiome(biomeLoc);
        if (biome != null) {
            return biome;
        }
        String biomeNameCompact = biomeName.replace(" ", "").replace("_", "");
        class_2960 biomeLocCompact = new class_2960(biomeNameCompact);
        if (MAP_BIOMES_COMPACT == null) {
            MAP_BIOMES_COMPACT = new HashMap<class_2960, class_1959>();
            Set<class_2960> biomeIds = BiomeUtils.getLocations();
            for (class_2960 loc : biomeIds) {
                class_1959 biomeCompact = BiomeUtils.getBiome(loc);
                String pathCompact = loc.method_12832().replace(" ", "").replace("_", "").toLowerCase();
                class_2960 locCompact = new class_2960(loc.method_12836(), pathCompact);
                MAP_BIOMES_COMPACT.put(locCompact, biomeCompact);
            }
        }
        if ((biome = MAP_BIOMES_COMPACT.get(biomeLocCompact)) != null) {
            return biome;
        }
        return null;
    }

    public int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int num = Config.parseInt(str = str.trim(), -1);
        if (num < 0) {
            this.warn("Invalid number: " + str);
            return defVal;
        }
        return num;
    }

    public int[] parseIntList(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] intStrs = Config.tokenize(str, " ,");
        for (int i = 0; i < intStrs.length; ++i) {
            String intStr = intStrs[i];
            if (intStr.contains("-")) {
                String[] subStrs = Config.tokenize(intStr, "-");
                if (subStrs.length != 2) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                int min = Config.parseInt(subStrs[0], -1);
                int max = Config.parseInt(subStrs[1], -1);
                if (min < 0 || max < 0 || min > max) {
                    this.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                for (int n = min; n <= max; ++n) {
                    list.add(n);
                }
                continue;
            }
            int val = Config.parseInt(intStr, -1);
            if (val < 0) {
                this.warn("Invalid number: " + intStr + ", when parsing: " + str);
                continue;
            }
            list.add(val);
        }
        int[] ints = new int[list.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = (Integer)list.get(i);
        }
        return ints;
    }

    public boolean[] parseFaces(String str, boolean[] defVal) {
        if (str == null) {
            return defVal;
        }
        EnumSet<class_2350> setFaces = EnumSet.allOf(class_2350.class);
        String[] faceStrs = Config.tokenize(str, " ,");
        for (int i = 0; i < faceStrs.length; ++i) {
            String faceStr = faceStrs[i];
            if (faceStr.equals("sides")) {
                setFaces.add(class_2350.field_11043);
                setFaces.add(class_2350.field_11035);
                setFaces.add(class_2350.field_11039);
                setFaces.add(class_2350.field_11034);
                continue;
            }
            if (faceStr.equals("all")) {
                setFaces.addAll(Arrays.asList(class_2350.field_11040));
                continue;
            }
            class_2350 face = this.parseFace(faceStr);
            if (face == null) continue;
            setFaces.add(face);
        }
        boolean[] faces = new boolean[class_2350.field_11040.length];
        for (int i = 0; i < faces.length; ++i) {
            faces[i] = setFaces.contains(class_2350.field_11040[i]);
        }
        return faces;
    }

    public class_2350 parseFace(String str) {
        if ((str = str.toLowerCase()).equals("bottom") || str.equals("down")) {
            return class_2350.field_11033;
        }
        if (str.equals("top") || str.equals("up")) {
            return class_2350.field_11036;
        }
        if (str.equals("north")) {
            return class_2350.field_11043;
        }
        if (str.equals("south")) {
            return class_2350.field_11035;
        }
        if (str.equals("east")) {
            return class_2350.field_11034;
        }
        if (str.equals("west")) {
            return class_2350.field_11039;
        }
        Config.warn("Unknown face: " + str);
        return null;
    }

    public void dbg(String str) {
        Config.dbg("" + this.context + ": " + str);
    }

    public void warn(String str) {
        Config.warn("" + this.context + ": " + str);
    }

    public RangeListInt parseRangeListInt(String str) {
        if (str == null) {
            return null;
        }
        RangeListInt list = new RangeListInt();
        String[] parts = Config.tokenize(str, " ,");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            RangeInt ri = this.parseRangeInt(part);
            if (ri == null) {
                return null;
            }
            list.addRange(ri);
        }
        return list;
    }

    private RangeInt parseRangeInt(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(45) >= 0) {
            String[] parts = Config.tokenize(str, "-");
            if (parts.length != 2) {
                this.warn("Invalid range: " + str);
                return null;
            }
            int min = Config.parseInt(parts[0], -1);
            int max = Config.parseInt(parts[1], -1);
            if (min < 0 || max < 0) {
                this.warn("Invalid range: " + str);
                return null;
            }
            return new RangeInt(min, max);
        }
        int val = Config.parseInt(str, -1);
        if (val < 0) {
            this.warn("Invalid integer: " + str);
            return null;
        }
        return new RangeInt(val, val);
    }

    public boolean parseBoolean(String str, boolean defVal) {
        if (str == null) {
            return defVal;
        }
        String strLower = str.toLowerCase().trim();
        if (strLower.equals("true")) {
            return true;
        }
        if (strLower.equals("false")) {
            return false;
        }
        this.warn("Invalid boolean: " + str);
        return defVal;
    }

    public Boolean parseBooleanObject(String str) {
        if (str == null) {
            return null;
        }
        String strLower = str.toLowerCase().trim();
        if (strLower.equals("true")) {
            return Boolean.TRUE;
        }
        if (strLower.equals("false")) {
            return Boolean.FALSE;
        }
        this.warn("Invalid boolean: " + str);
        return null;
    }

    public static int parseColor(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static int parseColor4(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        str = str.trim();
        try {
            int val = (int)(Long.parseLong(str, 16) & 0xFFFFFFFFFFFFFFFFL);
            return val;
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public class_1921 parseBlockRenderLayer(String str, class_1921 def) {
        if (str == null) {
            return def;
        }
        str = str.toLowerCase().trim();
        class_1921[] layers = class_1921.values();
        for (int i = 0; i < layers.length; ++i) {
            class_1921 layer = layers[i];
            if (!str.equals(layer.name().toLowerCase())) continue;
            return layer;
        }
        return def;
    }

    public <T> T parseObject(String str, T[] objs, INameGetter nameGetter, String property) {
        if (str == null) {
            return null;
        }
        String strLower = str.toLowerCase().trim();
        for (int i = 0; i < objs.length; ++i) {
            T obj = objs[i];
            String name = nameGetter.getName(obj);
            if (name == null || !name.toLowerCase().equals(strLower)) continue;
            return obj;
        }
        this.warn("Invalid " + property + ": " + str);
        return null;
    }

    public <T> T[] parseObjects(String str, T[] objs, INameGetter nameGetter, String property, T[] errValue) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase().trim();
        String[] parts = Config.tokenize(str, " ");
        Object[] arr = (Object[])Array.newInstance(objs.getClass().getComponentType(), parts.length);
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            T obj = this.parseObject(part, objs, nameGetter, property);
            if (obj == null) {
                return errValue;
            }
            arr[i] = obj;
        }
        return arr;
    }

    public Enum parseEnum(String str, Enum[] enums, String property) {
        return this.parseObject(str, enums, NAME_GETTER_ENUM, property);
    }

    public Enum[] parseEnums(String str, Enum[] enums, String property, Enum[] errValue) {
        return this.parseObjects(str, enums, NAME_GETTER_ENUM, property, errValue);
    }

    public class_1767[] parseDyeColors(String str, String property, class_1767[] errValue) {
        return this.parseObjects(str, class_1767.values(), NAME_GETTER_DYE_COLOR, property, errValue);
    }

    public NbtTagValue parseNbtTagValue(String path, String value) {
        if (path == null || value == null) {
            return null;
        }
        return new NbtTagValue(path, value);
    }

    public MatchProfession[] parseProfessions(String profStr) {
        if (profStr == null) {
            return null;
        }
        ArrayList<MatchProfession> list = new ArrayList<MatchProfession>();
        String[] tokens = Config.tokenize(profStr, " ");
        for (int i = 0; i < tokens.length; ++i) {
            String str = tokens[i];
            MatchProfession prof = this.parseProfession(str);
            if (prof == null) {
                this.warn("Invalid profession: " + str);
                return PROFESSIONS_INVALID;
            }
            list.add(prof);
        }
        if (list.isEmpty()) {
            return null;
        }
        MatchProfession[] arr = list.toArray(new MatchProfession[list.size()]);
        return arr;
    }

    private MatchProfession parseProfession(String str) {
        class_3852 prof;
        String strProf = str;
        String strLevels = null;
        int pos = str.lastIndexOf(58);
        if (pos >= 0) {
            String part1 = str.substring(0, pos);
            String part2 = str.substring(pos + 1);
            if (part2.isEmpty() || part2.matches("[0-9].*")) {
                strProf = part1;
                strLevels = part2;
            }
        }
        if ((prof = this.parseVillagerProfession(strProf)) == null) {
            return null;
        }
        int[] levels = this.parseIntList(strLevels);
        MatchProfession mp = new MatchProfession(prof, levels);
        return mp;
    }

    private class_3852 parseVillagerProfession(String str) {
        if (str == null) {
            return null;
        }
        class_2348 registry = class_2378.field_17167;
        class_2960 loc = new class_2960(str = str.toLowerCase());
        if (!registry.method_10250(loc)) {
            return null;
        }
        return (class_3852)registry.method_10223(loc);
    }

    public int[] parseItems(String str) {
        str = str.trim();
        TreeSet<Integer> setIds = new TreeSet<Integer>();
        String[] tokens = Config.tokenize(str, " ");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            class_2960 loc = new class_2960(token);
            class_1792 item = ItemUtils.getItem(loc);
            if (item == null) {
                this.warn("Item not found: " + token);
                continue;
            }
            int id = ItemUtils.getId(item);
            if (id < 0) {
                this.warn("Item has no ID: " + item + ", name: " + token);
                continue;
            }
            setIds.add(new Integer(id));
        }
        Integer[] integers = setIds.toArray(new Integer[setIds.size()]);
        int[] ints = Config.toPrimitive(integers);
        return ints;
    }

    public int[] parseEntities(String str) {
        str = str.trim();
        TreeSet<Integer> setIds = new TreeSet<Integer>();
        String[] tokens = Config.tokenize(str, " ");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            class_2960 loc = new class_2960(token);
            class_1299 type = EntityTypeUtils.getEntityType(loc);
            if (type == null) {
                this.warn("Entity not found: " + token);
                continue;
            }
            int id = class_2378.field_11145.method_10249((Object)type);
            if (id < 0) {
                this.warn("Entity has no ID: " + type + ", name: " + token);
                continue;
            }
            setIds.add(new Integer(id));
        }
        Integer[] integers = setIds.toArray(new Integer[setIds.size()]);
        int[] ints = Config.toPrimitive(integers);
        return ints;
    }
}

