/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_630;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;

public class CustomEntityModels {
    private static boolean active = false;
    private static Map<Class, class_897> originalEntityRenderMap = null;
    private static Map<Class, class_827> originalTileEntityRenderMap = null;

    public static void update() {
        Map<Class, class_897> entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map<Class, class_827> tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        if (entityRenderMap == null) {
            Config.warn("Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn("Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        if (!Config.isCustomEntityModels()) {
            return;
        }
        class_2960[] locs = CustomEntityModels.getModelLocations();
        for (int i = 0; i < locs.length; ++i) {
            Class entityClass;
            class_2960 loc = locs[i];
            Config.dbg("CustomEntityModel: " + loc.method_12832());
            IEntityRenderer rc = CustomEntityModels.parseEntityRender(loc);
            if (rc == null || (entityClass = rc.getEntityClass()) == null) continue;
            if (rc instanceof class_897) {
                entityRenderMap.put(entityClass, (class_897)rc);
            } else if (rc instanceof class_827) {
                tileEntityRenderMap.put(entityClass, (class_827)rc);
            } else {
                Config.warn("Unknown renderer type: " + rc.getClass().getName());
            }
            active = true;
        }
    }

    private static Map<Class, class_897> getEntityRenderMap() {
        class_898 rm = class_310.method_1551().method_1561();
        Map entityRenderMap = rm.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap<Class, class_897>(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<Class, class_827> getTileEntityRenderMap() {
        Map tileEntityRenderMap = class_824.field_4346.field_4345;
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap<Class, class_827>(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static class_2960[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<class_2960> resourceLocations = new ArrayList<class_2960>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String path = prefix + name + suffix;
            class_2960 loc = new class_2960(path);
            if (!Config.hasResource(loc)) continue;
            resourceLocations.add(loc);
        }
        class_2960[] locs = resourceLocations.toArray(new class_2960[resourceLocations.size()]);
        return locs;
    }

    private static IEntityRenderer parseEntityRender(class_2960 location) {
        try {
            JsonObject jo = CustomEntityModelParser.loadJson(location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender(jo, location.method_12832());
            return render;
        }
        catch (IOException e) {
            Config.error("" + e.getClass().getName() + ": " + e.getMessage());
            return null;
        }
        catch (JsonParseException e) {
            Config.error("" + ((Object)((Object)e)).getClass().getName() + ": " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender(obj, path);
        String name = cer.getName();
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter(name);
        CustomEntityModels.checkNull(modelAdapter, "Entity not found: " + name);
        Class entityClass = modelAdapter.getEntityClass();
        CustomEntityModels.checkNull(entityClass, "Entity class not found: " + name);
        IEntityRenderer render = CustomEntityModels.makeEntityRender(modelAdapter, cer);
        if (render == null) {
            return null;
        }
        render.setEntityClass(entityClass);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer) {
        class_3879 model;
        class_2960 textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel(modelAdapter, model, modelRenderers, mr)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, shadowSize);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            r.setLocationTextureCustom(textureLocation);
        }
        return r;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, class_3879 model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        for (int i = 0; i < modelRenderers.length; ++i) {
            CustomModelRenderer cmr = modelRenderers[i];
            if (CustomEntityModels.modifyModel(modelAdapter, model, cmr, mr)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, class_3879 model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        class_630 parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn("Model part not found: " + modelPart + ", model: " + model);
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.field_3663 != null) {
                parent.field_3663.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.field_3661 != null) {
                parent.field_3661.clear();
            }
        }
        parent.method_2845(customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize(modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }
}

