/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.minecraft.class_2586;
import net.minecraft.class_3879;
import net.minecraft.class_630;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.IRenderResolver;
import net.optifine.entity.model.anim.ModelVariableFloat;
import net.optifine.entity.model.anim.ModelVariableType;
import net.optifine.entity.model.anim.RenderResolverEntity;
import net.optifine.entity.model.anim.RenderResolverTileEntity;
import net.optifine.expr.IExpression;

public class ModelResolver
implements IModelResolver {
    private ModelAdapter modelAdapter;
    private class_3879 model;
    private CustomModelRenderer[] customModelRenderers;
    private class_630 thisModelRenderer;
    private class_630 partModelRenderer;
    private IRenderResolver renderResolver;

    public ModelResolver(ModelAdapter modelAdapter, class_3879 model, CustomModelRenderer[] customModelRenderers) {
        this.modelAdapter = modelAdapter;
        this.model = model;
        this.customModelRenderers = customModelRenderers;
        Class entityClass = modelAdapter.getEntityClass();
        this.renderResolver = class_2586.class.isAssignableFrom(entityClass) ? new RenderResolverTileEntity() : new RenderResolverEntity();
    }

    @Override
    public IExpression getExpression(String name) {
        ModelVariableFloat mv = this.getModelVariable(name);
        if (mv != null) {
            return mv;
        }
        IExpression param = this.renderResolver.getParameter(name);
        if (param != null) {
            return param;
        }
        return null;
    }

    @Override
    public class_630 getModelRenderer(String name) {
        if (name == null) {
            return null;
        }
        if (name.indexOf(":") >= 0) {
            String[] parts = Config.tokenize(name, ":");
            class_630 mr = this.getModelRenderer(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i];
                class_630 mrSub = mr.getChildDeep(part);
                if (mrSub == null) {
                    return null;
                }
                mr = mrSub;
            }
            return mr;
        }
        if (this.thisModelRenderer != null && name.equals("this")) {
            return this.thisModelRenderer;
        }
        if (this.partModelRenderer != null && name.equals("part")) {
            return this.partModelRenderer;
        }
        class_630 mrPart = this.modelAdapter.getModelRenderer(this.model, name);
        if (mrPart != null) {
            return mrPart;
        }
        for (int i = 0; i < this.customModelRenderers.length; ++i) {
            CustomModelRenderer cmr = this.customModelRenderers[i];
            class_630 mr = cmr.getModelRenderer();
            if (name.equals(mr.getId())) {
                return mr;
            }
            class_630 mrChild = mr.getChildDeep(name);
            if (mrChild == null) continue;
            return mrChild;
        }
        return null;
    }

    @Override
    public ModelVariableFloat getModelVariable(String name) {
        String[] parts = Config.tokenize(name, ".");
        if (parts.length != 2) {
            return null;
        }
        String modelName = parts[0];
        String varName = parts[1];
        class_630 mr = this.getModelRenderer(modelName);
        if (mr == null) {
            return null;
        }
        ModelVariableType varType = ModelVariableType.parse(varName);
        if (varType == null) {
            return null;
        }
        return new ModelVariableFloat(name, mr, varType);
    }

    public void setPartModelRenderer(class_630 partModelRenderer) {
        this.partModelRenderer = partModelRenderer;
    }

    public void setThisModelRenderer(class_630 thisModelRenderer) {
        this.thisModelRenderer = thisModelRenderer;
    }
}

