/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_922;
import net.optifine.expr.IExpressionFloat;

public enum RenderEntityParameterFloat implements IExpressionFloat
{
    LIMB_SWING("limb_swing"),
    LIMB_SWING_SPEED("limb_speed"),
    AGE("age"),
    HEAD_YAW("head_yaw"),
    HEAD_PITCH("head_pitch"),
    SCALE("scale"),
    HEALTH("health"),
    HURT_TIME("hurt_time"),
    IDLE_TIME("idle_time"),
    MAX_HEALTH("max_health"),
    MOVE_FORWARD("move_forward"),
    MOVE_STRAFING("move_strafing"),
    PARTIAL_TICKS("partial_ticks"),
    POS_X("pos_x"),
    POS_Y("pos_Y"),
    POS_Z("pos_Z"),
    REVENGE_TIME("revenge_time"),
    SWING_PROGRESS("swing_progress");

    private String name;
    private class_898 renderManager;
    private static final RenderEntityParameterFloat[] VALUES;

    private RenderEntityParameterFloat(String name) {
        this.name = name;
        this.renderManager = class_310.method_1551().method_1561();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public float eval() {
        class_897 render = this.renderManager.renderRender;
        if (render == null) {
            return 0.0f;
        }
        if (render instanceof class_922) {
            class_922 rlb = (class_922)render;
            switch (this) {
                case LIMB_SWING: {
                    return rlb.renderLimbSwing;
                }
                case LIMB_SWING_SPEED: {
                    return rlb.renderLimbSwingAmount;
                }
                case AGE: {
                    return rlb.renderAgeInTicks;
                }
                case HEAD_YAW: {
                    return rlb.renderHeadYaw;
                }
                case HEAD_PITCH: {
                    return rlb.renderHeadPitch;
                }
                case SCALE: {
                    return rlb.renderScaleFactor;
                }
            }
            class_1309 entity = rlb.renderEntity;
            if (entity == null) {
                return 0.0f;
            }
            switch (this) {
                case HEALTH: {
                    return entity.method_6032();
                }
                case HURT_TIME: {
                    return entity.field_6235;
                }
                case IDLE_TIME: {
                    return entity.method_6131();
                }
                case MAX_HEALTH: {
                    return entity.method_6063();
                }
                case MOVE_FORWARD: {
                    return entity.field_6250;
                }
                case MOVE_STRAFING: {
                    return entity.field_6212;
                }
                case POS_X: {
                    return (float)entity.field_5987;
                }
                case POS_Y: {
                    return (float)entity.field_6010;
                }
                case POS_Z: {
                    return (float)entity.field_6035;
                }
                case REVENGE_TIME: {
                    return entity.method_6117();
                }
                case SWING_PROGRESS: {
                    return entity.method_6055(rlb.renderPartialTicks);
                }
            }
        }
        return 0.0f;
    }

    public static RenderEntityParameterFloat parse(String str) {
        if (str == null) {
            return null;
        }
        for (int i = 0; i < VALUES.length; ++i) {
            RenderEntityParameterFloat type = VALUES[i];
            if (!type.getName().equals(str)) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES = RenderEntityParameterFloat.values();
    }
}

