/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import com.mojang.authlib.exceptions.InvalidCredentialsException;
import java.math.BigInteger;
import java.net.URI;
import java.util.Random;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.optifine.Lang;
import net.optifine.gui.GuiButtonOF;
import net.optifine.gui.GuiScreenOF;

public class GuiScreenCapeOF
extends GuiScreenOF {
    private final class_437 parentScreen;
    private String message;
    private long messageHideTimeMs;

    public GuiScreenCapeOF(class_437 parentScreenIn) {
        super((class_2561)new class_2585(class_1074.method_4662((String)"of.options.capeOF.title", (Object[])new Object[0])));
        this.parentScreen = parentScreenIn;
    }

    protected void init() {
        int i = 0;
        this.addButton((class_339)new GuiButtonOF(210, this.width / 2 - 155, this.height / 6 + 24 * ((i += 2) >> 1), 150, 20, class_1074.method_4662((String)"of.options.capeOF.openEditor", (Object[])new Object[0])));
        this.addButton((class_339)new GuiButtonOF(220, this.width / 2 - 155 + 160, this.height / 6 + 24 * (i >> 1), 150, 20, class_1074.method_4662((String)"of.options.capeOF.reloadCape", (Object[])new Object[0])));
        this.addButton((class_339)new GuiButtonOF(200, this.width / 2 - 100, this.height / 6 + 24 * ((i += 8) >> 1), class_1074.method_4662((String)"gui.done", (Object[])new Object[0])));
    }

    @Override
    protected void actionPerformed(class_339 guiElement) {
        if (!(guiElement instanceof GuiButtonOF)) {
            return;
        }
        GuiButtonOF button = (GuiButtonOF)guiElement;
        if (button.active) {
            if (button.id == 200) {
                this.minecraft.method_1507(this.parentScreen);
            }
            if (button.id == 210) {
                try {
                    String userName = this.minecraft.method_1548().method_1677().getName();
                    String userId = this.minecraft.method_1548().method_1677().getId().toString().replace("-", "");
                    String accessToken = this.minecraft.method_1548().method_1674();
                    Random r1 = new Random();
                    Random r2 = new Random(System.identityHashCode(new Object()));
                    BigInteger random1Bi = new BigInteger(128, r1);
                    BigInteger random2Bi = new BigInteger(128, r2);
                    BigInteger serverBi = random1Bi.xor(random2Bi);
                    String serverId = serverBi.toString(16);
                    this.minecraft.method_1495().joinServer(this.minecraft.method_1548().method_1677(), accessToken, serverId);
                    String urlStr = "https://optifine.net/capeChange?u=" + userId + "&n=" + userName + "&s=" + serverId;
                    Config.openWebLink(new URI(urlStr));
                    this.showMessage(Lang.get("of.message.capeOF.openEditor"), 10000L);
                }
                catch (InvalidCredentialsException e) {
                    Config.showGuiMessage(class_1074.method_4662((String)"of.message.capeOF.error1", (Object[])new Object[0]), class_1074.method_4662((String)"of.message.capeOF.error2", (Object[])new Object[]{e.getMessage()}));
                    Config.warn("Mojang authentication failed");
                    Config.warn(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage());
                }
                catch (Exception e) {
                    Config.warn("Error opening OptiFine cape link");
                    Config.warn(e.getClass().getName() + ": " + e.getMessage());
                }
            }
            if (button.id == 220) {
                this.showMessage(Lang.get("of.message.capeOF.reloadCape"), 15000L);
                if (this.minecraft.field_1724 != null) {
                    long delayMs = 15000L;
                    long reloadTimeMs = System.currentTimeMillis() + delayMs;
                    this.minecraft.field_1724.setReloadCapeTimeMs(reloadTimeMs);
                }
            }
        }
    }

    private void showMessage(String msg, long timeMs) {
        this.message = msg;
        this.messageHideTimeMs = System.currentTimeMillis() + timeMs;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(this.fontRenderer, this.title.method_10863(), this.width / 2, 20, 0xFFFFFF);
        if (this.message != null) {
            this.drawCenteredString(this.fontRenderer, this.message, this.width / 2, this.height / 6 + 60, 0xFFFFFF);
            if (System.currentTimeMillis() > this.messageHideTimeMs) {
                this.message = null;
            }
        }
        super.render(mouseX, mouseY, partialTicks);
    }
}

