/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.optifine.gui.GuiScreenOF;
import net.optifine.gui.TooltipProvider;

public class TooltipManager {
    private class_437 guiScreen;
    private TooltipProvider tooltipProvider;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private long mouseStillTime = 0L;

    public TooltipManager(class_437 guiScreen, TooltipProvider tooltipProvider) {
        this.guiScreen = guiScreen;
        this.tooltipProvider = tooltipProvider;
    }

    public void drawTooltips(int x, int y, List<class_339> buttonList) {
        if (Math.abs(x - this.lastMouseX) > 5 || Math.abs(y - this.lastMouseY) > 5) {
            this.lastMouseX = x;
            this.lastMouseY = y;
            this.mouseStillTime = System.currentTimeMillis();
            return;
        }
        int activateDelay = 700;
        if (System.currentTimeMillis() < this.mouseStillTime + (long)activateDelay) {
            return;
        }
        class_339 btn = GuiScreenOF.getSelectedButton(x, y, buttonList);
        if (btn == null) {
            return;
        }
        Rectangle rect = this.tooltipProvider.getTooltipBounds(this.guiScreen, x, y);
        String[] lines = this.tooltipProvider.getTooltipLines(btn, rect.width);
        if (lines == null) {
            return;
        }
        if (lines.length > 8) {
            lines = Arrays.copyOf(lines, 8);
            int n = lines.length - 1;
            lines[n] = lines[n] + " ...";
        }
        if (this.tooltipProvider.isRenderBorder()) {
            int colBorder = -528449408;
            this.drawRectBorder(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, colBorder);
        }
        class_332.fill((int)rect.x, (int)rect.y, (int)(rect.x + rect.width), (int)(rect.y + rect.height), (int)-536870912);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int col = 0xDDDDDD;
            if (line.endsWith("!")) {
                col = 0xFF2020;
            }
            class_327 fontRenderer = class_310.method_1551().field_1772;
            fontRenderer.method_1720(line, (float)(rect.x + 5), (float)(rect.y + 5 + i * 11), col);
        }
    }

    private void drawRectBorder(int x1, int y1, int x2, int y2, int col) {
        class_332.fill((int)x1, (int)(y1 - 1), (int)x2, (int)y1, (int)col);
        class_332.fill((int)x1, (int)y2, (int)x2, (int)(y2 + 1), (int)col);
        class_332.fill((int)(x1 - 1), (int)y1, (int)x1, (int)y2, (int)col);
        class_332.fill((int)x2, (int)y1, (int)(x2 + 1), (int)y2, (int)col);
    }
}

