/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.override;

import java.util.Arrays;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3610;
import net.minecraft.class_853;
import net.optifine.DynamicLights;
import net.optifine.render.RenderEnv;
import net.optifine.util.ArrayCache;

public class ChunkCacheOF
implements class_1920 {
    private final class_853 chunkCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int sizeXY;
    private int[] combinedLights;
    private class_2680[] blockStates;
    private final int arraySize;
    private final boolean dynamicLights = Config.isDynamicLights();
    private RenderEnv renderEnv;
    private static final ArrayCache cacheCombinedLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockStates = new ArrayCache(class_2680.class, 16);

    public ChunkCacheOF(class_853 chunkCache, class_2338 posFromIn, class_2338 posToIn, int subIn) {
        this.chunkCache = chunkCache;
        int minChunkX = posFromIn.method_10263() - subIn >> 4;
        int minChunkY = posFromIn.method_10264() - subIn >> 4;
        int minChunkZ = posFromIn.method_10260() - subIn >> 4;
        int maxChunkX = posToIn.method_10263() + subIn >> 4;
        int maxChunkY = posToIn.method_10264() + subIn >> 4;
        int maxChunkZ = posToIn.method_10260() + subIn >> 4;
        this.sizeX = maxChunkX - minChunkX + 1 << 4;
        this.sizeY = maxChunkY - minChunkY + 1 << 4;
        this.sizeZ = maxChunkZ - minChunkZ + 1 << 4;
        this.sizeXY = this.sizeX * this.sizeY;
        this.arraySize = this.sizeX * this.sizeY * this.sizeZ;
        this.posX = minChunkX << 4;
        this.posY = minChunkY << 4;
        this.posZ = minChunkZ << 4;
    }

    private int getPositionIndex(class_2338 pos) {
        int dx = pos.method_10263() - this.posX;
        if (dx < 0 || dx >= this.sizeX) {
            return -1;
        }
        int dy = pos.method_10264() - this.posY;
        if (dy < 0 || dy >= this.sizeY) {
            return -1;
        }
        int dz = pos.method_10260() - this.posZ;
        if (dz < 0 || dz >= this.sizeZ) {
            return -1;
        }
        return dz * this.sizeXY + dy * this.sizeX + dx;
    }

    public int method_8313(class_2338 pos, int lightValue) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.combinedLights == null) {
            return this.getCombinedLightRaw(pos, lightValue);
        }
        int light = this.combinedLights[index];
        if (light == -1) {
            this.combinedLights[index] = light = this.getCombinedLightRaw(pos, lightValue);
        }
        return light;
    }

    private int getCombinedLightRaw(class_2338 pos, int lightValue) {
        int light = this.chunkCache.method_8313(pos, lightValue);
        if (this.dynamicLights && !this.method_8320(pos).method_11598((class_1922)this, pos)) {
            light = DynamicLights.getCombinedLight(pos, light);
        }
        return light;
    }

    public class_2680 method_8320(class_2338 pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.blockStates == null) {
            return this.chunkCache.method_8320(pos);
        }
        class_2680 iblockstate = this.blockStates[index];
        if (iblockstate == null) {
            this.blockStates[index] = iblockstate = this.chunkCache.method_8320(pos);
        }
        return iblockstate;
    }

    public void renderStart() {
        if (this.combinedLights == null) {
            this.combinedLights = (int[])cacheCombinedLights.allocate(this.arraySize);
        }
        Arrays.fill(this.combinedLights, -1);
        if (this.blockStates == null) {
            this.blockStates = (class_2680[])cacheBlockStates.allocate(this.arraySize);
        }
        Arrays.fill(this.blockStates, null);
    }

    public void renderFinish() {
        cacheCombinedLights.free(this.combinedLights);
        this.combinedLights = null;
        cacheBlockStates.free(this.blockStates);
        this.blockStates = null;
    }

    public class_1959 method_8310(class_2338 pos) {
        return this.chunkCache.method_8310(pos);
    }

    public class_2586 method_8321(class_2338 pos) {
        return this.chunkCache.method_3688(pos, class_2818.class_2819.field_12859);
    }

    public class_2586 getTileEntity(class_2338 pos, class_2818.class_2819 type) {
        return this.chunkCache.method_3688(pos, type);
    }

    public int method_8314(class_1944 type, class_2338 pos) {
        return this.chunkCache.method_8314(type, pos);
    }

    public boolean method_8311(class_2338 pos) {
        return this.chunkCache.method_8311(pos);
    }

    public class_3610 method_8316(class_2338 pos) {
        return this.method_8320(pos).method_11618();
    }

    public RenderEnv getRenderEnv() {
        return this.renderEnv;
    }

    public void setRenderEnv(RenderEnv renderEnv) {
        this.renderEnv = renderEnv;
    }
}

