/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.IntBuffer;
import net.minecraft.class_1059;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2640;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_757;
import net.minecraft.class_759;
import net.minecraft.class_761;
import net.minecraft.class_856;
import net.minecraft.class_857;
import net.minecraft.class_858;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.ClippingHelperShadow;
import net.optifine.shaders.Shaders;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class ShadersRender {
    private static final class_2960 END_PORTAL_TEXTURE = new class_2960("textures/entity/end_portal.png");

    public static void setFrustrumPosition(class_856 frustum, double x, double y, double z) {
        frustum.method_3700(x, y, z);
    }

    public static void setupTerrain(class_761 worldRenderer, class_4184 activeRenderInfo, class_856 camera, int frameCount, boolean playerSpectator) {
        worldRenderer.method_3273(activeRenderInfo, camera, frameCount, playerSpectator);
    }

    public static void beginTerrainSolid() {
        if (Shaders.isRenderingWorld) {
            Shaders.fogEnabled = true;
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void beginTerrainCutoutMipped() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void beginTerrainCutout() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void endTerrain() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void beginTranslucent() {
        if (Shaders.isRenderingWorld) {
            if (Shaders.usedDepthBuffers >= 2) {
                GlStateManager.activeTexture((int)33995);
                Shaders.checkGLError("pre copy depth");
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Shaders.renderWidth, (int)Shaders.renderHeight);
                Shaders.checkGLError("copy depth");
                GlStateManager.activeTexture((int)33984);
            }
            Shaders.useProgram(Shaders.ProgramWater);
        }
    }

    public static void endTranslucent() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void renderHand0(class_757 er, class_4184 activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass) {
            boolean blockTranslucentMain = Shaders.isItemToRenderMainTranslucent();
            boolean blockTranslucentOff = Shaders.isItemToRenderOffTranslucent();
            if (!blockTranslucentMain || !blockTranslucentOff) {
                Shaders.readCenterDepth();
                Shaders.beginHand(false);
                GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Shaders.setSkipRenderHands(blockTranslucentMain, blockTranslucentOff);
                er.renderHand(activeRenderInfo, partialTicks, true, false, false);
                Shaders.endHand();
                Shaders.setHandsRendered(!blockTranslucentMain, !blockTranslucentOff);
                Shaders.setSkipRenderHands(false, false);
            }
        }
    }

    public static void renderHand1(class_757 er, class_4184 activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass && !Shaders.isBothHandsRendered()) {
            Shaders.readCenterDepth();
            GlStateManager.enableBlend();
            Shaders.beginHand(true);
            GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Shaders.setSkipRenderHands(Shaders.isHandRenderedMain(), Shaders.isHandRenderedOff());
            er.renderHand(activeRenderInfo, partialTicks, true, false, true);
            Shaders.endHand();
            Shaders.setHandsRendered(true, true);
            Shaders.setSkipRenderHands(false, false);
        }
    }

    public static void renderItemFP(class_759 itemRenderer, float par1, boolean renderTranslucent) {
        Shaders.setRenderingFirstPersonHand(true);
        GlStateManager.depthMask((boolean)true);
        if (renderTranslucent) {
            GlStateManager.depthFunc((int)519);
            GL11.glPushMatrix();
            IntBuffer drawBuffers = Shaders.activeDrawBuffers;
            Shaders.setDrawBuffers(Shaders.drawBuffersNone);
            Shaders.renderItemKeepDepthMask = true;
            itemRenderer.method_3225(par1);
            Shaders.renderItemKeepDepthMask = false;
            Shaders.setDrawBuffers(drawBuffers);
            GL11.glPopMatrix();
        }
        GlStateManager.depthFunc((int)515);
        GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        itemRenderer.method_3225(par1);
        Shaders.setRenderingFirstPersonHand(false);
    }

    public static void renderFPOverlay(class_757 er, class_4184 activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass) {
            Shaders.beginFPOverlay();
            er.renderHand(activeRenderInfo, partialTicks, false, true, false);
            Shaders.endFPOverlay();
        }
    }

    public static void beginBlockDamage() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramDamagedBlock);
            if (Shaders.ProgramDamagedBlock.getId() == Shaders.ProgramTerrain.getId()) {
                Shaders.setDrawBuffers(Shaders.drawBuffersColorAtt0);
                GlStateManager.depthMask((boolean)false);
            }
        }
    }

    public static void endBlockDamage() {
        if (Shaders.isRenderingWorld) {
            GlStateManager.depthMask((boolean)true);
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void renderShadowMap(class_757 entityRenderer, class_4184 activeRenderInfo, int pass, float partialTicks, long finishTimeNano) {
        if (Shaders.usedShadowDepthBuffers > 0 && --Shaders.shadowPassCounter <= 0) {
            class_310 mc = class_310.method_1551();
            mc.method_16011().method_15405("shadow pass");
            class_761 renderGlobal = mc.field_1769;
            Shaders.isShadowPass = true;
            Shaders.shadowPassCounter = Shaders.shadowPassInterval;
            Shaders.checkGLError("pre shadow");
            GL30.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL30.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            mc.method_16011().method_15405("shadow clear");
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)Shaders.sfb);
            Shaders.checkGLError("shadow bind sfb");
            mc.method_16011().method_15405("shadow camera");
            entityRenderer.method_3185(partialTicks);
            ShadersRender.updateActiveRenderInfo(activeRenderInfo, mc, partialTicks);
            Shaders.setCameraShadow(activeRenderInfo, partialTicks);
            Shaders.checkGLError("shadow camera");
            Shaders.useProgram(Shaders.ProgramShadow);
            GL30.glDrawBuffers((IntBuffer)Shaders.sfbDrawBuffers);
            Shaders.checkGLError("shadow drawbuffers");
            GL30.glReadBuffer((int)0);
            Shaders.checkGLError("shadow readbuffer");
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)Shaders.sfbDepthTextures.get(0), (int)0);
            if (Shaders.usedShadowColorBuffers != 0) {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)Shaders.sfbColorTextures.get(0), (int)0);
            }
            Shaders.checkFramebufferStatus("shadow fb");
            GL30.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL30.glClear((int)(Shaders.usedShadowColorBuffers != 0 ? 16640 : 256));
            Shaders.checkGLError("shadow clear");
            mc.method_16011().method_15405("shadow frustum");
            class_857 clippingHelper = ClippingHelperShadow.getInstance();
            mc.method_16011().method_15405("shadow culling");
            class_858 frustum = new class_858(clippingHelper);
            class_243 cameraPos = activeRenderInfo.method_19326();
            frustum.method_3700(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350);
            GlStateManager.shadeModel((int)7425);
            GlStateManager.enableDepthTest();
            GlStateManager.depthFunc((int)515);
            GlStateManager.depthMask((boolean)true);
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.disableCull();
            mc.method_16011().method_15405("shadow prepareterrain");
            mc.method_1531().method_4618(class_1059.field_5275);
            mc.method_16011().method_15405("shadow setupterrain");
            int frameCount = 0;
            frameCount = entityRenderer.field_4021;
            entityRenderer.field_4021 = frameCount + 1;
            renderGlobal.method_3273(activeRenderInfo, (class_856)frustum, frameCount, mc.field_1724.method_7325());
            mc.method_16011().method_15405("shadow updatechunks");
            mc.method_16011().method_15405("shadow terrain");
            GlStateManager.matrixMode((int)5888);
            GlStateManager.pushMatrix();
            GlStateManager.disableAlphaTest();
            renderGlobal.method_3251(class_1921.field_9178, activeRenderInfo);
            Shaders.checkGLError("shadow terrain solid");
            GlStateManager.enableAlphaTest();
            renderGlobal.method_3251(class_1921.field_9175, activeRenderInfo);
            Shaders.checkGLError("shadow terrain cutoutmipped");
            mc.method_1531().method_4619(class_1059.field_5275).method_4626(false, false);
            renderGlobal.method_3251(class_1921.field_9174, activeRenderInfo);
            Shaders.checkGLError("shadow terrain cutout");
            mc.method_1531().method_4619(class_1059.field_5275).method_4627();
            GlStateManager.shadeModel((int)7424);
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.matrixMode((int)5888);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            mc.method_16011().method_15405("shadow entities");
            if (Reflector.ForgeHooksClient_setRenderPass.exists()) {
                Reflector.callVoid(Reflector.ForgeHooksClient_setRenderPass, 0);
            }
            renderGlobal.method_3271(activeRenderInfo, (class_856)frustum, partialTicks);
            Shaders.checkGLError("shadow entities");
            GlStateManager.matrixMode((int)5888);
            GlStateManager.popMatrix();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.disableBlend();
            GlStateManager.enableCull();
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            if (Shaders.usedShadowDepthBuffers >= 2) {
                GlStateManager.activeTexture((int)33989);
                Shaders.checkGLError("pre copy shadow depth");
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Shaders.shadowMapWidth, (int)Shaders.shadowMapHeight);
                Shaders.checkGLError("copy shadow depth");
                GlStateManager.activeTexture((int)33984);
            }
            GlStateManager.disableBlend();
            GlStateManager.depthMask((boolean)true);
            mc.method_1531().method_4618(class_1059.field_5275);
            GlStateManager.shadeModel((int)7425);
            Shaders.checkGLError("shadow pre-translucent");
            GL30.glDrawBuffers((IntBuffer)Shaders.sfbDrawBuffers);
            Shaders.checkGLError("shadow drawbuffers pre-translucent");
            Shaders.checkFramebufferStatus("shadow pre-translucent");
            if (Shaders.isRenderShadowTranslucent()) {
                mc.method_16011().method_15405("shadow translucent");
                renderGlobal.method_3251(class_1921.field_9179, activeRenderInfo);
                Shaders.checkGLError("shadow translucent");
            }
            if (Reflector.ForgeHooksClient_setRenderPass.exists()) {
                class_308.method_1452();
                Reflector.call(Reflector.ForgeHooksClient_setRenderPass, 1);
                renderGlobal.method_3271(activeRenderInfo, (class_856)frustum, partialTicks);
                Reflector.call(Reflector.ForgeHooksClient_setRenderPass, -1);
                class_308.method_1450();
                Shaders.checkGLError("shadow entities 1");
            }
            GlStateManager.shadeModel((int)7424);
            GlStateManager.depthMask((boolean)true);
            GlStateManager.enableCull();
            GlStateManager.disableBlend();
            GL30.glFlush();
            Shaders.checkGLError("shadow flush");
            Shaders.isShadowPass = false;
            mc.method_16011().method_15405("shadow postprocess");
            if (Shaders.hasGlGenMipmap) {
                if (Shaders.usedShadowDepthBuffers >= 1) {
                    if (Shaders.shadowMipmapEnabled[0]) {
                        GlStateManager.activeTexture((int)33988);
                        GlStateManager.bindTexture((int)Shaders.sfbDepthTextures.get(0));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowFilterNearest[0] ? 9984 : 9987));
                    }
                    if (Shaders.usedShadowDepthBuffers >= 2 && Shaders.shadowMipmapEnabled[1]) {
                        GlStateManager.activeTexture((int)33989);
                        GlStateManager.bindTexture((int)Shaders.sfbDepthTextures.get(1));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowFilterNearest[1] ? 9984 : 9987));
                    }
                    GlStateManager.activeTexture((int)33984);
                }
                if (Shaders.usedShadowColorBuffers >= 1) {
                    if (Shaders.shadowColorMipmapEnabled[0]) {
                        GlStateManager.activeTexture((int)33997);
                        GlStateManager.bindTexture((int)Shaders.sfbColorTextures.get(0));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowColorFilterNearest[0] ? 9984 : 9987));
                    }
                    if (Shaders.usedShadowColorBuffers >= 2 && Shaders.shadowColorMipmapEnabled[1]) {
                        GlStateManager.activeTexture((int)33998);
                        GlStateManager.bindTexture((int)Shaders.sfbColorTextures.get(1));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowColorFilterNearest[1] ? 9984 : 9987));
                    }
                    GlStateManager.activeTexture((int)33984);
                }
            }
            Shaders.checkGLError("shadow postprocess");
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)Shaders.dfb);
            GL11.glViewport((int)0, (int)0, (int)Shaders.renderWidth, (int)Shaders.renderHeight);
            Shaders.activeDrawBuffers = null;
            mc.method_1531().method_4618(class_1059.field_5275);
            Shaders.useProgram(Shaders.ProgramTerrain);
            GL30.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL30.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL30.glMatrixMode((int)5888);
            Shaders.checkGLError("shadow end");
        }
    }

    public static void updateActiveRenderInfo(class_4184 activeRenderInfo, class_310 mc, float partialTicks) {
        activeRenderInfo.method_19321((class_1922)mc.field_1687, (class_1297)(mc.method_1560() == null ? mc.field_1724 : mc.method_1560()), mc.field_1690.field_1850 > 0, mc.field_1690.field_1850 == 2, partialTicks);
    }

    public static void preRenderChunkLayer(class_1921 blockLayerIn) {
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            GlStateManager.disableCull();
        }
        if (GLX.useVbo()) {
            GL11.glEnableClientState((int)32885);
            GL20.glEnableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.entityAttrib);
        }
    }

    public static void postRenderChunkLayer(class_1921 blockLayerIn) {
        if (GLX.useVbo()) {
            GL11.glDisableClientState((int)32885);
            GL20.glDisableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.entityAttrib);
        }
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            GlStateManager.enableCull();
        }
    }

    public static void setupArrayPointersVbo() {
        int vertexSizeI = 14;
        GL11.glVertexPointer((int)3, (int)5126, (int)56, (long)0L);
        GL11.glColorPointer((int)4, (int)5121, (int)56, (long)12L);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)56, (long)16L);
        GLX.glClientActiveTexture((int)GLX.GL_TEXTURE1);
        GL11.glTexCoordPointer((int)2, (int)5122, (int)56, (long)24L);
        GLX.glClientActiveTexture((int)GLX.GL_TEXTURE0);
        GL11.glNormalPointer((int)5120, (int)56, (long)28L);
        GL20.glVertexAttribPointer((int)Shaders.midTexCoordAttrib, (int)2, (int)5126, (boolean)false, (int)56, (long)32L);
        GL20.glVertexAttribPointer((int)Shaders.tangentAttrib, (int)4, (int)5122, (boolean)false, (int)56, (long)40L);
        GL20.glVertexAttribPointer((int)Shaders.entityAttrib, (int)3, (int)5122, (boolean)false, (int)56, (long)48L);
    }

    public static void beaconBeamBegin() {
        Shaders.useProgram(Shaders.ProgramBeaconBeam);
    }

    public static void beaconBeamStartQuad1() {
    }

    public static void beaconBeamStartQuad2() {
    }

    public static void beaconBeamDraw1() {
    }

    public static void beaconBeamDraw2() {
        GlStateManager.disableBlend();
    }

    public static void renderEnchantedGlintBegin() {
        Shaders.useProgram(Shaders.ProgramArmorGlint);
    }

    public static void renderEnchantedGlintEnd() {
        if (Shaders.isRenderingWorld) {
            if (Shaders.isRenderingFirstPersonHand() && Shaders.isRenderBothHands()) {
                Shaders.useProgram(Shaders.ProgramHand);
            } else {
                Shaders.useProgram(Shaders.ProgramEntities);
            }
        } else {
            Shaders.useProgram(Shaders.ProgramNone);
        }
    }

    public static boolean renderEndPortal(class_2640 te, double x, double y, double z, float partialTicks, int destroyStage, float offset) {
        int lu;
        float du;
        if (!Shaders.isShadowPass && Shaders.activeProgram.getId() == 0) {
            return false;
        }
        GlStateManager.disableLighting();
        Config.getTextureManager().method_4618(END_PORTAL_TEXTURE);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        bufferbuilder.method_1328(7, class_290.field_1582);
        float col = 0.5f;
        float r = col * 0.15f;
        float g = col * 0.3f;
        float b = col * 0.4f;
        float u0 = 0.0f;
        float u1 = 0.2f;
        float v0 = u0;
        float v1 = u1;
        float dv = du = (float)(System.currentTimeMillis() % 100000L) / 100000.0f;
        float dy = offset;
        int lv = lu = 240;
        if (te.method_11400(class_2350.field_11035)) {
            bufferbuilder.method_1315(x, y, z + 1.0).method_1336(r, g, b, 1.0f).method_1312((double)(u0 + du), (double)(v0 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x + 1.0, y, z + 1.0).method_1336(r, g, b, 1.0f).method_1312((double)(u0 + du), (double)(v1 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x + 1.0, y + 1.0, z + 1.0).method_1336(r, g, b, 1.0f).method_1312((double)(u1 + du), (double)(v1 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x, y + 1.0, z + 1.0).method_1336(r, g, b, 1.0f).method_1312((double)(u1 + du), (double)(v0 + dv)).method_1313(lu, lv).method_1344();
        }
        if (te.method_11400(class_2350.field_11043)) {
            bufferbuilder.method_1315(x, y + 1.0, z).method_1336(r, g, b, 1.0f).method_1312((double)(u1 + du), (double)(v1 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x + 1.0, y + 1.0, z).method_1336(r, g, b, 1.0f).method_1312((double)(u1 + du), (double)(v0 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x + 1.0, y, z).method_1336(r, g, b, 1.0f).method_1312((double)(u0 + du), (double)(v0 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x, y, z).method_1336(r, g, b, 1.0f).method_1312((double)(u0 + du), (double)(v1 + dv)).method_1313(lu, lv).method_1344();
        }
        if (te.method_11400(class_2350.field_11034)) {
            bufferbuilder.method_1315(x + 1.0, y + 1.0, z).method_1336(r, g, b, 1.0f).method_1312((double)(u1 + du), (double)(v1 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x + 1.0, y + 1.0, z + 1.0).method_1336(r, g, b, 1.0f).method_1312((double)(u1 + du), (double)(v0 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x + 1.0, y, z + 1.0).method_1336(r, g, b, 1.0f).method_1312((double)(u0 + du), (double)(v0 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x + 1.0, y, z).method_1336(r, g, b, 1.0f).method_1312((double)(u0 + du), (double)(v1 + dv)).method_1313(lu, lv).method_1344();
        }
        if (te.method_11400(class_2350.field_11039)) {
            bufferbuilder.method_1315(x, y, z).method_1336(r, g, b, 1.0f).method_1312((double)(u0 + du), (double)(v0 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x, y, z + 1.0).method_1336(r, g, b, 1.0f).method_1312((double)(u0 + du), (double)(v1 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x, y + 1.0, z + 1.0).method_1336(r, g, b, 1.0f).method_1312((double)(u1 + du), (double)(v1 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x, y + 1.0, z).method_1336(r, g, b, 1.0f).method_1312((double)(u1 + du), (double)(v0 + dv)).method_1313(lu, lv).method_1344();
        }
        if (te.method_11400(class_2350.field_11033)) {
            bufferbuilder.method_1315(x, y, z).method_1336(r, g, b, 1.0f).method_1312((double)(u0 + du), (double)(v0 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x + 1.0, y, z).method_1336(r, g, b, 1.0f).method_1312((double)(u0 + du), (double)(v1 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x + 1.0, y, z + 1.0).method_1336(r, g, b, 1.0f).method_1312((double)(u1 + du), (double)(v1 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x, y, z + 1.0).method_1336(r, g, b, 1.0f).method_1312((double)(u1 + du), (double)(v0 + dv)).method_1313(lu, lv).method_1344();
        }
        if (te.method_11400(class_2350.field_11036)) {
            bufferbuilder.method_1315(x, y + (double)dy, z + 1.0).method_1336(r, g, b, 1.0f).method_1312((double)(u0 + du), (double)(v0 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x + 1.0, y + (double)dy, z + 1.0).method_1336(r, g, b, 1.0f).method_1312((double)(u0 + du), (double)(v1 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x + 1.0, y + (double)dy, z).method_1336(r, g, b, 1.0f).method_1312((double)(u1 + du), (double)(v1 + dv)).method_1313(lu, lv).method_1344();
            bufferbuilder.method_1315(x, y + (double)dy, z).method_1336(r, g, b, 1.0f).method_1312((double)(u1 + du), (double)(v0 + dv)).method_1313(lu, lv).method_1344();
        }
        tessellator.method_1350();
        GlStateManager.enableLighting();
        return true;
    }
}

