/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import net.minecraft.class_2338;
import net.minecraft.class_3532;

public class MathUtils {
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float PId2 = 1.5707964f;
    private static final float[] ASIN_TABLE;

    public static float asin(float value) {
        return ASIN_TABLE[(int)((double)(value + 1.0f) * 32767.5) & 0xFFFF];
    }

    public static float acos(float value) {
        return 1.5707964f - ASIN_TABLE[(int)((double)(value + 1.0f) * 32767.5) & 0xFFFF];
    }

    public static int getAverage(int[] vals) {
        if (vals.length <= 0) {
            return 0;
        }
        int sum = MathUtils.getSum(vals);
        int avg = sum / vals.length;
        return avg;
    }

    public static int getSum(int[] vals) {
        if (vals.length <= 0) {
            return 0;
        }
        int sum = 0;
        for (int i = 0; i < vals.length; ++i) {
            int val = vals[i];
            sum += val;
        }
        return sum;
    }

    public static int roundDownToPowerOfTwo(int val) {
        int po2 = class_3532.method_15339((int)val);
        if (val == po2) {
            return po2;
        }
        return po2 / 2;
    }

    public static boolean equalsDelta(float f1, float f2, float delta) {
        return Math.abs(f1 - f2) <= delta;
    }

    public static float toDeg(float angle) {
        return angle * 180.0f / class_3532.PI;
    }

    public static float toRad(float angle) {
        return angle / 180.0f * class_3532.PI;
    }

    public static float roundToFloat(double d) {
        return (float)((double)Math.round(d * 1.0E8) / 1.0E8);
    }

    public static double distanceSq(class_2338 pos, double x, double y, double z) {
        return MathUtils.distanceSq((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), x, y, z);
    }

    public static float distanceSq(class_2338 pos, float x, float y, float z) {
        return MathUtils.distanceSq(pos.method_10263(), pos.method_10264(), pos.method_10260(), x, y, z);
    }

    public static double distanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public static float distanceSq(float x1, float y1, float z1, float x2, float y2, float z2) {
        float dx = x1 - x2;
        float dy = y1 - y2;
        float dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    static {
        int i;
        ASIN_TABLE = new float[65536];
        for (i = 0; i < 65536; ++i) {
            MathUtils.ASIN_TABLE[i] = (float)Math.asin((double)i / 32767.5 - 1.0);
        }
        for (i = -1; i < 2; ++i) {
            MathUtils.ASIN_TABLE[(int)(((double)i + 1.0) * 32767.5) & 0xFFFF] = (float)Math.asin(i);
        }
    }
}

