/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_407;
import net.minecraft.class_918;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class class_437
extends class_362
implements class_4068 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> ALLOWED_PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});
    protected final class_2561 title;
    protected final List<class_364> children = Lists.newArrayList();
    @Nullable
    protected class_310 minecraft;
    protected class_918 itemRenderer;
    public int width;
    public int height;
    protected final List<class_339> buttons = Lists.newArrayList();
    public boolean passEvents;
    protected class_327 font;
    private URI clickedLink;

    protected class_437(class_2561 class_25612) {
        this.title = class_25612;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public String getNarrationMessage() {
        return this.getTitle().getString();
    }

    @Override
    public void render(int n, int n2, float f) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).render(n, n2, f);
        }
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (n == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        if (n == 258) {
            boolean bl = \u2603 = !class_437.hasShiftDown();
            if (!this.changeFocus(\u2603)) {
                this.changeFocus(\u2603);
            }
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public void onClose() {
        this.minecraft.method_1507(null);
    }

    protected <T extends class_339> T addButton(T t) {
        this.buttons.add(t);
        this.children.add(t);
        return t;
    }

    protected void renderTooltip(class_1799 class_17992, int n, int n2) {
        this.renderTooltip(this.getTooltipFromItem(class_17992), n, n2);
    }

    public List<String> getTooltipFromItem(class_1799 class_17992) {
        List<class_2561> list = class_17992.method_7950(this.minecraft.field_1724, this.minecraft.field_1690.field_1827 ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934);
        ArrayList \u26032 = Lists.newArrayList();
        for (class_2561 class_25612 : list) {
            \u26032.add(class_25612.method_10863());
        }
        return \u26032;
    }

    public void renderTooltip(String string, int n, int n2) {
        this.renderTooltip(Arrays.asList(string), n, n2);
    }

    public void renderTooltip(List<String> list, int n3, int n2) {
        int n3;
        if (list.isEmpty()) {
            return;
        }
        GlStateManager.disableRescaleNormal();
        class_308.method_1450();
        GlStateManager.disableLighting();
        GlStateManager.disableDepthTest();
        \u2603 = 0;
        for (String string : list) {
            int n4 = this.font.method_1727(string);
            if (n4 <= \u2603) continue;
            \u2603 = n4;
        }
        \u2603 = n3 + 12;
        \u2603 = n2 - 12;
        n4 = \u2603;
        \u2603 = 8;
        if (list.size() > 1) {
            \u2603 += 2 + (list.size() - 1) * 10;
        }
        if (\u2603 + \u2603 > this.width) {
            \u2603 -= 28 + \u2603;
        }
        if (\u2603 + \u2603 + 6 > this.height) {
            \u2603 = this.height - \u2603 - 6;
        }
        this.blitOffset = 300;
        this.itemRenderer.field_4730 = 300.0f;
        \u2603 = -267386864;
        this.fillGradient(\u2603 - 3, \u2603 - 4, \u2603 + n4 + 3, \u2603 - 3, -267386864, -267386864);
        this.fillGradient(\u2603 - 3, \u2603 + \u2603 + 3, \u2603 + n4 + 3, \u2603 + \u2603 + 4, -267386864, -267386864);
        this.fillGradient(\u2603 - 3, \u2603 - 3, \u2603 + n4 + 3, \u2603 + \u2603 + 3, -267386864, -267386864);
        this.fillGradient(\u2603 - 4, \u2603 - 3, \u2603 - 3, \u2603 + \u2603 + 3, -267386864, -267386864);
        this.fillGradient(\u2603 + n4 + 3, \u2603 - 3, \u2603 + n4 + 4, \u2603 + \u2603 + 3, -267386864, -267386864);
        \u2603 = 0x505000FF;
        \u2603 = 1344798847;
        this.fillGradient(\u2603 - 3, \u2603 - 3 + 1, \u2603 - 3 + 1, \u2603 + \u2603 + 3 - 1, 0x505000FF, 1344798847);
        this.fillGradient(\u2603 + n4 + 2, \u2603 - 3 + 1, \u2603 + n4 + 3, \u2603 + \u2603 + 3 - 1, 0x505000FF, 1344798847);
        this.fillGradient(\u2603 - 3, \u2603 - 3, \u2603 + n4 + 3, \u2603 - 3 + 1, 0x505000FF, 0x505000FF);
        this.fillGradient(\u2603 - 3, \u2603 + \u2603 + 2, \u2603 + n4 + 3, \u2603 + \u2603 + 3, 1344798847, 1344798847);
        for (\u2603 = 0; \u2603 < list.size(); ++\u2603) {
            String string = list.get(\u2603);
            this.font.method_1720(string, \u2603, \u2603, -1);
            if (\u2603 == 0) {
                \u2603 += 2;
            }
            \u2603 += 10;
        }
        this.blitOffset = 0;
        this.itemRenderer.field_4730 = 0.0f;
        GlStateManager.enableLighting();
        GlStateManager.enableDepthTest();
        class_308.method_1452();
        GlStateManager.enableRescaleNormal();
    }

    protected void renderComponentHoverEffect(class_2561 class_25612, int n, int n2) {
        if (class_25612 == null || class_25612.method_10866().method_10969() == null) {
            return;
        }
        class_2568 class_25682 = class_25612.method_10866().method_10969();
        if (class_25682.method_10892() == class_2568.class_2569.field_11757) {
            class_1799 class_17992 = class_1799.field_8037;
            try {
                class_2487 class_24872 = class_2522.method_10718(class_25682.method_10891().getString());
                if (class_24872 instanceof class_2487) {
                    class_17992 = class_1799.method_7915(class_24872);
                }
            }
            catch (CommandSyntaxException class_24872) {
                // empty catch block
            }
            if (class_17992.method_7960()) {
                this.renderTooltip((Object)((Object)class_124.field_1061) + "Invalid Item!", n, n2);
            } else {
                this.renderTooltip(class_17992, n, n2);
            }
        } else if (class_25682.method_10892() == class_2568.class_2569.field_11761) {
            if (this.minecraft.field_1690.field_1827) {
                try {
                    class_2487 class_24873 = class_2522.method_10718(class_25682.method_10891().getString());
                    ArrayList \u26032 = Lists.newArrayList();
                    class_2561 \u26033 = class_2561.class_2562.method_10877(class_24873.method_10558("name"));
                    if (\u26033 != null) {
                        \u26032.add(\u26033.method_10863());
                    }
                    if (class_24873.method_10573("type", 8)) {
                        String string = class_24873.method_10558("type");
                        \u26032.add("Type: " + string);
                    }
                    \u26032.add(class_24873.method_10558("id"));
                    this.renderTooltip(\u26032, n, n2);
                }
                catch (JsonSyntaxException | CommandSyntaxException throwable) {
                    this.renderTooltip((Object)((Object)class_124.field_1061) + "Invalid Entity!", n, n2);
                }
            }
        } else if (class_25682.method_10892() == class_2568.class_2569.field_11762) {
            this.renderTooltip(this.minecraft.field_1772.method_1728(class_25682.method_10891().method_10863(), Math.max(this.width / 2, 200)), n, n2);
        }
        GlStateManager.disableLighting();
    }

    protected void insertText(String string, boolean bl) {
    }

    public boolean handleComponentClicked(class_2561 class_25612) {
        if (class_25612 == null) {
            return false;
        }
        class_2558 class_25582 = class_25612.method_10866().method_10970();
        if (class_437.hasShiftDown()) {
            if (class_25612.method_10866().method_10955() != null) {
                this.insertText(class_25612.method_10866().method_10955(), false);
            }
        } else if (class_25582 != null) {
            block19: {
                if (class_25582.method_10845() == class_2558.class_2559.field_11749) {
                    if (!this.minecraft.field_1690.field_1911) {
                        return false;
                    }
                    try {
                        URI uRI = new URI(class_25582.method_10844());
                        String \u26032 = uRI.getScheme();
                        if (\u26032 == null) {
                            throw new URISyntaxException(class_25582.method_10844(), "Missing protocol");
                        }
                        if (!ALLOWED_PROTOCOLS.contains(\u26032.toLowerCase(Locale.ROOT))) {
                            throw new URISyntaxException(class_25582.method_10844(), "Unsupported protocol: " + \u26032.toLowerCase(Locale.ROOT));
                        }
                        if (this.minecraft.field_1690.field_1817) {
                            this.clickedLink = uRI;
                            this.minecraft.method_1507(new class_407(this::confirmLink, class_25582.method_10844(), false));
                            break block19;
                        }
                        this.openLink(uRI);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        LOGGER.error("Can't open url for {}", (Object)class_25582, (Object)uRISyntaxException);
                    }
                } else if (class_25582.method_10845() == class_2558.class_2559.field_11746) {
                    URI uRI = new File(class_25582.method_10844()).toURI();
                    this.openLink(uRI);
                } else if (class_25582.method_10845() == class_2558.class_2559.field_11745) {
                    this.insertText(class_25582.method_10844(), true);
                } else if (class_25582.method_10845() == class_2558.class_2559.field_11750) {
                    this.sendMessage(class_25582.method_10844(), false);
                } else {
                    LOGGER.error("Don't know how to handle {}", (Object)class_25582);
                }
            }
            return true;
        }
        return false;
    }

    public void sendMessage(String string) {
        this.sendMessage(string, true);
    }

    public void sendMessage(String string, boolean bl) {
        if (bl) {
            this.minecraft.field_1705.method_1743().method_1803(string);
        }
        this.minecraft.field_1724.method_3142(string);
    }

    public void init(class_310 class_31010, int n, int n2) {
        this.minecraft = class_31010;
        this.itemRenderer = class_31010.method_1480();
        this.font = class_31010.field_1772;
        this.width = n;
        this.height = n2;
        this.buttons.clear();
        this.children.clear();
        this.setFocused(null);
        this.init();
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    @Override
    public List<? extends class_364> children() {
        return this.children;
    }

    protected void init() {
    }

    public void tick() {
    }

    public void removed() {
    }

    public void renderBackground() {
        this.renderBackground(0);
    }

    public void renderBackground(int n) {
        if (this.minecraft.field_1687 != null) {
            this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        } else {
            this.renderDirtBackground(n);
        }
    }

    public void renderDirtBackground(int n) {
        GlStateManager.disableLighting();
        GlStateManager.disableFog();
        class_289 class_28910 = class_289.method_1348();
        class_287 \u26032 = class_28910.method_1349();
        this.minecraft.method_1531().method_4618(BACKGROUND_LOCATION);
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        float \u26033 = 32.0f;
        \u26032.method_1328(7, class_290.field_1575);
        \u26032.method_1315(0.0, this.height, 0.0).method_1312(0.0, (float)this.height / 32.0f + (float)n).method_1323(64, 64, 64, 255).method_1344();
        \u26032.method_1315(this.width, this.height, 0.0).method_1312((float)this.width / 32.0f, (float)this.height / 32.0f + (float)n).method_1323(64, 64, 64, 255).method_1344();
        \u26032.method_1315(this.width, 0.0, 0.0).method_1312((float)this.width / 32.0f, n).method_1323(64, 64, 64, 255).method_1344();
        \u26032.method_1315(0.0, 0.0, 0.0).method_1312(0.0, n).method_1323(64, 64, 64, 255).method_1344();
        class_28910.method_1350();
    }

    public boolean isPauseScreen() {
        return true;
    }

    private void confirmLink(boolean bl) {
        if (bl) {
            this.openLink(this.clickedLink);
        }
        this.clickedLink = null;
        this.minecraft.method_1507(this);
    }

    private void openLink(URI uRI) {
        class_156.method_668().method_673(uRI);
    }

    public static boolean hasControlDown() {
        if (class_310.field_1703) {
            return class_3675.method_15987(class_310.method_1551().field_1704.method_4490(), 343) || class_3675.method_15987(class_310.method_1551().field_1704.method_4490(), 347);
        }
        return class_3675.method_15987(class_310.method_1551().field_1704.method_4490(), 341) || class_3675.method_15987(class_310.method_1551().field_1704.method_4490(), 345);
    }

    public static boolean hasShiftDown() {
        return class_3675.method_15987(class_310.method_1551().field_1704.method_4490(), 340) || class_3675.method_15987(class_310.method_1551().field_1704.method_4490(), 344);
    }

    public static boolean hasAltDown() {
        return class_3675.method_15987(class_310.method_1551().field_1704.method_4490(), 342) || class_3675.method_15987(class_310.method_1551().field_1704.method_4490(), 346);
    }

    public static boolean isCut(int n) {
        return n == 88 && class_437.hasControlDown() && !class_437.hasShiftDown() && !class_437.hasAltDown();
    }

    public static boolean isPaste(int n) {
        return n == 86 && class_437.hasControlDown() && !class_437.hasShiftDown() && !class_437.hasAltDown();
    }

    public static boolean isCopy(int n) {
        return n == 67 && class_437.hasControlDown() && !class_437.hasShiftDown() && !class_437.hasAltDown();
    }

    public static boolean isSelectAll(int n) {
        return n == 65 && class_437.hasControlDown() && !class_437.hasShiftDown() && !class_437.hasAltDown();
    }

    public void resize(class_310 class_31010, int n, int n2) {
        this.init(class_31010, n, n2);
    }

    public static void wrapScreenError(Runnable runnable, String string, String string2) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            class_128 class_12810 = class_128.method_560(throwable, string);
            class_129 \u26032 = class_12810.method_562("Affected screen");
            \u26032.method_577("Screen name", () -> string2);
            throw new class_148(class_12810);
        }
    }

    protected boolean isValidCharacterForName(String string, char c, int n) {
        \u2603 = string.indexOf(58);
        \u2603 = string.indexOf(47);
        if (c == ':') {
            return (\u2603 == -1 || n <= \u2603) && \u2603 == -1;
        }
        if (c == '/') {
            return n > \u2603;
        }
        return c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.';
    }

    @Override
    public boolean isMouseOver(double d, double d2) {
        return true;
    }
}

