/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import com.mojang.authlib.GameProfile;
import com.mojang.util.UUIDTypeAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.Proxy;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1934;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2556;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_333;
import net.minecraft.class_442;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.RepeatedNarrator;

public class Realms {
    private static final RepeatedNarrator REPEATED_NARRATOR = new RepeatedNarrator(Duration.ofSeconds(5L));

    public static boolean isTouchScreen() {
        return class_310.method_1551().field_1690.field_1854;
    }

    public static Proxy getProxy() {
        return class_310.method_1551().method_1487();
    }

    public static String sessionId() {
        class_320 class_32010 = class_310.method_1551().method_1548();
        if (class_32010 == null) {
            return null;
        }
        return class_32010.method_1675();
    }

    public static String userName() {
        class_320 class_32010 = class_310.method_1551().method_1548();
        if (class_32010 == null) {
            return null;
        }
        return class_32010.method_1676();
    }

    public static long currentTimeMillis() {
        return class_156.method_658();
    }

    public static String getSessionId() {
        return class_310.method_1551().method_1548().method_1675();
    }

    public static String getUUID() {
        return class_310.method_1551().method_1548().method_1673();
    }

    public static String getName() {
        return class_310.method_1551().method_1548().method_1676();
    }

    public static String uuidToName(String string) {
        return class_310.method_1551().method_1495().fillProfileProperties(new GameProfile(UUIDTypeAdapter.fromString((String)string), null), false).getName();
    }

    public static <V> CompletableFuture<V> execute(Supplier<V> supplier) {
        return class_310.method_1551().method_5385(supplier);
    }

    public static void execute(Runnable runnable) {
        class_310.method_1551().execute(runnable);
    }

    public static void setScreen(RealmsScreen realmsScreen) {
        Realms.execute(() -> {
            Realms.setScreenDirect(realmsScreen);
            return null;
        });
    }

    public static void setScreenDirect(RealmsScreen realmsScreen) {
        class_310.method_1551().method_1507(realmsScreen.getProxy());
    }

    public static String getGameDirectoryPath() {
        return class_310.method_1551().field_1697.getAbsolutePath();
    }

    public static int survivalId() {
        return class_1934.field_9215.method_8379();
    }

    public static int creativeId() {
        return class_1934.field_9220.method_8379();
    }

    public static int adventureId() {
        return class_1934.field_9216.method_8379();
    }

    public static int spectatorId() {
        return class_1934.field_9219.method_8379();
    }

    public static void setConnectedToRealms(boolean bl) {
        class_310.method_1551().method_1537(bl);
    }

    public static CompletableFuture<?> downloadResourcePack(String string, String string2) {
        return class_310.method_1551().method_1516().method_4640(string, string2);
    }

    public static void clearResourcePack() {
        class_310.method_1551().method_1516().method_4642();
    }

    public static boolean getRealmsNotificationsEnabled() {
        return class_310.method_1551().field_1690.field_1830;
    }

    public static boolean inTitleScreen() {
        return class_310.method_1551().field_1755 != null && class_310.method_1551().field_1755 instanceof class_442;
    }

    public static void deletePlayerTag(File file) {
        if (file.exists()) {
            try {
                class_2487 class_24872 = class_2507.method_10629(new FileInputStream(file));
                \u2603 = class_24872.method_10562("Data");
                \u2603.method_10551("Player");
                class_2507.method_10634(class_24872, new FileOutputStream(file));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void openUri(String string) {
        class_156.method_668().method_670(string);
    }

    public static void setClipboard(String string) {
        class_310.method_1551().field_1774.method_1455(string);
    }

    public static String getMinecraftVersionString() {
        return class_155.method_16673().getName();
    }

    public static class_2960 resourceLocation(String string) {
        return new class_2960(string);
    }

    public static String getLocalizedString(String string, Object ... objectArray) {
        return class_1074.method_4662(string, objectArray);
    }

    public static void bind(String string) {
        class_2960 class_29602 = new class_2960(string);
        class_310.method_1551().method_1531().method_4618(class_29602);
    }

    public static void narrateNow(String string) {
        class_333 class_3338 = class_333.field_2054;
        class_3338.method_1793();
        class_3338.method_1794(class_2556.field_11735, new class_2585(Realms.fixNarrationNewlines(string)));
    }

    private static String fixNarrationNewlines(String string) {
        return string.replace("\\n", System.lineSeparator());
    }

    public static void narrateNow(String ... stringArray) {
        Realms.narrateNow(Arrays.asList(stringArray));
    }

    public static void narrateNow(Iterable<String> iterable) {
        Realms.narrateNow(Realms.joinNarrations(iterable));
    }

    public static String joinNarrations(Iterable<String> iterable) {
        return String.join((CharSequence)System.lineSeparator(), iterable);
    }

    public static void narrateRepeatedly(String string) {
        REPEATED_NARRATOR.narrate(Realms.fixNarrationNewlines(string));
    }
}

