/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import com.mojang.datafixers.util.Either;
import java.lang.reflect.Constructor;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_155;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_403;
import net.minecraft.class_437;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.RealmsScreenProxy;
import net.minecraft.realms.pluginapi.LoadedRealmsPlugin;
import net.minecraft.realms.pluginapi.RealmsPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsBridge
extends RealmsScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private class_437 previousScreen;

    public void switchToRealms(class_437 class_4372) {
        this.previousScreen = class_4372;
        Optional<LoadedRealmsPlugin> optional = this.tryLoadRealms();
        if (optional.isPresent()) {
            Realms.setScreen(optional.get().getMainScreen(this));
        } else {
            this.showMissingRealmsErrorScreen();
        }
    }

    @Nullable
    public RealmsScreenProxy getNotificationScreen(class_437 class_4372) {
        this.previousScreen = class_4372;
        return this.tryLoadRealms().map(loadedRealmsPlugin -> loadedRealmsPlugin.getNotificationsScreen(this).getProxy()).orElse(null);
    }

    private Optional<LoadedRealmsPlugin> tryLoadRealms() {
        try {
            Class<?> clazz = Class.forName("com.mojang.realmsclient.plugin.RealmsPluginImpl");
            Constructor<?> \u26032 = clazz.getDeclaredConstructor(new Class[0]);
            \u26032.setAccessible(true);
            Object \u26033 = \u26032.newInstance(new Object[0]);
            RealmsPlugin \u26034 = (RealmsPlugin)\u26033;
            Either<LoadedRealmsPlugin, String> \u26035 = \u26034.tryLoad(Realms.getMinecraftVersionString());
            Optional \u26036 = \u26035.right();
            if (\u26036.isPresent()) {
                LOGGER.error("Failed to load Realms module: {}", \u26036.get());
                return Optional.empty();
            }
            return \u26035.left();
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error("Realms module missing");
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load Realms module", (Throwable)exception);
        }
        return Optional.empty();
    }

    @Override
    public void init() {
        class_310.method_1551().method_1507(this.previousScreen);
    }

    private void showMissingRealmsErrorScreen() {
        class_310.method_1551().method_1507(new class_403(() -> class_310.method_1551().method_1507(this.previousScreen), new class_2585(""), new class_2588(class_155.method_16673().isStable() ? "realms.missing.module.error.text" : "realms.missing.snapshot.error.text", new Object[0])));
    }
}

