/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.realms.AbstractRealmsButton;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsAbstractButtonProxy;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsGuiEventListener;
import net.minecraft.realms.RealmsLabelProxy;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsScreenProxy
extends class_437 {
    private final RealmsScreen screen;
    private static final Logger LOGGER = LogManager.getLogger();

    public RealmsScreenProxy(RealmsScreen realmsScreen) {
        super(class_333.field_18967);
        this.screen = realmsScreen;
    }

    public RealmsScreen getScreen() {
        return this.screen;
    }

    @Override
    public void init(class_310 class_31010, int n, int n2) {
        this.screen.init(class_31010, n, n2);
        super.init(class_31010, n, n2);
    }

    @Override
    public void init() {
        this.screen.init();
        super.init();
    }

    public void drawCenteredString(String string, int n, int n2, int n3) {
        super.drawCenteredString(this.font, string, n, n2, n3);
    }

    public void drawString(String string, int n, int n2, int n3, boolean bl) {
        if (bl) {
            super.drawString(this.font, string, n, n2, n3);
        } else {
            this.font.method_1729(string, n, n2, n3);
        }
    }

    @Override
    public void blit(int n, int n2, int n3, int n4, int n5, int n6) {
        this.screen.blit(n, n2, n3, n4, n5, n6);
        super.blit(n, n2, n3, n4, n5, n6);
    }

    public static void blit(int n, int n2, float f, float f2, int n3, int n4, int n5, int n6, int n7, int n8) {
        class_332.blit(n, n2, n5, n6, f, f2, n3, n4, n7, n8);
    }

    public static void blit(int n, int n2, float f, float f2, int n3, int n4, int n5, int n6) {
        class_332.blit(n, n2, f, f2, n3, n4, n5, n6);
    }

    @Override
    public void fillGradient(int n, int n2, int n3, int n4, int n5, int n6) {
        super.fillGradient(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void renderBackground() {
        super.renderBackground();
    }

    @Override
    public boolean isPauseScreen() {
        return super.isPauseScreen();
    }

    @Override
    public void renderBackground(int n) {
        super.renderBackground(n);
    }

    @Override
    public void render(int n, int n2, float f) {
        this.screen.render(n, n2, f);
    }

    @Override
    public void renderTooltip(class_1799 class_17992, int n, int n2) {
        super.renderTooltip(class_17992, n, n2);
    }

    @Override
    public void renderTooltip(String string, int n, int n2) {
        super.renderTooltip(string, n, n2);
    }

    @Override
    public void renderTooltip(List<String> list, int n, int n2) {
        super.renderTooltip(list, n, n2);
    }

    @Override
    public void tick() {
        this.screen.tick();
        super.tick();
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int fontLineHeight() {
        return this.font.field_2000;
    }

    public int fontWidth(String string) {
        return this.font.method_1727(string);
    }

    public void fontDrawShadow(String string, int n, int n2, int n3) {
        this.font.method_1720(string, n, n2, n3);
    }

    public List<String> fontSplit(String string, int n) {
        return this.font.method_1728(string, n);
    }

    public void childrenClear() {
        this.children.clear();
    }

    public void addWidget(RealmsGuiEventListener realmsGuiEventListener) {
        if (this.hasWidget(realmsGuiEventListener) || !this.children.add(realmsGuiEventListener.getProxy())) {
            LOGGER.error("Tried to add the same widget multiple times: " + realmsGuiEventListener);
        }
    }

    public void narrateLabels() {
        List<String> list = this.children.stream().filter(class_36410 -> class_36410 instanceof RealmsLabelProxy).map(class_36410 -> ((RealmsLabelProxy)class_36410).getLabel().getText()).collect(Collectors.toList());
        Realms.narrateNow(list);
    }

    public void removeWidget(RealmsGuiEventListener realmsGuiEventListener) {
        if (!this.hasWidget(realmsGuiEventListener) || !this.children.remove(realmsGuiEventListener.getProxy())) {
            LOGGER.error("Tried to add the same widget multiple times: " + realmsGuiEventListener);
        }
    }

    public boolean hasWidget(RealmsGuiEventListener realmsGuiEventListener) {
        return this.children.contains(realmsGuiEventListener.getProxy());
    }

    public void buttonsAdd(AbstractRealmsButton<?> abstractRealmsButton) {
        this.addButton(abstractRealmsButton.getProxy());
    }

    public List<AbstractRealmsButton<?>> buttons() {
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)this.buttons.size());
        for (class_339 class_33910 : this.buttons) {
            arrayList.add(((RealmsAbstractButtonProxy)((Object)class_33910)).getButton());
        }
        return arrayList;
    }

    public void buttonsClear() {
        HashSet hashSet = Sets.newHashSet((Iterable)this.buttons);
        this.children.removeIf(hashSet::contains);
        this.buttons.clear();
    }

    public void removeButton(RealmsButton realmsButton) {
        this.children.remove(realmsButton.getProxy());
        this.buttons.remove(realmsButton.getProxy());
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        if (this.screen.mouseClicked(d, d2, n)) {
            return true;
        }
        return super.mouseClicked(d, d2, n);
    }

    @Override
    public boolean mouseReleased(double d, double d2, int n) {
        return this.screen.mouseReleased(d, d2, n);
    }

    @Override
    public boolean mouseDragged(double d, double d2, int n, double d3, double d4) {
        if (this.screen.mouseDragged(d, d2, n, d3, d4)) {
            return true;
        }
        return super.mouseDragged(d, d2, n, d3, d4);
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (this.screen.keyPressed(n, n2, n3)) {
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    @Override
    public boolean charTyped(char c, int n) {
        if (this.screen.charTyped(c, n)) {
            return true;
        }
        return super.charTyped(c, n);
    }

    @Override
    public void removed() {
        this.screen.removed();
        super.removed();
    }

    public int draw(String string, int n, int n2, int n3, boolean bl) {
        if (bl) {
            return this.font.method_1720(string, n, n2, n3);
        }
        return this.font.method_1729(string, n, n2, n3);
    }

    public class_327 getFont() {
        return this.font;
    }
}

