/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.class_1257;
import net.minecraft.class_1267;
import net.minecraft.class_1276;
import net.minecraft.class_1279;
import net.minecraft.class_128;
import net.minecraft.class_140;
import net.minecraft.class_148;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_16;
import net.minecraft.class_1657;
import net.minecraft.class_1863;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1932;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_1939;
import net.minecraft.class_1940;
import net.minecraft.class_1942;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_26;
import net.minecraft.class_2632;
import net.minecraft.class_273;
import net.minecraft.class_2761;
import net.minecraft.class_2874;
import net.minecraft.class_29;
import net.minecraft.class_2926;
import net.minecraft.class_2966;
import net.minecraft.class_2981;
import net.minecraft.class_2989;
import net.minecraft.class_2991;
import net.minecraft.class_2995;
import net.minecraft.class_3004;
import net.minecraft.class_31;
import net.minecraft.class_3176;
import net.minecraft.class_32;
import net.minecraft.class_3202;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3242;
import net.minecraft.class_3264;
import net.minecraft.class_3279;
import net.minecraft.class_3283;
import net.minecraft.class_3286;
import net.minecraft.class_3288;
import net.minecraft.class_3296;
import net.minecraft.class_3304;
import net.minecraft.class_3312;
import net.minecraft.class_3324;
import net.minecraft.class_3327;
import net.minecraft.class_3337;
import net.minecraft.class_3505;
import net.minecraft.class_3517;
import net.minecraft.class_3532;
import net.minecraft.class_3536;
import net.minecraft.class_3551;
import net.minecraft.class_3689;
import net.minecraft.class_3695;
import net.minecraft.class_3738;
import net.minecraft.class_3807;
import net.minecraft.class_3902;
import net.minecraft.class_3949;
import net.minecraft.class_3950;
import net.minecraft.class_3951;
import net.minecraft.class_4093;
import net.minecraft.class_60;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends class_4093<class_3738>
implements class_1279,
class_2165,
AutoCloseable,
Runnable {
    private static final Logger field_4546 = LogManager.getLogger();
    public static final File field_4588 = new File("usercache.json");
    public static final class_1940 field_17704 = new class_1940("North Carolina".hashCode(), class_1934.field_9215, true, false, class_1942.field_9265).method_8575();
    private final class_32 field_4606;
    private final class_1276 field_4582 = new class_1276("server", this, class_156.method_658());
    private final File field_4605;
    private final List<Runnable> field_4568 = Lists.newArrayList();
    private final class_3689 field_16258 = new class_3689(this::method_3780);
    private final class_3242 field_4563;
    protected final class_3950 field_17439;
    private final class_2926 field_4593 = new class_2926();
    private final Random field_4602 = new Random();
    private final DataFixer field_4587;
    private String field_4585;
    private int field_4555 = -1;
    private final Map<class_2874, class_3218> field_4589 = Maps.newIdentityHashMap();
    private class_3324 field_4550;
    private volatile boolean field_4544 = true;
    private boolean field_4561;
    private int field_4572;
    protected final Proxy field_4599;
    private boolean field_4543;
    private boolean field_4560;
    private boolean field_4575;
    private boolean field_4590;
    private boolean field_4604;
    private boolean field_4554;
    @Nullable
    private String field_4564;
    private int field_4579;
    private int field_4596;
    public final long[] field_4573 = new long[100];
    protected final Map<class_2874, long[]> field_4600 = Maps.newIdentityHashMap();
    @Nullable
    private KeyPair field_4552;
    @Nullable
    private String field_4578;
    private final String field_4565;
    @Nullable
    private String field_4574;
    private boolean field_4549;
    private boolean field_4569;
    private String field_4607 = "";
    private String field_4584 = "";
    private volatile boolean field_4547;
    private long field_4557;
    @Nullable
    private class_2561 field_4601;
    private boolean field_4597;
    private boolean field_4545;
    @Nullable
    private final YggdrasilAuthenticationService field_4594;
    private final MinecraftSessionService field_4603;
    private final GameProfileRepository field_4608;
    private final class_3312 field_4556;
    private long field_4551;
    protected final Thread field_16257 = class_156.method_654(new Thread((Runnable)this, "Server thread"), thread2 -> thread2.setUncaughtExceptionHandler((thread, throwable) -> field_4546.error((Object)throwable)));
    private long field_4571 = class_156.method_658();
    private long field_19248;
    private boolean field_19249;
    private boolean field_4577;
    private final class_3296 field_4576 = new class_3304(class_3264.field_14190, this.field_16257);
    private final class_3283<class_3288> field_4595 = new class_3283<class_3288>(class_3288::new);
    @Nullable
    private class_3279 field_4553;
    private final class_2170 field_4562;
    private final class_1863 field_4566 = new class_1863();
    private final class_3505 field_4583 = new class_3505();
    private final class_2995 field_4558 = new class_2995(this);
    private final class_3004 field_4548 = new class_3004(this);
    private final class_60 field_4580 = new class_60();
    private final class_2989 field_4567 = new class_2989();
    private final class_2991 field_4591 = new class_2991(this);
    private final class_3517 field_16205 = new class_3517();
    private boolean field_4570;
    private boolean field_4586;
    private boolean field_19237;
    private float field_4592;
    private final Executor field_17200;
    @Nullable
    private String field_17601;

    public MinecraftServer(File file, Proxy proxy, DataFixer dataFixer, class_2170 class_21702, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, class_3312 class_33122, class_3950 class_39502, String string) {
        super("Server");
        this.field_4599 = proxy;
        this.field_4562 = class_21702;
        this.field_4594 = yggdrasilAuthenticationService;
        this.field_4603 = minecraftSessionService;
        this.field_4608 = gameProfileRepository;
        this.field_4556 = class_33122;
        this.field_4605 = file;
        this.field_4563 = new class_3242(this);
        this.field_17439 = class_39502;
        this.field_4606 = new class_32(file.toPath(), file.toPath().resolve("../backups"), dataFixer);
        this.field_4587 = dataFixer;
        this.field_4576.method_14477(this.field_4583);
        this.field_4576.method_14477(this.field_4566);
        this.field_4576.method_14477(this.field_4580);
        this.field_4576.method_14477(this.field_4591);
        this.field_4576.method_14477(this.field_4567);
        this.field_17200 = class_156.method_18349();
        this.field_4565 = string;
    }

    private void method_17976(class_26 class_264) {
        class_273 class_2732 = class_264.method_17924(class_273::new, "scoreboard");
        class_2732.method_1218(this.method_3845());
        this.method_3845().method_12935(new class_16(class_2732));
    }

    protected abstract boolean method_3823() throws IOException;

    protected void method_3755(String string) {
        if (this.method_3781().method_244(string)) {
            field_4546.info("Converting map!");
            this.method_3768(new class_2588("menu.convertingLevel", new Object[0]));
            this.method_3781().method_17927(string, new class_3536(){
                private long field_4609 = class_156.method_658();

                @Override
                public void method_15412(class_2561 class_25612) {
                }

                @Override
                public void method_15413(class_2561 class_25612) {
                }

                @Override
                public void method_15410(int n) {
                    if (class_156.method_658() - this.field_4609 >= 1000L) {
                        this.field_4609 = class_156.method_658();
                        field_4546.info("Converting... {}%", (Object)n);
                    }
                }

                @Override
                public void method_15411() {
                }

                @Override
                public void method_15414(class_2561 class_25612) {
                }
            });
        }
        if (this.field_4586) {
            field_4546.info("Forcing world upgrade!");
            class_31 class_3180 = this.method_3781().method_231(this.method_3865());
            if (class_3180 != null) {
                class_1257 class_12572 = new class_1257(this.method_3865(), this.method_3781(), class_3180, this.field_19237);
                class_2561 \u26032 = null;
                while (!class_12572.method_5403()) {
                    class_2561 class_25612 = class_12572.method_5394();
                    if (\u26032 != class_25612) {
                        \u26032 = class_25612;
                        field_4546.info(class_12572.method_5394().getString());
                    }
                    if ((\u2603 = class_12572.method_5397()) > 0) {
                        int n = class_12572.method_5400() + class_12572.method_5399();
                        field_4546.info("{}% completed ({} / {} chunks)...", (Object)class_3532.method_15375((float)n / (float)\u2603 * 100.0f), (Object)n, (Object)\u2603);
                    }
                    if (this.method_3750()) {
                        class_12572.method_5402();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected synchronized void method_3768(class_2561 class_25612) {
        this.field_4601 = class_25612;
    }

    protected void method_3735(String string, String string2, long l2, class_1942 class_19422, JsonElement jsonElement) {
        class_1940 \u26033;
        this.method_3755(string);
        this.method_3768(new class_2588("menu.loadingLevel", new Object[0]));
        class_29 class_295 = this.method_3781().method_242(string, this);
        this.method_3861(this.method_3865(), class_295);
        class_31 \u26032 = class_295.method_133();
        if (\u26032 == null) {
            if (this.method_3799()) {
                \u26033 = field_17704;
            } else {
                long l2;
                \u26033 = new class_1940(l2, this.method_3790(), this.method_3792(), this.method_3754(), class_19422);
                \u26033.method_8579(jsonElement);
                if (this.field_4569) {
                    \u26033.method_8575();
                }
            }
            \u26032 = new class_31(\u26033, string2);
        } else {
            \u26032.method_182(string2);
            \u26033 = new class_1940(\u26032);
        }
        this.method_3800(class_295.method_132(), \u26032);
        class_3949 class_39492 = this.field_17439.create(11);
        this.method_3786(class_295, \u26032, \u26033, class_39492);
        this.method_3776(this.method_3722(), true);
        this.method_3774(class_39492);
    }

    protected void method_3786(class_29 class_295, class_31 class_31802, class_1940 class_19402, class_3949 class_39492) {
        class_3218 class_32182;
        if (this.method_3799()) {
            class_31802.method_140(field_17704);
        }
        class_3218 class_32183 = new class_3218(this, this.field_17200, class_295, class_31802, class_2874.field_13072, this.field_16258, class_39492);
        this.field_4589.put(class_2874.field_13072, class_32183);
        this.method_17976(class_32183.method_17983());
        class_32183.method_8621().method_17905(class_31802);
        class_32182 = this.method_3847(class_2874.field_13072);
        if (!class_31802.method_222()) {
            class_31 class_31802;
            try {
                class_32182.method_8414(class_19402);
                if (class_31802.method_153() == class_1942.field_9266) {
                    this.method_17977(class_31802);
                }
                class_31802.method_223(true);
            }
            catch (Throwable throwable) {
                class_128 class_12810 = class_128.method_560(throwable, "Exception initializing level");
                try {
                    class_32182.method_8538(class_12810);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new class_148(class_12810);
            }
            class_31802.method_223(true);
        }
        this.method_3760().method_14591(class_32182);
        if (class_31802.method_228() != null) {
            this.method_3837().method_12972(class_31802.method_228());
        }
        for (class_2874 class_28742 : class_2874.method_12482()) {
            if (class_28742 == class_2874.field_13072) continue;
            this.field_4589.put(class_28742, new class_3202(class_32182, this, this.field_17200, class_295, class_28742, (class_3695)this.field_16258, class_39492));
        }
    }

    private void method_17977(class_31 class_3180) {
        class_3180.method_196(false);
        class_3180.method_211(true);
        class_3180.method_157(false);
        class_3180.method_147(false);
        class_3180.method_167(1000000000);
        class_3180.method_165(6000L);
        class_3180.method_193(class_1934.field_9219);
        class_3180.method_198(false);
        class_3180.method_208(class_1267.field_5801);
        class_3180.method_186(true);
        class_3180.method_146().method_8359("doDaylightCycle", "false", this);
    }

    protected void method_3800(File file, class_31 class_3180) {
        this.field_4595.method_14443(new class_3286());
        this.field_4553 = new class_3279(new File(file, "datapacks"));
        this.field_4595.method_14443(this.field_4553);
        this.field_4595.method_14445();
        ArrayList arrayList = Lists.newArrayList();
        for (String string : class_3180.method_179()) {
            class_3288 class_32882 = this.field_4595.method_14449(string);
            if (class_32882 != null) {
                arrayList.add(class_32882);
                continue;
            }
            field_4546.warn("Missing data pack {}", (Object)string);
        }
        this.field_4595.method_14447(arrayList);
        this.method_3752(class_3180);
    }

    protected void method_3774(class_3949 class_39492) {
        this.method_3768(new class_2588("menu.generatingTerrain", new Object[0]));
        class_3218 class_32182 = this.method_3847(class_2874.field_13072);
        field_4546.info("Preparing start region for dimension " + class_2874.method_12485(class_32182.field_9247.method_12460()));
        class_2338 \u26032 = class_32182.method_8395();
        class_39492.method_17669(new class_1923(\u26032));
        class_3215 \u26033 = class_32182.method_14178();
        \u26033.method_17293().method_17304(500);
        this.field_4571 = class_156.method_658();
        \u26033.method_17297(class_3230.field_14030, new class_1923(\u26032), 11, class_3902.field_17274);
        while (\u26033.method_17301() != 441) {
            this.field_4571 = class_156.method_658() + 10L;
            this.method_16208();
        }
        this.field_4571 = class_156.method_658() + 10L;
        this.method_16208();
        for (class_2874 class_28742 : class_2874.method_12482()) {
            class_1932 class_19322 = this.method_3847(class_28742).method_17983().method_120(class_1932::new, "chunks");
            if (class_19322 == null) continue;
            class_3218 \u26034 = this.method_3847(class_28742);
            LongIterator \u26035 = class_19322.method_8375().iterator();
            while (\u26035.hasNext()) {
                long l = \u26035.nextLong();
                class_1923 \u26036 = new class_1923(l);
                \u26034.method_14178().method_12124(\u26036, true);
            }
        }
        this.field_4571 = class_156.method_658() + 10L;
        this.method_16208();
        class_39492.method_17671();
        \u26033.method_17293().method_17304(5);
    }

    protected void method_3861(String string, class_29 class_295) {
        File file = new File(class_295.method_132(), "resources.zip");
        if (file.isFile()) {
            try {
                this.method_3843("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                field_4546.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public abstract boolean method_3792();

    public abstract class_1934 method_3790();

    public abstract class_1267 method_3722();

    public abstract boolean method_3754();

    public abstract int method_3798();

    public abstract boolean method_3732();

    public boolean method_3723(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        for (class_3218 class_32182 : this.method_3738()) {
            if (!bl) {
                field_4546.info("Saving chunks for level '{}'/{}", (Object)class_32182.method_8401().method_150(), (Object)class_2874.method_12485(class_32182.field_9247.method_12460()));
            }
            try {
                class_32182.method_14176(null, bl2, class_32182.field_13957 && !bl3);
            }
            catch (class_1939 class_19392) {
                field_4546.warn(class_19392.getMessage());
            }
            bl4 = true;
        }
        class_3218 class_32182 = this.method_3847(class_2874.field_13072);
        class_31 class_3180 = class_32182.method_8401();
        class_32182.method_8621().method_17904(class_3180);
        class_3180.method_221(this.method_3837().method_12974());
        class_32182.method_17982().method_131(class_3180, this.method_3760().method_14567());
        return bl4;
    }

    @Override
    public void close() {
        this.method_3782();
    }

    protected void method_3782() {
        field_4546.info("Stopping server");
        if (this.method_3787() != null) {
            this.method_3787().method_14356();
        }
        if (this.field_4550 != null) {
            field_4546.info("Saving players");
            this.field_4550.method_14617();
            this.field_4550.method_14597();
        }
        field_4546.info("Saving worlds");
        for (class_3218 class_32182 : this.method_3738()) {
            if (class_32182 == null) continue;
            class_32182.field_13957 = false;
        }
        this.method_3723(false, true, false);
        for (class_3218 class_32182 : this.method_3738()) {
            if (class_32182 == null) continue;
            try {
                class_32182.close();
            }
            catch (IOException iOException) {
                field_4546.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.field_4582.method_5483()) {
            this.field_4582.method_5487();
        }
    }

    public String method_3819() {
        return this.field_4585;
    }

    public void method_3842(String string) {
        this.field_4585 = string;
    }

    public boolean method_3806() {
        return this.field_4544;
    }

    public void method_3747(boolean bl) {
        this.field_4544 = false;
        if (bl) {
            try {
                this.field_16257.join();
            }
            catch (InterruptedException interruptedException) {
                field_4546.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.method_3823()) {
                this.field_4571 = class_156.method_658();
                this.field_4593.method_12684(new class_2585(this.field_4564));
                this.field_4593.method_12679(new class_2926.class_2930(class_155.method_16673().getName(), class_155.method_16673().getProtocolVersion()));
                this.method_3791(this.field_4593);
                while (this.field_4544) {
                    long l = class_156.method_658() - this.field_4571;
                    if (l > 2000L && this.field_4571 - this.field_4557 >= 15000L) {
                        \u2603 = l / 50L;
                        field_4546.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l, (Object)\u2603);
                        this.field_4571 += \u2603 * 50L;
                        this.field_4557 = this.field_4571;
                    }
                    this.field_4571 += 50L;
                    if (this.field_4597) {
                        this.field_4597 = false;
                        this.field_16258.method_16055().method_16060();
                    }
                    this.field_16258.method_16065();
                    this.field_16258.method_15396("tick");
                    this.method_3748(this::method_3866);
                    this.field_16258.method_15405("nextTickWait");
                    this.field_19249 = true;
                    this.field_19248 = Math.max(class_156.method_658() + 50L, this.field_4571);
                    this.method_16208();
                    this.field_16258.method_15407();
                    this.field_16258.method_16066();
                    this.field_4547 = true;
                }
            } else {
                this.method_3744(null);
            }
        }
        catch (Throwable throwable) {
            field_4546.error("Encountered an unexpected exception", throwable);
            class_128 class_12810 = throwable instanceof class_148 ? this.method_3859(((class_148)throwable).method_631()) : this.method_3859(new class_128("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.method_3831(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (class_12810.method_569(\u26032)) {
                field_4546.error("This crash report has been saved to: {}", (Object)\u26032.getAbsolutePath());
            } else {
                field_4546.error("We were unable to save this crash report to disk.");
            }
            this.method_3744(class_12810);
        }
        finally {
            try {
                this.field_4561 = true;
                this.method_3782();
            }
            catch (Throwable \u26033) {
                field_4546.error("Exception stopping the server", \u26033);
            }
            finally {
                this.method_3821();
            }
        }
    }

    private boolean method_3866() {
        return this.method_18860() || class_156.method_658() < (this.field_19249 ? this.field_19248 : this.field_4571);
    }

    protected void method_16208() {
        this.method_5383();
        this.method_18857(() -> !this.method_3866());
    }

    protected class_3738 method_16209(Runnable runnable) {
        return new class_3738(this.field_4572, runnable);
    }

    protected boolean method_19464(class_3738 class_37382) {
        return class_37382.method_16338() + 3 < this.field_4572 || this.method_3866();
    }

    @Override
    public boolean method_16075() {
        boolean bl;
        this.field_19249 = bl = this.method_20415();
        return bl;
    }

    private boolean method_20415() {
        if (super.method_16075()) {
            return true;
        }
        if (this.method_3866()) {
            for (class_3218 class_32182 : this.method_3738()) {
                if (!class_32182.method_14178().method_19492()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_3791(class_2926 class_29262) {
        File file = this.method_3758("server-icon.png");
        if (!file.exists()) {
            file = this.method_3781().method_239(this.method_3865(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                class_29262.method_12677("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                field_4546.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public boolean method_3771() {
        this.field_4577 = this.field_4577 || this.method_3725().isFile();
        return this.field_4577;
    }

    public File method_3725() {
        return this.method_3781().method_239(this.method_3865(), "icon.png");
    }

    public File method_3831() {
        return new File(".");
    }

    protected void method_3744(class_128 class_12810) {
    }

    protected void method_3821() {
    }

    protected void method_3748(BooleanSupplier booleanSupplier) {
        long l = class_156.method_648();
        ++this.field_4572;
        this.method_3813(booleanSupplier);
        if (l - this.field_4551 >= 5000000000L) {
            this.field_4551 = l;
            this.field_4593.method_12681(new class_2926.class_2927(this.method_3802(), this.method_3788()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.method_3788(), 12)];
            int \u26032 = class_3532.method_15395(this.field_4602, 0, this.method_3788() - gameProfileArray.length);
            for (int i = 0; i < gameProfileArray.length; ++i) {
                gameProfileArray[i] = this.field_4550.method_14571().get(\u26032 + i).method_7334();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.field_4593.method_12682().method_12686(gameProfileArray);
        }
        if (this.field_4572 % 6000 == 0) {
            field_4546.debug("Autosave started");
            this.field_16258.method_15396("save");
            this.field_4550.method_14617();
            this.method_3723(true, false, false);
            this.field_16258.method_15407();
            field_4546.debug("Autosave finished");
        }
        this.field_16258.method_15396("snooper");
        if (!this.field_4582.method_5483() && this.field_4572 > 100) {
            this.field_4582.method_5482();
        }
        if (this.field_4572 % 6000 == 0) {
            this.field_4582.method_5485();
        }
        this.field_16258.method_15407();
        this.field_16258.method_15396("tallying");
        long l2 = class_156.method_648() - l;
        this.field_4573[this.field_4572 % 100] = l2;
        \u2603 = l2;
        this.field_4592 = this.field_4592 * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        \u2603 = class_156.method_648();
        this.field_16205.method_15247(\u2603 - l);
        this.field_16258.method_15407();
    }

    protected void method_3813(BooleanSupplier booleanSupplier) {
        this.field_16258.method_15396("commandFunctions");
        this.method_3740().method_18699();
        this.field_16258.method_15405("levels");
        for (class_3218 class_32182 : this.method_3738()) {
            long l = class_156.method_648();
            if (class_32182.field_9247.method_12460() == class_2874.field_13072 || this.method_3839()) {
                this.field_16258.method_15400(() -> class_32182.method_8401().method_150() + " " + class_2378.field_11155.method_10221(class_32182.field_9247.method_12460()));
                if (this.field_4572 % 20 == 0) {
                    this.field_16258.method_15396("timeSync");
                    this.field_4550.method_14589(new class_2761(class_32182.method_8510(), class_32182.method_8532(), class_32182.method_8450().method_8355("doDaylightCycle")), class_32182.field_9247.method_12460());
                    this.field_16258.method_15407();
                }
                this.field_16258.method_15396("tick");
                try {
                    class_32182.method_18765(booleanSupplier);
                }
                catch (Throwable throwable) {
                    class_128 class_12810 = class_128.method_560(throwable, "Exception ticking world");
                    class_32182.method_8538(class_12810);
                    throw new class_148(class_12810);
                }
                this.field_16258.method_15407();
                this.field_16258.method_15407();
            }
            this.field_4600.computeIfAbsent((class_2874)class_32182.field_9247.method_12460(), (Function<class_2874, long[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, method_3757(net.minecraft.class_2874 ), (Lnet/minecraft/class_2874;)[J)())[this.field_4572 % 100] = class_156.method_648() - l;
        }
        this.field_16258.method_15405("connection");
        this.method_3787().method_14357();
        this.field_16258.method_15405("players");
        this.field_4550.method_14601();
        this.field_16258.method_15405("server gui refresh");
        for (int i = 0; i < this.field_4568.size(); ++i) {
            this.field_4568.get(i).run();
        }
        this.field_16258.method_15407();
    }

    public boolean method_3839() {
        return true;
    }

    public void method_3742(Runnable runnable) {
        this.field_4568.add(runnable);
    }

    public static void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u26032 = optionParser.accepts("nogui");
        OptionSpecBuilder \u26033 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u26034 = optionParser.accepts("demo");
        OptionSpecBuilder \u26035 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u26036 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u26037 = optionParser.accepts("eraseCache");
        AbstractOptionSpec \u26038 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u26039 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260311 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260312 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260313 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u260314 = optionParser.nonOptions();
        try {
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u26038)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            Path \u260315 = Paths.get("server.properties", new String[0]);
            class_3807 \u260316 = new class_3807(\u260315);
            \u260316.method_16719();
            Path \u260317 = Paths.get("eula.txt", new String[0]);
            class_2981 \u260318 = new class_2981(\u260317);
            if (optionSet.has((OptionSpec)\u26033)) {
                field_4546.info("Initialized '" + \u260315.toAbsolutePath().toString() + "' and '" + \u260317.toAbsolutePath().toString() + "'");
                return;
            }
            if (!\u260318.method_12866()) {
                field_4546.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            class_2966.method_12851();
            class_2966.method_17598();
            String \u260319 = (String)optionSet.valueOf((OptionSpec)\u260310);
            YggdrasilAuthenticationService \u260320 = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService \u260321 = \u260320.createMinecraftSessionService();
            GameProfileRepository \u260322 = \u260320.createProfileRepository();
            class_3312 \u260323 = new class_3312(\u260322, new File(\u260319, field_4588.getName()));
            String \u260324 = (String)Optional.ofNullable(optionSet.valueOf((OptionSpec)\u260311)).orElse(\u260316.method_16717().field_16820);
            final class_3176 \u260325 = new class_3176(new File(\u260319), \u260316, class_3551.method_15450(), \u260320, \u260321, \u260322, \u260323, class_3951::new, \u260324);
            \u260325.method_3817((String)optionSet.valueOf((OptionSpec)\u26039));
            \u260325.method_3779((Integer)optionSet.valueOf((OptionSpec)\u260312));
            \u260325.method_3730(optionSet.has((OptionSpec)\u26034));
            \u260325.method_3778(optionSet.has((OptionSpec)\u26035));
            \u260325.method_3797(optionSet.has((OptionSpec)\u26036));
            \u260325.method_20383(optionSet.has((OptionSpec)\u26037));
            \u260325.method_17819((String)optionSet.valueOf((OptionSpec)\u260313));
            boolean bl = \u2603 = !optionSet.has((OptionSpec)\u26032) && !optionSet.valuesOf((OptionSpec)\u260314).contains("nogui");
            if (\u2603 && !GraphicsEnvironment.isHeadless()) {
                \u260325.method_13948();
            }
            \u260325.method_3717();
            Thread \u260326 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    \u260325.method_3747(true);
                }
            };
            \u260326.setUncaughtExceptionHandler(new class_140(field_4546));
            Runtime.getRuntime().addShutdownHook(\u260326);
        }
        catch (Exception exception) {
            field_4546.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    protected void method_17819(String string) {
        this.field_17601 = string;
    }

    protected void method_3797(boolean bl) {
        this.field_4586 = bl;
    }

    protected void method_20383(boolean bl) {
        this.field_19237 = bl;
    }

    public void method_3717() {
        this.field_16257.start();
    }

    public boolean method_16043() {
        return !this.field_16257.isAlive();
    }

    public File method_3758(String string) {
        return new File(this.method_3831(), string);
    }

    public void method_3720(String string) {
        field_4546.info(string);
    }

    public void method_3743(String string) {
        field_4546.warn(string);
    }

    public class_3218 method_3847(class_2874 class_28742) {
        return this.field_4589.get(class_28742);
    }

    public Iterable<class_3218> method_3738() {
        return this.field_4589.values();
    }

    public String method_3827() {
        return class_155.method_16673().getName();
    }

    public int method_3788() {
        return this.field_4550.method_14574();
    }

    public int method_3802() {
        return this.field_4550.method_14592();
    }

    public String[] method_3858() {
        return this.field_4550.method_14580();
    }

    public boolean method_3766() {
        return false;
    }

    public void method_3762(String string) {
        field_4546.error(string);
    }

    public void method_3770(String string) {
        if (this.method_3766()) {
            field_4546.info(string);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public class_128 method_3859(class_128 class_12810) {
        if (this.field_4550 != null) {
            class_12810.method_567().method_577("Player Count", () -> this.field_4550.method_14574() + " / " + this.field_4550.method_14592() + "; " + this.field_4550.method_14571());
        }
        class_12810.method_567().method_577("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (class_3288 class_32882 : this.field_4595.method_14444()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(class_32882.method_14463());
                if (class_32882.method_14460().method_14437()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.field_17601 != null) {
            class_12810.method_567().method_577("Server Id", () -> this.field_17601);
        }
        return class_12810;
    }

    public boolean method_3814() {
        return this.field_4605 != null;
    }

    @Override
    public void method_9203(class_2561 class_25612) {
        field_4546.info(class_25612.getString());
    }

    public KeyPair method_3716() {
        return this.field_4552;
    }

    public int method_3756() {
        return this.field_4555;
    }

    public void method_3779(int n) {
        this.field_4555 = n;
    }

    public String method_3811() {
        return this.field_4578;
    }

    public void method_3817(String string) {
        this.field_4578 = string;
    }

    public boolean method_3724() {
        return this.field_4578 != null;
    }

    public String method_3865() {
        return this.field_4565;
    }

    public void method_3849(String string) {
        this.field_4574 = string;
    }

    public String method_3726() {
        return this.field_4574;
    }

    public void method_3853(KeyPair keyPair) {
        this.field_4552 = keyPair;
    }

    public void method_3776(class_1267 class_12672, boolean bl) {
        for (class_3218 class_32182 : this.method_3738()) {
            class_31 class_3180 = class_32182.method_8401();
            if (!bl && class_3180.method_197()) continue;
            if (class_3180.method_152()) {
                class_3180.method_208(class_1267.field_5807);
                class_32182.method_8424(true, true);
                continue;
            }
            if (this.method_3724()) {
                class_3180.method_208(class_12672);
                class_32182.method_8424(class_32182.method_8407() != class_1267.field_5801, true);
                continue;
            }
            class_3180.method_208(class_12672);
            class_32182.method_8424(this.method_3783(), this.field_4575);
        }
        this.method_3760().method_14571().forEach(this::method_19465);
    }

    public void method_19467(boolean bl) {
        for (class_3218 class_32182 : this.method_3738()) {
            class_31 class_3180 = class_32182.method_8401();
            class_3180.method_186(bl);
        }
        this.method_3760().method_14571().forEach(this::method_19465);
    }

    private void method_19465(class_3222 class_32222) {
        class_31 class_3180 = class_32222.method_14220().method_8401();
        class_32222.field_13987.method_14364(new class_2632(class_3180.method_207(), class_3180.method_197()));
    }

    protected boolean method_3783() {
        return true;
    }

    public boolean method_3799() {
        return this.field_4549;
    }

    public void method_3730(boolean bl) {
        this.field_4549 = bl;
    }

    public void method_3778(boolean bl) {
        this.field_4569 = bl;
    }

    public class_32 method_3781() {
        return this.field_4606;
    }

    public String method_3784() {
        return this.field_4607;
    }

    public String method_3805() {
        return this.field_4584;
    }

    public void method_3843(String string, String string2) {
        this.field_4607 = string;
        this.field_4584 = string2;
    }

    @Override
    public void method_5495(class_1276 class_127622) {
        class_1276 class_127622;
        class_127622.method_5481("whitelist_enabled", false);
        class_127622.method_5481("whitelist_count", 0);
        if (this.field_4550 != null) {
            class_127622.method_5481("players_current", this.method_3788());
            class_127622.method_5481("players_max", this.method_3802());
            class_127622.method_5481("players_seen", this.method_3847(class_2874.field_13072).method_17982().method_263().length);
        }
        class_127622.method_5481("uses_auth", this.field_4543);
        class_127622.method_5481("gui_state", this.method_3727() ? "enabled" : "disabled");
        class_127622.method_5481("run_time", (class_156.method_658() - class_127622.method_5484()) / 60L * 1000L);
        class_127622.method_5481("avg_tick_ms", (int)(class_3532.method_15373(this.field_4573) * 1.0E-6));
        int n = 0;
        for (class_3218 class_32182 : this.method_3738()) {
            if (class_32182 == null) continue;
            class_31 class_3180 = class_32182.method_8401();
            class_127622.method_5481("world[" + n + "][dimension]", class_32182.field_9247.method_12460());
            class_127622.method_5481("world[" + n + "][mode]", (Object)class_3180.method_210());
            class_127622.method_5481("world[" + n + "][difficulty]", (Object)class_32182.method_8407());
            class_127622.method_5481("world[" + n + "][hardcore]", class_3180.method_152());
            class_127622.method_5481("world[" + n + "][generator_name]", class_3180.method_153().method_8635());
            class_127622.method_5481("world[" + n + "][generator_version]", class_3180.method_153().method_8636());
            class_127622.method_5481("world[" + n + "][height]", this.field_4579);
            class_127622.method_5481("world[" + n + "][chunks_loaded]", class_32182.method_14178().method_14151());
            ++n;
        }
        class_127622.method_5481("worlds", n);
    }

    public abstract boolean method_3816();

    public boolean method_3828() {
        return this.field_4543;
    }

    public void method_3864(boolean bl) {
        this.field_4543 = bl;
    }

    public boolean method_3775() {
        return this.field_4560;
    }

    public void method_3764(boolean bl) {
        this.field_4560 = bl;
    }

    public boolean method_3796() {
        return this.field_4575;
    }

    public void method_3840(boolean bl) {
        this.field_4575 = bl;
    }

    public boolean method_3736() {
        return this.field_4590;
    }

    public abstract boolean method_3759();

    public void method_3769(boolean bl) {
        this.field_4590 = bl;
    }

    public boolean method_3852() {
        return this.field_4604;
    }

    public void method_3815(boolean bl) {
        this.field_4604 = bl;
    }

    public boolean method_3718() {
        return this.field_4554;
    }

    public void method_3745(boolean bl) {
        this.field_4554 = bl;
    }

    public abstract boolean method_3812();

    public String method_3818() {
        return this.field_4564;
    }

    public void method_3834(String string) {
        this.field_4564 = string;
    }

    public int method_3833() {
        return this.field_4579;
    }

    public void method_3850(int n) {
        this.field_4579 = n;
    }

    public boolean method_3750() {
        return this.field_4561;
    }

    public class_3324 method_3760() {
        return this.field_4550;
    }

    public void method_3846(class_3324 class_33242) {
        this.field_4550 = class_33242;
    }

    public abstract boolean method_3860();

    public void method_3838(class_1934 class_19342) {
        for (class_3218 class_32182 : this.method_3738()) {
            class_32182.method_8401().method_193(class_19342);
        }
    }

    @Nullable
    public class_3242 method_3787() {
        return this.field_4563;
    }

    public boolean method_3820() {
        return this.field_4547;
    }

    public boolean method_3727() {
        return false;
    }

    public abstract boolean method_3763(class_1934 var1, boolean var2, int var3);

    public int method_3780() {
        return this.field_4572;
    }

    public void method_3832() {
        this.field_4597 = true;
    }

    public class_1276 method_3795() {
        return this.field_4582;
    }

    public int method_3841() {
        return 16;
    }

    public boolean method_3785(class_1937 class_19372, class_2338 class_23382, class_1657 class_16572) {
        return false;
    }

    public void method_3794(boolean bl) {
        this.field_4545 = bl;
    }

    public boolean method_3761() {
        return this.field_4545;
    }

    public int method_3862() {
        return this.field_4596;
    }

    public void method_3803(int n) {
        this.field_4596 = n;
    }

    public MinecraftSessionService method_3844() {
        return this.field_4603;
    }

    public GameProfileRepository method_3719() {
        return this.field_4608;
    }

    public class_3312 method_3793() {
        return this.field_4556;
    }

    public class_2926 method_3765() {
        return this.field_4593;
    }

    public void method_3856() {
        this.field_4551 = 0L;
    }

    public int method_3749() {
        return 29999984;
    }

    @Override
    public boolean method_5384() {
        return super.method_5384() && !this.method_3750();
    }

    @Override
    public Thread method_3777() {
        return this.field_16257;
    }

    public int method_3773() {
        return 256;
    }

    public long method_3826() {
        return this.field_4571;
    }

    public DataFixer method_3855() {
        return this.field_4587;
    }

    public int method_3829(@Nullable class_3218 class_32182) {
        if (class_32182 != null) {
            return class_32182.method_8450().method_8356("spawnRadius");
        }
        return 10;
    }

    public class_2989 method_3851() {
        return this.field_4567;
    }

    public class_2991 method_3740() {
        return this.field_4591;
    }

    public void method_3848() {
        if (!this.method_18854()) {
            this.execute(this::method_3848);
            return;
        }
        this.method_3760().method_14617();
        this.field_4595.method_14445();
        this.method_3752(this.method_3847(class_2874.field_13072).method_8401());
        this.method_3760().method_14572();
    }

    private void method_3752(class_31 class_3180) {
        ArrayList arrayList = Lists.newArrayList(this.field_4595.method_14444());
        for (class_3288 class_32883 : this.field_4595.method_14441()) {
            if (class_3180.method_209().contains(class_32883.method_14463()) || arrayList.contains(class_32883)) continue;
            field_4546.info("Found new data pack {}, loading it automatically", (Object)class_32883.method_14463());
            class_32883.method_14466().method_14468(arrayList, class_32883, class_32882 -> class_32882, false);
        }
        this.field_4595.method_14447(arrayList);
        ArrayList arrayList2 = Lists.newArrayList();
        this.field_4595.method_14444().forEach(class_32882 -> arrayList2.add(class_32882.method_14458()));
        CompletableFuture<class_3902> completableFuture = this.field_4576.method_14478(this.field_17200, this, arrayList2, CompletableFuture.completedFuture(class_3902.field_17274));
        this.method_18857(completableFuture::isDone);
        class_3180.method_179().clear();
        class_3180.method_209().clear();
        this.field_4595.method_14444().forEach(class_32882 -> class_3180.method_179().add(class_32882.method_14463()));
        this.field_4595.method_14441().forEach(class_32882 -> {
            if (!this.field_4595.method_14444().contains(class_32882)) {
                class_3180.method_209().add(class_32882.method_14463());
            }
        });
    }

    public void method_3728(class_2168 class_21682) {
        if (!this.method_3729()) {
            return;
        }
        class_3324 class_33242 = class_21682.method_9211().method_3760();
        class_3337 \u26032 = class_33242.method_14590();
        if (!\u26032.method_14639()) {
            return;
        }
        ArrayList \u26033 = Lists.newArrayList(class_33242.method_14571());
        for (class_3222 class_32222 : \u26033) {
            if (\u26032.method_14653(class_32222.method_7334())) continue;
            class_32222.field_13987.method_14367(new class_2588("multiplayer.disconnect.not_whitelisted", new Object[0]));
        }
    }

    public class_3296 method_3809() {
        return this.field_4576;
    }

    public class_3283<class_3288> method_3836() {
        return this.field_4595;
    }

    public class_2170 method_3734() {
        return this.field_4562;
    }

    public class_2168 method_3739() {
        return new class_2168(this, this.method_3847(class_2874.field_13072) == null ? class_243.field_1353 : new class_243(this.method_3847(class_2874.field_13072).method_8395()), class_241.field_1340, this.method_3847(class_2874.field_13072), 4, "Server", new class_2585("Server"), this, null);
    }

    @Override
    public boolean method_9200() {
        return true;
    }

    @Override
    public boolean method_9202() {
        return true;
    }

    public class_1863 method_3772() {
        return this.field_4566;
    }

    public class_3505 method_3801() {
        return this.field_4583;
    }

    public class_2995 method_3845() {
        return this.field_4558;
    }

    public class_60 method_3857() {
        return this.field_4580;
    }

    public class_1928 method_3767() {
        return this.method_3847(class_2874.field_13072).method_8450();
    }

    public class_3004 method_3837() {
        return this.field_4548;
    }

    public boolean method_3729() {
        return this.field_4570;
    }

    public void method_3731(boolean bl) {
        this.field_4570 = bl;
    }

    public float method_3830() {
        return this.field_4592;
    }

    public int method_3835(GameProfile gameProfile) {
        if (this.method_3760().method_14569(gameProfile)) {
            class_3327 class_33272 = (class_3327)this.method_3760().method_14603().method_14640(gameProfile);
            if (class_33272 != null) {
                return class_33272.method_14623();
            }
            if (this.method_19466(gameProfile)) {
                return 4;
            }
            if (this.method_3724()) {
                return this.method_3760().method_14579() ? 4 : 0;
            }
            return this.method_3798();
        }
        return 0;
    }

    public class_3517 method_15876() {
        return this.field_16205;
    }

    public class_3689 method_16044() {
        return this.field_16258;
    }

    public Executor method_17191() {
        return this.field_17200;
    }

    public abstract boolean method_19466(GameProfile var1);

    @Override
    public /* synthetic */ boolean method_18856(Runnable runnable) {
        return this.method_19464((class_3738)runnable);
    }

    @Override
    public /* synthetic */ Runnable method_16211(Runnable runnable) {
        return this.method_16209(runnable);
    }

    private static /* synthetic */ long[] method_3757(class_2874 class_28742) {
        return new long[100];
    }
}

